/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130;

import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.time.SortTool;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class NCFile {
    public static final String NC_FILE_LOC = "NCFile";
    public MicroSecondDate network_begin_time;
    private List keyListForIdToName;
    private List keyListForNameToId;
    private Map timeAndDataMapIdToName;
    private Map timeAndDataMapNameToId;
    private File file;
    private static final Logger logger = Logger.getLogger((Class)NCFile.class);

    public NCFile(String ncFileLocation) throws IOException {
        this.file = new File(ncFileLocation);
        FileInputStream fis = new FileInputStream(this.file);
        BufferedInputStream bis = new BufferedInputStream(fis);
        DataInputStream dis = new DataInputStream(bis);
        this.readFile(dis);
    }

    private void readFile(DataInput in) throws IOException {
        this.timeAndDataMapIdToName = new HashMap();
        this.timeAndDataMapNameToId = new HashMap();
        boolean done = false;
        String data = "";
        String line = "";
        while (!done) {
            try {
                line = in.readLine();
                if (line == null) {
                    done = true;
                    continue;
                }
                if (line.startsWith("#")) continue;
                data = data.concat(line);
                data = data + "\n";
            }
            catch (EOFException e) {
                done = true;
            }
        }
        StringTokenizer st = new StringTokenizer(data);
        String token = "";
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (!token.equals("START")) continue;
            MicroSecondDate time = this.stringToMicroSecondDate(st.nextToken());
            if (this.network_begin_time == null) {
                this.network_begin_time = time;
            }
            HashMap<String, String> idToName = new HashMap<String, String>();
            HashMap<String, String> nameToId = new HashMap<String, String>();
            while (!st.nextToken().startsWith("chan/dip/azi")) {
            }
            String temp = st.nextToken();
            while (!temp.startsWith("END")) {
                String unitName = temp;
                String unitId = st.nextToken().substring(0, 4);
                idToName.put(unitId, unitName);
                nameToId.put(unitName, unitId);
                st.nextToken();
                st.nextToken();
                temp = st.nextToken();
            }
            this.timeAndDataMapIdToName.put(time, idToName);
            this.timeAndDataMapNameToId.put(time, nameToId);
        }
        Set keySet1 = this.timeAndDataMapIdToName.keySet();
        MicroSecondDate[] keyArray1 = keySet1.toArray(new MicroSecondDate[0]);
        this.keyListForIdToName = new ArrayList(keyArray1.length);
        for (int i = 0; i < keyArray1.length; ++i) {
            this.keyListForIdToName.add(keyArray1[i]);
        }
        Collections.sort(this.keyListForIdToName, new SortTool.AscendingTimeSorter());
        Set keySet2 = this.timeAndDataMapNameToId.keySet();
        MicroSecondDate[] keyArray2 = keySet2.toArray(new MicroSecondDate[0]);
        this.keyListForNameToId = new ArrayList(keyArray2.length);
        for (int i = 0; i < keyArray2.length; ++i) {
            this.keyListForNameToId.add(keyArray2[i]);
        }
        Collections.sort(this.keyListForNameToId, new SortTool.AscendingTimeSorter());
    }

    private MicroSecondDate stringToMicroSecondDate(String timeString) {
        StringTokenizer st = new StringTokenizer(timeString, ":");
        int yearInt = Integer.parseInt(st.nextToken());
        int daysOfYearInt = Integer.parseInt(st.nextToken());
        int hoursInt = Integer.parseInt(st.nextToken());
        ISOTime isoTime = new ISOTime(yearInt, daysOfYearInt, hoursInt, 0, 0.0f);
        return isoTime.getDate();
    }

    public String getUnitName(MicroSecondDate time, String unitId) {
        MicroSecondDate[] keyArray = this.keyListForIdToName.toArray(new MicroSecondDate[0]);
        for (int i = 0; i < keyArray.length; ++i) {
            Map idToName;
            if (!time.after((Date)keyArray[i]) || !(idToName = (Map)this.timeAndDataMapIdToName.get(keyArray[i])).containsKey(unitId)) continue;
            return (String)idToName.get(unitId);
        }
        logger.warn((Object)("Unit name for DAS unit number " + unitId + " was not found in the NC file."));
        logger.warn((Object)("The name \"" + unitId + "\" will be used instead."));
        logger.warn((Object)("The time requested was: " + time.toString()));
        return unitId;
    }

    public String getUnitId(MicroSecondDate time, String unitName) {
        MicroSecondDate[] keyArray = this.keyListForNameToId.toArray(new MicroSecondDate[0]);
        for (int i = 0; i < keyArray.length; ++i) {
            Map nameToId;
            if (!time.after((Date)keyArray[i]) || !(nameToId = (Map)this.timeAndDataMapNameToId.get(keyArray[i])).containsKey(unitName)) continue;
            return (String)nameToId.get(unitName);
        }
        logger.warn((Object)("Unit number for DAS unit name " + unitName + " was not found in the NC file."));
        logger.warn((Object)("The number \"" + unitName + "\" will be used instead."));
        logger.warn((Object)("The time requested was: " + time.toString()));
        return unitName;
    }

    public String getCanonicalPath() throws IOException {
        return this.file.getCanonicalPath();
    }
}

