/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.map.layers;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.sc.seis.fissuresUtil.display.EQDataEvent;
import edu.sc.seis.fissuresUtil.display.EQSelectionEvent;
import edu.sc.seis.fissuresUtil.display.EventTableModel;
import edu.sc.seis.fissuresUtil.map.OpenMap;
import edu.sc.seis.fissuresUtil.map.colorizer.event.EventColorizer;
import edu.sc.seis.fissuresUtil.map.layers.EventLayer;
import java.util.ArrayList;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EventTableLayer
extends EventLayer {
    private EventTableModel tableModel;
    private ListSelectionModel selectionModel;

    public EventTableLayer(EventTableModel tableModel, ListSelectionModel lsm, OpenMap map, EventColorizer colorizer) {
        super(map, colorizer);
        this.setName("Event Table Layer");
        this.tableModel = tableModel;
        this.selectionModel = lsm;
        this.addEQSelectionListener(this);
        tableModel.addEventDataListener(this);
        this.eventDataChanged(new EQDataEvent(tableModel.getAllEvents()));
        this.selectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                EventAccessOperations[] selectedEvents = EventTableLayer.this.getSelectedEvents();
                if (selectedEvents.length > 0) {
                    EventTableLayer.this.fireEQSelectionChanged(new EQSelectionEvent(this, selectedEvents));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectEvent(EventAccessOperations evo) {
        EventAccessOperations[] eventAccessOperationsArray = this.tableModel.getAllEvents();
        synchronized (eventAccessOperationsArray) {
            int rowToSelect = this.tableModel.getRowForEvent(evo);
            if (rowToSelect != -1) {
                this.selectionModel.setSelectionInterval(rowToSelect, rowToSelect);
            }
        }
    }

    public EventTableModel getTableModel() {
        return this.tableModel;
    }

    public EventAccessOperations[] getSelectedEvents() {
        ArrayList<EventAccessOperations> selectedEvents = new ArrayList<EventAccessOperations>();
        EventAccessOperations[] allEvents = this.tableModel.getAllEvents();
        for (int i = 0; i < allEvents.length; ++i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            selectedEvents.add(allEvents[i]);
        }
        return selectedEvents.toArray(new EventAccessOperations[0]);
    }
}

