/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.map;

import com.bbn.openmap.BufferedMapBean;
import com.bbn.openmap.InformationDelegator;
import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.MultipleSoloMapComponentException;
import com.bbn.openmap.event.CenterEvent;
import com.bbn.openmap.event.LayerStatusEvent;
import com.bbn.openmap.event.LayerStatusListener;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.event.ZoomEvent;
import com.bbn.openmap.event.ZoomListener;
import com.bbn.openmap.gui.OMComponentPanel;
import com.bbn.openmap.image.SunJPEGFormatter;
import com.bbn.openmap.layer.etopo.ETOPOLayer;
import com.bbn.openmap.layer.shape.ShapeLayer;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import edu.sc.seis.fissuresUtil.exceptionHandler.ExceptionReporterUtils;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.map.colorizer.event.DepthEventColorizer;
import edu.sc.seis.fissuresUtil.map.layers.ColorMapEtopoLayer;
import edu.sc.seis.fissuresUtil.map.layers.DistanceLayer;
import edu.sc.seis.fissuresUtil.map.layers.EventLayer;
import edu.sc.seis.fissuresUtil.map.layers.EventTableLayer;
import edu.sc.seis.fissuresUtil.map.layers.FissuresGraticuleLayer;
import edu.sc.seis.fissuresUtil.map.layers.FissuresShapeLayer;
import edu.sc.seis.fissuresUtil.map.layers.OverriddenOMLayer;
import edu.sc.seis.fissuresUtil.map.layers.ShapeLayerPropertiesHandler;
import edu.sc.seis.fissuresUtil.map.layers.StationLayer;
import edu.sc.seis.fissuresUtil.map.tools.PanTool;
import edu.sc.seis.fissuresUtil.map.tools.ZoomTool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class OpenMap
extends OMComponentPanel
implements LayerStatusListener,
ProjectionListener {
    public static final Color WATER = new Color(54, 179, 221);
    public static final float DEFAULT_SCALE = 2.0E8f;
    private LatLonPoint originalCenter = new LatLonPoint(0.0f, 0.0f);
    private float originalScale = 2.0E8f;
    private MapHandler mapHandler;
    private LayerHandler lh;
    private EventLayer el;
    private StationLayer stl;
    private DistanceLayer dl;
    private ETOPOLayer topol;
    private MapBean mapBean;
    private MouseDelegator mouseDelegator;
    private Map layerStatusMap = new HashMap();
    private static Logger logger = Logger.getLogger((Class)OpenMap.class);
    private List shapeLayers = new ArrayList();

    public OpenMap() {
        this(true);
    }

    public OpenMap(boolean graticule) {
        this(ShapeLayerPropertiesHandler.getProperties(), graticule);
        this.setEventLayer(new EventLayer(this, new DepthEventColorizer()));
        this.setStationLayer(new StationLayer());
    }

    public OpenMap(Properties shapeLayerProps) {
        this(shapeLayerProps, true);
    }

    public OpenMap(Properties[] shapeLayerProps) {
        this(shapeLayerProps, true);
    }

    public OpenMap(Properties shapeLayerProps, boolean graticule) {
        this(new Properties[]{shapeLayerProps}, null, graticule);
    }

    public OpenMap(Properties[] shapeLayerProps, boolean graticule) {
        this(shapeLayerProps, null, graticule);
    }

    public OpenMap(Properties shapeLayerProps, Projection projection) {
        this(new Properties[]{shapeLayerProps}, projection, true);
    }

    public OpenMap(Properties[] shapeLayerProps, Projection projection) {
        this(shapeLayerProps, projection, true);
    }

    public OpenMap(Properties[] shapeLayerProps, Projection projection, boolean graticule) {
        try {
            this.setLayout(new BorderLayout());
            this.mapHandler = new MapHandler();
            this.mapHandler.add((Object)this);
            this.mapBean = this.getMapBean();
            this.mapBean.addProjectionListener((ProjectionListener)this);
            if (projection != null) {
                this.mapBean.setProjection(projection);
            }
            this.originalCenter = this.mapBean.getProjection().getCenter();
            this.originalScale = this.mapBean.getScale();
            this.mapBean.setBackgroundColor(WATER);
            this.mapHandler.add((Object)this.mapBean);
            this.lh = new LayerHandler();
            this.mapHandler.add((Object)this.lh);
            for (int i = 0; i < shapeLayerProps.length; ++i) {
                FissuresShapeLayer shapeLayer = new FissuresShapeLayer();
                shapeLayer.addLayerStatusListener(this);
                shapeLayer.setProperties(shapeLayerProps[i]);
                shapeLayer.setVisible(true);
                this.shapeLayers.add(shapeLayer);
                this.mapHandler.add((Object)shapeLayer);
                this.lh.addLayer((Layer)shapeLayer);
                this.updateShapeLayerProps();
            }
            if (graticule) {
                FissuresGraticuleLayer gl = new FissuresGraticuleLayer();
                Properties graticuleLayerProps = gl.getProperties(new Properties());
                graticuleLayerProps.setProperty("prettyName", "Graticule Layer");
                graticuleLayerProps.setProperty("show1And5Lines", "true");
                graticuleLayerProps.setProperty("threshold", "3");
                graticuleLayerProps.setProperty("10DegreeColor", "88888888");
                graticuleLayerProps.setProperty("5DegreeColor", "88666666");
                graticuleLayerProps.setProperty("1DegreeColor", "88AAAAAA");
                gl.setProperties(graticuleLayerProps);
                gl.setShowRuler(true);
                this.mapHandler.add((Object)gl);
                this.lh.addLayer((Layer)gl, 0);
            }
            InformationDelegator infoDel = new InformationDelegator();
            infoDel.setShowLights(false);
            this.mouseDelegator = new MouseDelegator();
            this.mapHandler.add((Object)this.mouseDelegator);
            this.mapHandler.add((Object)infoDel);
        }
        catch (MultipleSoloMapComponentException msmce) {
            GlobalExceptionHandler.handle(msmce);
        }
    }

    public void updateShapeLayerProps() {
        ShapeLayer[] layers = this.getShapeLayers();
        for (int i = 0; i < layers.length; ++i) {
            Properties p = new Properties();
            layers[i].getProperties(p);
            int threshold = Integer.parseInt((String)p.get("lineWidthThreshold"));
            if (threshold >= 0) {
                int overviewWidth = Integer.parseInt((String)p.get("overviewLineWidth"));
                if (overviewWidth <= 0) {
                    overviewWidth = 1;
                }
                if (this.mapBean.getScale() < (float)threshold) {
                    p.setProperty("lineWidth", "" + overviewWidth + 1);
                } else {
                    p.setProperty("lineWidth", "" + overviewWidth);
                }
            }
            layers[i].setProperties(p);
        }
    }

    public void setStationLayer(StationLayer staLayer) {
        this.stl = staLayer;
        staLayer.addLayerStatusListener(this);
        this.mapHandler.add((Object)this.stl);
        this.lh.addLayer((Layer)this.stl, 0);
        this.listenToEventLayer(staLayer);
    }

    private void listenToEventLayer(StationLayer staLayer) {
        if (this.el != null) {
            this.el.addEQSelectionListener(staLayer);
            if (this.el instanceof EventTableLayer) {
                ((EventTableLayer)this.el).getTableModel().addEventDataListener(staLayer);
            }
        }
    }

    public StationLayer getStationLayer() {
        return this.stl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEventLayer(EventLayer evl) {
        OpenMap openMap = this;
        synchronized (openMap) {
            if (this.el != null) {
                this.el.removeLayerStatusListener(this);
                this.mapHandler.remove((Object)this.el);
                this.lh.removeLayer((Layer)this.el);
                this.dl.removeLayerStatusListener(this);
                this.mapHandler.remove((Object)this.dl);
                this.lh.removeLayer((Layer)this.dl);
                if (this.stl != null) {
                    this.el.removeEQSelectionListener(this.stl);
                }
                if (this.el instanceof EventTableLayer) {
                    ((EventTableLayer)this.el).getTableModel().removeEventDataListener(this.stl);
                }
            }
            this.el = evl;
            this.el.addLayerStatusListener(this);
            this.mapHandler.add((Object)this.el);
            this.lh.addLayer((Layer)this.el, 0);
            this.dl = new DistanceLayer(this.mapBean);
            this.dl.addLayerStatusListener(this);
            this.el.addEQSelectionListener(this.dl);
            this.mapHandler.add((Object)this.dl);
            this.lh.addLayer((Layer)this.dl, 1);
            if (this.el instanceof EventTableLayer) {
                ((EventTableLayer)this.el).getTableModel().addEventDataListener(this.dl);
            }
            if (this.stl != null) {
                this.listenToEventLayer(this.stl);
            }
        }
    }

    public EventLayer getEventLayer() {
        return this.el;
    }

    public void setEtopoLayer(ETOPOLayer topoLayer) {
        this.topol = topoLayer;
        this.topol.addLayerStatusListener((LayerStatusListener)this);
        this.mapHandler.add((Object)this.topol);
        this.lh.addLayer((Layer)this.topol, this.lh.getLayers().length);
        for (int i = 0; i < this.shapeLayers.size(); ++i) {
            FissuresShapeLayer cur = (FissuresShapeLayer)this.shapeLayers.get(i);
            Properties props = cur.getProperties(null);
            props.remove("fillColor");
            cur.setProperties(props);
            cur.repaint();
        }
    }

    public void setEtopoLayer(String etopoDir) {
        this.setEtopoLayer(etopoDir, null);
    }

    public void setEtopoLayer(String etopoDir, String colorMapFilename) {
        this.setEtopoLayer(etopoDir, colorMapFilename, 15);
    }

    public void setEtopoLayer(String etopoDir, String colorMapFilename, int minuteSpacing) {
        ColorMapEtopoLayer topoLayer = null;
        try {
            topoLayer = colorMapFilename == null ? new ColorMapEtopoLayer() : new ColorMapEtopoLayer(colorMapFilename);
        }
        catch (Exception e) {
            GlobalExceptionHandler.handle("problem loading color map for etopo layer", e);
        }
        Properties etopoProps = new Properties();
        etopoProps.put("path", etopoDir);
        etopoProps.put("prettyName", "ETOPO Layer");
        etopoProps.put("number.colors", "216");
        etopoProps.put("opaque", "255");
        etopoProps.put("view.type", "1");
        etopoProps.put("minute.spacing", Integer.toString(minuteSpacing));
        etopoProps.put("contrast", "5");
        topoLayer.setProperties(etopoProps);
        topoLayer.setVisible(true);
        this.setEtopoLayer((ETOPOLayer)topoLayer);
    }

    public ETOPOLayer getETOPOLayer() {
        return this.topol;
    }

    public FissuresShapeLayer getGlobalShapeLayer() {
        return (FissuresShapeLayer)this.shapeLayers.get(0);
    }

    public ShapeLayer[] getShapeLayers() {
        return this.shapeLayers.toArray(new ShapeLayer[0]);
    }

    public ShapeLayer getShapeLayer(String prettyName) {
        ShapeLayer[] layers = this.getShapeLayers();
        for (int i = 0; i < layers.length; ++i) {
            ShapeLayer cfr_ignored_0 = layers[i];
            if (!"prettyName".equals(prettyName)) continue;
            return layers[i];
        }
        return null;
    }

    public DistanceLayer getDistanceLayer() {
        return this.dl;
    }

    public Layer[] getLayers() {
        return this.lh.getLayers();
    }

    public MapBean getMapBean() {
        if (this.mapBean == null) {
            MapBean.suppressCopyright = true;
            this.mapBean = new BufferedMapBean();
        }
        return this.mapBean;
    }

    public LatLonPoint getOriginalCenter() {
        return this.originalCenter;
    }

    public void setOriginalCenter(LatLonPoint llp) {
        this.originalCenter = llp;
    }

    public void setOriginalScale(float scale) {
        this.originalScale = scale;
    }

    public float getOriginalScale() {
        return this.originalScale;
    }

    public void setZoom(float zoomFactor) {
        this.mapBean.zoom(new ZoomEvent((Object)this, 302, zoomFactor));
    }

    public void addMouseMode(MapMouseMode mode) {
        this.mouseDelegator.addMouseMode(mode);
        if (mode instanceof ZoomTool) {
            ((ZoomTool)mode).addZoomListener((ZoomListener)this.getMapBean());
        }
    }

    public void setActiveMouseMode(MapMouseMode mode) {
        this.mouseDelegator.setActiveMouseMode(mode);
    }

    public void updateLayerStatus(LayerStatusEvent event) {
        this.layerStatusMap.put(event.getLayer(), new Integer(event.getStatus()));
    }

    public int getLayerStatus(Layer layer) {
        Integer statusObj = (Integer)this.layerStatusMap.get(this.shapeLayers.get(0));
        return statusObj;
    }

    public void overrideProjChangedInOMLayers(boolean override) {
        Layer[] layers = this.getLayers();
        for (int i = 0; i < layers.length; ++i) {
            Layer cur = layers[i];
            if (cur instanceof OverriddenOMLayer) {
                ((OverriddenOMLayer)cur).setOverrideProjectionChanged(override);
            }
            if (!(cur instanceof ShapeLayer)) continue;
            ((ShapeLayer)cur).projectionChanged(new ProjectionEvent((Object)this, null));
        }
    }

    public void projectionChanged(ProjectionEvent e) {
        this.updateShapeLayerProps();
    }

    public void writeMapToJPEG(String filename) throws IOException {
        File loc = new File(filename);
        File parent = loc.getParentFile();
        parent.mkdirs();
        File temp = File.createTempFile(loc.getName(), null, parent);
        SunJPEGFormatter formatter = new SunJPEGFormatter();
        formatter.setImageQuality(0.8f);
        byte[] imgBytes = formatter.getImageFromMapBean(this.mapBean);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(temp));
        bos.write(imgBytes);
        bos.flush();
        bos.close();
        loc.delete();
        temp.renameTo(loc);
    }

    public void writeMapToPNG(String filename) throws IOException {
        this.writeMapToPNG(new File(filename));
    }

    public void writeMapToPNG(File loc) throws IOException {
        File parent = loc.getAbsoluteFile().getParentFile();
        parent.mkdirs();
        File temp = File.createTempFile(loc.getName(), null, parent);
        this.writeMapToPNG(new BufferedOutputStream(new FileOutputStream(temp)));
        loc.delete();
        temp.renameTo(loc);
        logger.debug((Object)(ExceptionReporterUtils.getMemoryUsage() + " after write image to file"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMapToPNG(OutputStream out) throws IOException {
        Class clazz = OpenMap.class;
        synchronized (clazz) {
            try {
                this.getGlobalShapeLayer().setOverrideProjectionChanged(true);
                Projection proj = this.mapBean.getProjection();
                int w = proj.getWidth();
                int h = proj.getHeight();
                logger.debug((Object)(ExceptionReporterUtils.getMemoryUsage() + " before make Buf Image"));
                BufferedImage bufImg = new BufferedImage(w, h, 1);
                Graphics g = bufImg.getGraphics();
                g.setColor(WATER);
                g.fillRect(0, 0, w, h);
                Layer[] layers = this.getLayers();
                for (int i = layers.length - 1; i >= 0; --i) {
                    logger.debug((Object)("rendering " + layers[i].getName()));
                    layers[i].renderDataForProjection(proj, g);
                }
                ImageIO.write((RenderedImage)bufImg, "png", out);
            }
            finally {
                out.close();
                this.getGlobalShapeLayer().setOverrideProjectionChanged(false);
            }
        }
    }

    public float getWidthDegrees() {
        Projection proj = this.getMapBean().getProjection();
        float distL2C = ProjMath.lonDistance((float)proj.getUpperLeft().radlon_, (float)proj.getCenter().radlon_);
        float distC2R = ProjMath.lonDistance((float)proj.getCenter().radlon_, (float)proj.getLowerRight().radlon_);
        return Length.DECIMAL_DEGREE.fromRadians(Math.abs(distL2C + distC2R));
    }

    public static String translateLayerStatus(int status) {
        switch (status) {
            case 8360: {
                return "DISTRESS!!!";
            }
            case 8359: {
                return "finished";
            }
            case 8342: {
                return "started";
            }
            case 8350: {
                return "updating status";
            }
        }
        return null;
    }

    public static void main(final String[] args) {
        BasicConfigurator.configure();
        final OpenMap om = new OpenMap();
        om.setActiveMouseMode(new PanTool(om));
        om.setEtopoLayer("edu/sc/seis/mapData");
        JButton reloadColorTable = new JButton("Reload Table");
        JFrame frame = new JFrame("OpenMap Test");
        reloadColorTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ETOPOLayer etopo = om.getETOPOLayer();
                if (etopo instanceof ColorMapEtopoLayer) {
                    try {
                        ((ColorMapEtopoLayer)etopo).setColorTable(args[2]);
                        om.getMapBean().center(new CenterEvent((Object)this, (float)Math.random(), (float)Math.random()));
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)((Object)om));
        frame.getContentPane().add((Component)reloadColorTable, "South");
        frame.setSize(640, 480);
        frame.show();
    }

    public void findAndInit(Object obj) {
        if (obj instanceof MapBean) {
            this.add((Component)((MapBean)obj), "Center");
        } else if (obj instanceof InformationDelegator) {
            InformationDelegator infoDel = (InformationDelegator)obj;
            this.add((Component)infoDel, "South");
        }
    }
}

