/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.drawable;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.fissuresUtil.bag.TauPUtil;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.TextTable;
import edu.sc.seis.fissuresUtil.display.UnitDisplayUtil;
import edu.sc.seis.fissuresUtil.display.drawable.Drawable;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableSeismogram;
import edu.sc.seis.fissuresUtil.display.registrar.AmpEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeEvent;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.StdAuxillaryDataNames;
import edu.sc.seis.fissuresUtil.xml.XMLDataSet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Category;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Flag
implements Drawable {
    private int prevDrawHeight = 0;
    static DecimalFormat twoDecimal = new DecimalFormat("0.00");
    private Area flag;
    private int prevLocation;
    private Color color = Color.RED;
    private boolean visible = true;
    private MicroSecondDate flagTime;
    private String name;
    private DrawableSeismogram seis;
    private static final int PADDING = 4;
    private static Category logger = Category.getInstance((String)Flag.class.getName());
    public static final String NAME = "Flag Name";
    public static final String ORIGIN_DIFF = "Time from Origin (s)";
    public static final String TAUP_P = "TauP P Wave (s)";
    public static final String TIME_DIFF_ORIG_P = "Prediction Difference (s)";
    public static final String DISTANCE_FROM_ORIG = "Distance From Origin (deg)";
    public static final String BACK_AZIMUTH = "Back Azimuth (deg)";
    public static final String CHANNEL = "Channel";
    public static final String EVENT_NAME = "Event Name";
    public static final String EVENT_LAT = "Event Latitude";
    public static final String EVENT_LON = "Event Longitude";
    public static final String EVENT_DEPTH = "Event Depth (km)";
    public static final String EVENT_MAG = "Magnitude";
    public static final String EVENT_ORIG = "Origin Time";
    public static final String TIME = "Flag Time";

    public Flag(MicroSecondDate flagTime, String name) {
        this(flagTime, name, null);
    }

    public Flag(MicroSecondDate flagTime, String name, DrawableSeismogram seis) {
        this.flagTime = flagTime;
        this.name = name;
        this.seis = seis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D canvas, Dimension size, TimeEvent timeEvent, AmpEvent ampEvent) {
        if (this.visible) {
            MicroSecondTimeRange timeRange = timeEvent.getTime();
            if (this.seis != null) {
                if (timeEvent.contains(this.seis.getSeismogram())) {
                    timeRange = timeEvent.getTime(this.seis.getSeismogram());
                } else {
                    DataSetSeismogram[] seismo = new DataSetSeismogram[]{this.seis.getSeismogram()};
                    this.seis.getParent().getTimeConfig().add(seismo);
                    this.seis.getParent().repaint();
                    return;
                }
            }
            if (this.flagTime.before((Date)timeRange.getBeginTime()) || this.flagTime.after((Date)timeRange.getEndTime())) {
                return;
            }
            canvas.setFont(DisplayUtils.BOLD_FONT);
            int location = this.getFlagLocation(size, timeRange);
            Rectangle2D.Float stringBounds = new Rectangle2D.Float();
            stringBounds.setRect(canvas.getFontMetrics().getStringBounds(this.name, canvas));
            if (this.flag == null || this.prevDrawHeight != size.height) {
                Flag flag = this;
                synchronized (flag) {
                    Area pole = new Area(new Rectangle(location, 0, 1, size.height));
                    this.flag = new Area(new Rectangle(location, 0, (int)(stringBounds.width + 4.0f), (int)(stringBounds.height + 4.0f)));
                    this.flag.add(pole);
                    this.prevLocation = location;
                    this.prevDrawHeight = size.height;
                }
            }
            Area area = this.flag;
            synchronized (area) {
                double xShift = location - this.prevLocation;
                this.flag.transform(AffineTransform.getTranslateInstance(xShift, 0.0));
                this.prevLocation = location;
            }
            canvas.setColor(this.color);
            canvas.fill(this.flag);
            canvas.setColor(Color.BLACK);
            canvas.setStroke(DisplayUtils.ONE_PIXEL_STROKE);
            canvas.draw(this.flag);
            if (SeismogramDisplay.PRINTING) {
                canvas.setColor(Color.WHITE);
            }
            canvas.drawString(this.name, (float)(location + 2), stringBounds.height - 2.0f);
        }
    }

    public int getFlagLocation(Dimension size, MicroSecondTimeRange timeRange) {
        double offset = this.flagTime.difference(timeRange.getBeginTime()).getValue() / timeRange.getInterval().getValue();
        int loc = (int)(offset * (double)size.width);
        return loc;
    }

    public static Flag getFlagFromElement(Element el) {
        String name = el.getAttribute("name");
        logger.debug((Object)("Flag name: " + name));
        logger.debug((Object)("Flag time from element: " + el.getAttribute("time")));
        MicroSecondDate time = new MicroSecondDate(new Time(el.getAttribute("time"), 0));
        logger.debug((Object)("Flag time: " + time.getFissuresTime().date_time));
        return new Flag(time, name);
    }

    public static Element createFlagElement(String name, MicroSecondDate time) throws ParserConfigurationException {
        Document doc = XMLDataSet.getDocumentBuilder().newDocument();
        Element el = doc.createElement("pickFlag");
        el.setAttribute("name", name);
        el.setAttribute("time", time.getFissuresTime().date_time);
        return el;
    }

    public static TextTable getFlagData(DataSetSeismogram dss, EventAccessOperations event, String[] template) {
        Arrival[] arrivals = null;
        TauPUtil taup = TauPUtil.getTauPUtil();
        arrivals = Flag.getArrivals(taup, dss, event);
        String[] header = Flag.getFlagDataHeader(template);
        TextTable table = new TextTable(header.length, true);
        Iterator it = dss.getAuxillaryDataKeys().iterator();
        while (it.hasNext()) {
            String cur = (String)it.next();
            ArrayList<String> dataCells = new ArrayList<String>();
            if (!cur.startsWith(StdAuxillaryDataNames.PICK_FLAG)) continue;
            Flag flag = Flag.getFlagFromElement((Element)dss.getAuxillaryData(cur));
            for (int i = 0; i < template.length; ++i) {
                if (template[i].equals(NAME)) {
                    dataCells.add(flag.getName());
                    continue;
                }
                if (template[i].equals(TIME)) {
                    dataCells.add(Flag.formatTime(flag.getFlagTime()));
                    continue;
                }
                if (template[i].equals(CHANNEL)) {
                    ChannelId chanId = dss.getRequestFilter().channel_id;
                    dataCells.add(chanId.network_id.network_code + '.' + chanId.station_code + '.' + chanId.site_code + '.' + chanId.channel_code);
                    continue;
                }
                if (template[i].equals(EVENT_NAME)) {
                    dataCells.add(EventUtil.getEventInfo(event, "LOC"));
                    continue;
                }
                if (template[i].equals(EVENT_MAG)) {
                    dataCells.add(EventUtil.getEventInfo(event, "MAG"));
                    continue;
                }
                if (template[i].equals(EVENT_ORIG)) {
                    dataCells.add(EventUtil.getEventInfo(event, "TIME"));
                    continue;
                }
                if (template[i].equals(EVENT_DEPTH)) {
                    dataCells.add(EventUtil.getEventInfo(event, "DEPTH DEPTH_UNIT"));
                    continue;
                }
                if (template[i].equals(EVENT_LAT)) {
                    dataCells.add(EventUtil.getEventInfo(event, "LAT"));
                    continue;
                }
                if (template[i].equals(EVENT_LON)) {
                    dataCells.add(EventUtil.getEventInfo(event, "LON"));
                    continue;
                }
                if (template[i].equals(ORIGIN_DIFF)) {
                    TimeInterval interval = Flag.getTimeDifferenceFromOrigin(flag, event);
                    QuantityImpl timeInSeconds = interval.convertTo(UnitImpl.SECOND);
                    dataCells.add(twoDecimal.format(timeInSeconds.get_value()));
                    continue;
                }
                if (template[i].equals(DISTANCE_FROM_ORIG)) {
                    QuantityImpl distance = DisplayUtils.calculateDistance(dss);
                    dataCells.add(UnitDisplayUtil.formatQuantityImpl((Quantity)distance));
                    continue;
                }
                if (template[i].equals(BACK_AZIMUTH)) {
                    QuantityImpl backAz = DisplayUtils.calculateBackAzimuth(dss);
                    dataCells.add(twoDecimal.format(backAz.get_value()));
                    continue;
                }
                if (template[i].equals(TAUP_P)) {
                    if (arrivals != null && arrivals.length > 0) {
                        dataCells.add(twoDecimal.format(Flag.getFirstPWaveInSeconds(arrivals).get_value()));
                        continue;
                    }
                    dataCells.add("...");
                    continue;
                }
                if (!template[i].equals(TIME_DIFF_ORIG_P)) continue;
                if (arrivals != null && arrivals.length > 0) {
                    TimeInterval timeDiff = Flag.getTimeDifferenceFromOrigin(flag, event);
                    TimeInterval timeDiffTauPDiff = timeDiff.subtract(Flag.getFirstPWaveInSeconds(arrivals));
                    QuantityImpl timeDiffTauPDiffConverted = timeDiffTauPDiff.convertTo(UnitImpl.SECOND);
                    dataCells.add(twoDecimal.format(timeDiffTauPDiffConverted.get_value()));
                    continue;
                }
                dataCells.add("...");
            }
            table.addRow(dataCells.toArray(new String[0]));
        }
        return table;
    }

    private static Arrival[] getArrivals(TauPUtil taup, DataSetSeismogram dss, EventAccessOperations event) {
        Station station = dss.getDataSet().getChannel((ChannelId)dss.getRequestFilter().channel_id).my_site.my_station;
        Origin origin = EventUtil.extractOrigin(event);
        try {
            Arrival[] arrivals = taup.calcTravelTimes(station, origin, new String[]{"ttp"});
            return arrivals;
        }
        catch (TauModelException e) {
            GlobalExceptionHandler.handle("problem calculating travel times", e);
            return null;
        }
    }

    private static TimeInterval getFirstPWaveInSeconds(Arrival[] arrivals) {
        return new TimeInterval(arrivals[0].getTime(), UnitImpl.SECOND);
    }

    private static String formatTime(MicroSecondDate msd) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:sss z");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf.format((Date)msd);
    }

    public static String[] getFlagDataHeader(String[] template) {
        ArrayList<String> dataCells = new ArrayList<String>();
        for (int i = 0; i < template.length; ++i) {
            if (template[i].equals(NAME)) {
                dataCells.add(NAME);
                continue;
            }
            if (template[i].equals(TIME)) {
                dataCells.add(TIME);
                continue;
            }
            if (template[i].equals(CHANNEL)) {
                dataCells.add(CHANNEL);
                continue;
            }
            if (template[i].equals(EVENT_NAME)) {
                dataCells.add(EVENT_NAME);
                continue;
            }
            if (template[i].equals(EVENT_MAG)) {
                dataCells.add(EVENT_MAG);
                continue;
            }
            if (template[i].equals(EVENT_ORIG)) {
                dataCells.add(EVENT_ORIG);
                continue;
            }
            if (template[i].equals(EVENT_DEPTH)) {
                dataCells.add(EVENT_DEPTH);
                continue;
            }
            if (template[i].equals(EVENT_LAT)) {
                dataCells.add(EVENT_LAT);
                continue;
            }
            if (template[i].equals(EVENT_LON)) {
                dataCells.add(EVENT_LON);
                continue;
            }
            if (template[i].equals(ORIGIN_DIFF)) {
                dataCells.add(ORIGIN_DIFF);
                continue;
            }
            if (template[i].equals(DISTANCE_FROM_ORIG)) {
                dataCells.add(DISTANCE_FROM_ORIG);
                continue;
            }
            if (template[i].equals(BACK_AZIMUTH)) {
                dataCells.add(BACK_AZIMUTH);
                continue;
            }
            if (template[i].equals(TAUP_P)) {
                dataCells.add(TAUP_P);
                continue;
            }
            if (!template[i].equals(TIME_DIFF_ORIG_P)) continue;
            dataCells.add(TIME_DIFF_ORIG_P);
        }
        return dataCells.toArray(new String[0]);
    }

    public static TimeInterval getTimeDifferenceFromOrigin(Flag flag, EventAccessOperations event) {
        Origin origin = EventUtil.extractOrigin(event);
        MicroSecondDate originTime = new MicroSecondDate(origin.origin_time);
        MicroSecondDate flagTime = flag.getFlagTime();
        return originTime.difference(flagTime);
    }

    public String getName() {
        return this.name;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setVisibility(boolean b) {
        this.visible = b;
    }

    public MicroSecondDate getFlagTime() {
        return this.flagTime;
    }

    public void setFlagTime(MicroSecondDate flagTime) {
        this.flagTime = flagTime;
    }
}

