/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Plottable;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.drawable.EventBoxes;
import edu.sc.seis.fissuresUtil.display.drawable.EventFlag;
import edu.sc.seis.fissuresUtil.display.drawable.PlottableSelection;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class PlottableDisplay
extends JComponent {
    public static final int ROWS = 12;
    public static final int TOTAL_WIDTH = 6000;
    public static final int OFFSET = 30;
    public int titleHeight = 140;
    public static final int LABEL_X_SHIFT = 50;
    private int rows = 12;
    private int totalWidth = 6000;
    private int rowWidth;
    private int rowOffset = 30;
    private boolean useFlags = true;
    private Color backgroundColor = Color.WHITE;
    private Color evenColor = Color.BLACK;
    private Color oddColor = Color.BLUE;
    private Color axisColor = Color.RED;
    private int totalHours = 24;
    private ChannelId channelId;
    private float ampScale = 1.0f;
    private float ampScalePercent = 1.0f;
    private Date date;
    private Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private PlottableSelection selection;
    private PlottableSelection tempSelection;
    private LinkedList eventPlotterList = new LinkedList();
    private Plottable[] arrayplottable = new Plottable[0];
    private String stationName = "";
    private String orientationName = "";
    private String dateName = "";
    private Image image = null;
    private Shape plottableShape = null;
    private Graphics currentImageGraphics = null;
    private boolean includeText;
    private static SimpleDateFormat dateFormater = new SimpleDateFormat("EEEE, d MMMM yyyy");
    private static Logger logger = Logger.getLogger((Class)PlottableDisplay.class);

    public PlottableDisplay() {
        this(6000);
    }

    public PlottableDisplay(int pixelsPerDay) {
        this(pixelsPerDay, true);
    }

    public PlottableDisplay(int pixelsPerDay, boolean includeText) {
        this.totalWidth = pixelsPerDay;
        this.rowWidth = this.totalWidth / this.rows;
        dateFormater.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.removeAll();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder()));
        this.setLayout(new BorderLayout());
        this.tempSelection = new PlottableSelection(this);
        this.selection = new PlottableSelection(this);
        this.configChanged();
        this.includeText = includeText;
        if (!includeText) {
            this.titleHeight = 30;
            this.configChanged();
        }
    }

    public void displayEventsAsBoxes() {
        this.useFlags = false;
    }

    public void displayEventsAsFlags() {
        this.useFlags = true;
    }

    public void setColors(Color even, Color odd, Color axis, Color background) {
        this.evenColor = even;
        this.oddColor = odd;
        this.axisColor = axis;
        this.backgroundColor = background;
    }

    public void setOffset(int offset) {
        if (this.rowOffset != offset) {
            this.rowOffset = offset;
            this.configChanged();
        }
    }

    public void setAmpScale(float ampScalePercent) {
        if (this.ampScalePercent != ampScalePercent) {
            this.ampScalePercent = ampScalePercent;
            this.configChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void configChanged() {
        this.currentImageGraphics = null;
        PlottableDisplay plottableDisplay = this;
        synchronized (plottableDisplay) {
            this.image = null;
        }
        int newWidth = this.totalWidth / this.rows + 100;
        int newHeight = this.rowOffset * this.rows + this.titleHeight;
        if (newHeight == this.getPreferredSize().height && newWidth == this.getPreferredSize().width) {
            this.repaint();
        } else {
            this.setPreferredSize(new Dimension(newWidth, newHeight));
            this.revalidate();
        }
    }

    public void setPlottable(Plottable[] clientPlott, String nameofstation, String orientationName, Date date, ChannelId channelId) {
        this.removeAll();
        this.arrayplottable = clientPlott;
        int[] minmax = this.findMinMax(this.arrayplottable);
        this.ampScale = (float)this.rowOffset * (1.0f / (float)(minmax[1] - minmax[0]));
        if (this.arrayplottable == null) {
            logger.warn((Object)"setPlottable:Plottable is NULL.");
            this.arrayplottable = new Plottable[0];
        }
        this.stationName = nameofstation;
        this.orientationName = orientationName;
        this.dateName = dateFormater.format(date);
        if (!date.equals(this.date)) {
            this.selection = new PlottableSelection(this);
        }
        this.date = date;
        this.calendar.setTime(date);
        this.channelId = channelId;
        this.plottableShape = this.makeShape(clientPlott);
        this.configChanged();
    }

    public void setPlottable(Plottable[] clientPlott, String nameofstation, String orientationName, Date date, ChannelId channelId, EventAccessOperations[] events, Arrival[][] arrivals) {
        this.eventPlotterList = new LinkedList();
        this.addEventPlotterInfo(events, arrivals);
        this.setPlottable(clientPlott, nameofstation, orientationName, date, channelId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        PlottableDisplay plottableDisplay = this;
        synchronized (plottableDisplay) {
            if (this.image == null) {
                this.image = this.createImage();
            } else {
                g.drawImage(this.image, 0, 0, this);
            }
        }
        this.drawEventFlags(g);
        this.drawSelection(g);
    }

    protected void drawComponent(Graphics g) {
        this.drawTitle(g);
        if (this.date != null) {
            this.drawTimeTicks(g, this.date);
        }
        if (this.arrayplottable == null) {
            logger.warn((Object)"Plottable is NULL.");
            return;
        }
        this.drawPlottableNew(g);
    }

    int[] drawTitle(int y, String title, String text, Graphics2D g2) {
        return this.drawTitle(y, title, text, g2, this.oddColor);
    }

    int[] drawTitle(int y, String title, String text, Graphics2D g2, Color color) {
        return this.drawTitle(y, 50, title, text, g2, color);
    }

    int[] drawTitle(int y, int x, String title, String text, Graphics2D g2, Color color) {
        g2.setPaint(color);
        g2.setFont(DisplayUtils.BOLD_FONT);
        FontMetrics fm = g2.getFontMetrics();
        Rectangle2D stringBounds = fm.getStringBounds(title, g2);
        int titleWidth = (int)stringBounds.getWidth();
        int titleHeight = (int)stringBounds.getHeight();
        g2.drawString(title, x, y);
        g2.setFont(DisplayUtils.DEFAULT_FONT);
        g2.drawString(text, x + titleWidth, y);
        stringBounds = fm.getStringBounds(text, g2);
        int[] heightWidth = new int[]{titleHeight, titleWidth + (int)stringBounds.getWidth()};
        return heightWidth;
    }

    void drawTitle(Graphics g) {
        if (this.includeText) {
            Graphics2D g2 = (Graphics2D)g;
            int titleYPos = 20;
            if (this.stationName.length() > 0) {
                titleYPos += this.drawTitle(titleYPos, "Station: ", this.stationName, g2)[0];
            }
            if (this.dateName.length() > 0) {
                titleYPos += this.drawTitle(titleYPos, "Date: ", this.dateName, g2)[0];
            }
            if (this.orientationName.length() > 0) {
                titleYPos += this.drawTitle(titleYPos, "Orientation: ", this.orientationName, g2)[0];
            }
            Iterator it = this.eventPlotterList.iterator();
            while (it.hasNext()) {
                EventFlag cur = (EventFlag)it.next();
                int[] size = this.drawTitle(titleYPos, 50, "Event: ", cur.getTitle(), g2, cur.getColor());
                cur.setTitleLoc(50, titleYPos - size[0], size[1], size[0]);
                titleYPos += size[0];
            }
            String myt = "Time";
            String mygmt = "GMT";
            g2.setPaint(this.evenColor);
            if (titleYPos < 30) {
                titleYPos = 40;
            }
            g2.drawString(myt, 10, titleYPos - 10);
            g2.drawString(myt, this.rowWidth + 50, titleYPos - 10);
            g2.drawString(mygmt, 10, titleYPos - 20);
            g2.drawString(mygmt, this.rowWidth + 50, titleYPos - 20);
            if (this.titleHeight != titleYPos + this.rowOffset) {
                this.titleHeight = titleYPos + this.rowOffset;
                this.configChanged();
            }
            return;
        }
    }

    void drawTimeTicks(Graphics g, Date date) {
        Graphics2D g2 = (Graphics2D)g;
        int hour = this.calendar.get(11);
        String minutes = ":" + PlottableDisplay.formatMinutes(date.getMinutes()) + " ";
        int hourinterval = this.totalHours / this.rows;
        String hourmin = hour + minutes;
        int xShift = this.totalWidth / this.rows + 50;
        for (int currRow = 0; currRow < this.rows; ++currRow) {
            int houroffset = PlottableDisplay.calcHourOffset(hour);
            if (currRow % 2 == 0) {
                g2.setPaint(this.evenColor);
            } else {
                g2.setPaint(this.oddColor);
            }
            g2.drawString(hourmin, houroffset, this.titleHeight + this.rowOffset * currRow);
            hour = (hour + hourinterval) % 24;
            hourmin = hour + minutes;
            houroffset = PlottableDisplay.calcHourOffset(hour);
            g2.drawString(hour + minutes, xShift + houroffset, this.titleHeight + this.rowOffset * currRow);
        }
    }

    private static int calcHourOffset(int hour) {
        if (hour >= 10) {
            return 5;
        }
        return 10;
    }

    private static String formatMinutes(int minutes) {
        if (minutes < 10) {
            return "0" + minutes;
        }
        return "" + minutes;
    }

    void drawPlottableNew(Graphics g) {
        int mean = this.getMean();
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setClip(50, 0, this.rowWidth, Integer.MAX_VALUE);
        AffineTransform originalTransform = AffineTransform.getTranslateInstance(50.0, this.titleHeight);
        for (int row = 0; row < this.rows && this.currentImageGraphics == g; ++row) {
            g2.setTransform(originalTransform);
            g2.setPaint(this.axisColor);
            int yLoc = this.rowOffset * row;
            g2.drawLine(0, yLoc, this.rowWidth, yLoc);
            g2.setTransform(new AffineTransform());
            g2.translate(-1 * this.rowWidth * row + 50, yLoc + this.titleHeight);
            g2.scale(1.0, -1.0);
            g2.scale(1.0, this.ampScale);
            g2.scale(1.0, this.ampScalePercent);
            g2.translate(0, -1 * mean);
            if (row % 2 == 0) {
                g2.setPaint(this.evenColor);
            } else {
                g2.setPaint(this.oddColor);
            }
            if (this.plottableShape == null) continue;
            g2.draw(this.plottableShape);
        }
        this.repaint();
    }

    private Shape makeShape(Plottable[] plot) {
        int SHAPESIZE = 100;
        GeneralPath wholeShape = new GeneralPath(0);
        for (int a = 0; a < plot.length; ++a) {
            GeneralPath currentShape;
            if (plot[a].x_coor.length >= 2) {
                currentShape = new GeneralPath(0, 101);
                currentShape.moveTo(plot[a].x_coor[0], plot[a].y_coor[0]);
                for (int i = 1; i < plot[a].x_coor.length; ++i) {
                    if (i % 100 == 0) {
                        if (plot[a].x_coor[i - 1] == plot[a].x_coor[i] - 1) {
                            currentShape.moveTo(plot[a].x_coor[i], plot[a].y_coor[i]);
                        } else {
                            currentShape.lineTo(plot[a].x_coor[i], plot[a].y_coor[i]);
                        }
                        wholeShape.append(currentShape, false);
                        currentShape = new GeneralPath(0, 101);
                    }
                    if (plot[a].x_coor[i - 1] == plot[a].x_coor[i] - 1) {
                        currentShape.moveTo(plot[a].x_coor[i], plot[a].y_coor[i]);
                        continue;
                    }
                    currentShape.lineTo(plot[a].x_coor[i], plot[a].y_coor[i]);
                }
                wholeShape.append(currentShape, false);
                continue;
            }
            if (plot[a].x_coor.length != 1) continue;
            currentShape = new GeneralPath(0, 2);
            currentShape.moveTo(plot[a].x_coor[0], plot[a].y_coor[0]);
            currentShape.lineTo(plot[a].x_coor[0], plot[a].y_coor[0]);
            wholeShape.append(currentShape, false);
        }
        return wholeShape;
    }

    public int getMean() {
        if (this.arrayplottable == null || this.arrayplottable.length == 0 || this.arrayplottable[0].y_coor.length == 0) {
            return 0;
        }
        long mean = this.arrayplottable[0].y_coor[0];
        int numPoints = 0;
        for (int i = 0; i < this.arrayplottable.length; ++i) {
            for (int j = 0; j < this.arrayplottable[i].y_coor.length; ++j) {
                mean += (long)this.arrayplottable[i].y_coor[j];
            }
            numPoints += this.arrayplottable[i].y_coor.length;
        }
        return (int)(mean /= (long)numPoints);
    }

    public Image createImage() {
        final int width = this.getSize().width;
        final int height = this.getSize().height;
        final BufferedImage offImg = new BufferedImage(width, height, 1);
        Thread t = new Thread("Plottable Image Creator"){

            public void run() {
                try {
                    Graphics2D g = (Graphics2D)offImg.getGraphics();
                    PlottableDisplay.this.currentImageGraphics = g;
                    g.setBackground(PlottableDisplay.this.backgroundColor);
                    g.clearRect(0, 0, width, height);
                    PlottableDisplay.this.drawComponent(g);
                    g.dispose();
                    PlottableDisplay.this.repaint();
                }
                catch (Throwable t) {
                    GlobalExceptionHandler.handle("Problem drawing the plottable image.", t);
                }
            }
        };
        t.start();
        return offImg;
    }

    public void renderToGraphics(Graphics2D g, Dimension size) {
        if (this.getRootPane() == null) {
            this.addNotify();
        }
        Graphics curGraphics = this.currentImageGraphics;
        this.currentImageGraphics = g;
        Dimension curSize = this.getSize();
        this.setSize(size);
        this.validate();
        this.setDoubleBuffered(false);
        g.setBackground(this.backgroundColor);
        g.clearRect(0, 0, size.width, size.height);
        this.drawComponent(g);
        this.drawEventFlags(g);
        this.drawSelection(g);
        this.repaint();
        this.setDoubleBuffered(true);
        this.currentImageGraphics = curGraphics;
        this.setSize(curSize);
        this.validate();
    }

    public void outputToPNG(String filename) throws IOException {
        this.outputToPNG(new File(filename));
    }

    public void outputToPNG(File file) throws IOException {
        file.getCanonicalFile().getParentFile().mkdirs();
        File temp = File.createTempFile(file.getName(), null, file.getParentFile());
        this.outputToPNG(new FileOutputStream(temp));
        file.delete();
        temp.renameTo(file);
    }

    public void outputToPNG(OutputStream out) throws IOException {
        this.configChanged();
        if (this.getRootPane() == null) {
            this.addNotify();
            this.repaint();
        }
        BufferedImage img = new BufferedImage(this.getPreferredSize().width, this.getPreferredSize().height, 2);
        Graphics2D g2d = img.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.renderToGraphics(g2d, this.getSize());
        ImageIO.write((RenderedImage)img, "png", out);
    }

    public int[] findMinMax(Plottable[] arrayplottable) {
        if (arrayplottable.length == 0) {
            int[] minandmax = new int[]{-1, 1};
            return minandmax;
        }
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int arrayi = 0; arrayi < arrayplottable.length; ++arrayi) {
            for (int ploti = 0; ploti < arrayplottable[arrayi].y_coor.length; ++ploti) {
                min = Math.min(min, arrayplottable[arrayi].y_coor[ploti]);
                max = Math.max(max, arrayplottable[arrayi].y_coor[ploti]);
            }
        }
        int[] minandmax = new int[]{min, max};
        return minandmax;
    }

    public void addToSelection(int x, int y) {
        this.selection.addXY(x, y);
        this.repaint();
    }

    public void setSelection(int x, int y) {
        this.setSelection(x, y, 10);
    }

    public void setSelection(int x, int y, int width) {
        this.selection.setXY(x, y, width);
        this.repaint();
    }

    public boolean bordersSelection(int x, int y) {
        return this.selection.borders(x, y);
    }

    private void drawSelection(Graphics g) {
        this.selection.draw(g);
        this.tempSelection.draw(g);
    }

    public void removeSelection() {
        this.selection = new PlottableSelection(this);
        this.repaint();
    }

    private void drawEventFlags(Graphics g) {
        Iterator iterator = this.eventPlotterList.iterator();
        while (iterator.hasNext()) {
            EventFlag plotter = (EventFlag)iterator.next();
            plotter.draw(g);
        }
    }

    public PlottableSelection getTempSelection() {
        return this.tempSelection;
    }

    public void placeTempSelection() {
        this.selection = this.tempSelection;
        this.tempSelection = new PlottableSelection(this);
        this.selection.setPlaced(true);
        this.repaint();
    }

    public LinkedList getEvents() {
        return this.eventPlotterList;
    }

    public RequestFilter getRequestFilter(int x, int y) {
        if (this.selection.intersectsExtract(x, y)) {
            return this.selection.getRequestFilter();
        }
        return null;
    }

    public List getEventPlotters() {
        return this.eventPlotterList;
    }

    public EventAccessOperations[] getSelectedEvents() {
        int[][] selectedArea = this.selection.getSelectedArea();
        Iterator it = this.eventPlotterList.iterator();
        ArrayList<EventAccessOperations> selectedEvents = new ArrayList<EventAccessOperations>();
        while (it.hasNext()) {
            EventFlag cur = (EventFlag)it.next();
            if (!cur.isSelected(selectedArea)) continue;
            selectedEvents.add(cur.getEvent());
        }
        EventAccessOperations[] eventArray = new EventAccessOperations[selectedEvents.size()];
        return selectedEvents.toArray(eventArray);
    }

    private void addEventPlotterInfo(EventAccessOperations[] eventAccessArray, Arrival[][] arrivals) {
        for (int i = 0; i < eventAccessArray.length; ++i) {
            if (this.useFlags) {
                this.eventPlotterList.add(new EventFlag(this, eventAccessArray[i], arrivals[i]));
                continue;
            }
            this.eventPlotterList.add(new EventBoxes(this, eventAccessArray[i], arrivals[i]));
        }
    }

    public Date getDate() {
        return this.date;
    }

    public ChannelId getChannelId() {
        return this.channelId;
    }

    public int getRows() {
        return this.rows;
    }

    public int getRowWidth() {
        return this.rowWidth;
    }

    public int getRowOffset() {
        return this.rowOffset;
    }

    public int getPlotWidth() {
        return this.totalWidth;
    }

    public int getTotalHours() {
        return this.totalHours;
    }
}

