/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.event;

import edu.iris.Fissures.FlinnEngdahlRegion;
import edu.iris.Fissures.FlinnEngdahlType;
import edu.iris.Fissures.model.FlinnEngdahlRegionImpl;
import edu.sc.seis.fissuresUtil.database.DBUtil;
import edu.sc.seis.fissuresUtil.database.JDBCSequence;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.database.event.EventTable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class JDBCFlinnEngdahl
extends EventTable {
    private JDBCSequence seq;
    protected PreparedStatement getStmt;
    protected PreparedStatement getDBIdStmt;
    protected PreparedStatement putStmt;

    public JDBCFlinnEngdahl(Connection conn) throws SQLException {
        super("flinnengdahl", conn);
        Statement stmt = conn.createStatement();
        this.seq = new JDBCSequence(conn, "FlinnEngdahlSeq");
        if (!DBUtil.tableExists("flinnengdahl", conn)) {
            stmt.executeUpdate(" CREATE TABLE flinnengdahl(flinnengdahlid int primary key, flinnengdahltype int, flinnengdahlnumber int)");
        }
        this.putStmt = conn.prepareStatement("INSERT INTO flinnengdahl ( flinnengdahlid, flinnengdahltype, flinnengdahlnumber)VALUES(?,?,?)");
        this.getDBIdStmt = conn.prepareStatement("SELECT flinnengdahlid FROM flinnengdahl WHERE flinnengdahltype = ?  AND flinnengdahlnumber = ?");
        this.getStmt = conn.prepareStatement(" SELECT flinnengdahltype , flinnengdahlnumber FROM flinnengdahl WHERE  flinnengdahlid = ? ");
    }

    public int put(FlinnEngdahlRegion region) throws SQLException {
        try {
            return this.getDBId(region);
        }
        catch (NotFound ex) {
            int id = this.seq.next();
            this.putStmt.setInt(1, id);
            this.insert(region, this.putStmt, 2);
            this.putStmt.executeUpdate();
            return id;
        }
    }

    public int getDBId(FlinnEngdahlRegion region) throws SQLException, NotFound {
        this.insert(region, this.getDBIdStmt, 1);
        ResultSet rs = this.getDBIdStmt.executeQuery();
        if (rs.next()) {
            return rs.getInt("flinnengdahlid");
        }
        throw new NotFound("region is not found");
    }

    public FlinnEngdahlRegion get(int id) throws SQLException, NotFound {
        this.getStmt.setInt(1, id);
        ResultSet rs = this.getStmt.executeQuery();
        if (rs.next()) {
            return this.extract(rs);
        }
        throw new NotFound("No Region Found for this given id");
    }

    public int insert(FlinnEngdahlRegion region, PreparedStatement stmt, int index) throws SQLException {
        stmt.setInt(index++, region.type.value());
        stmt.setInt(index++, region.number);
        return index;
    }

    public FlinnEngdahlRegionImpl extract(ResultSet rs) throws SQLException {
        return new FlinnEngdahlRegionImpl(FlinnEngdahlType.from_int((int)rs.getInt("flinnengdahltype")), rs.getInt("flinnengdahlnumber"));
    }
}

