/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.event;

import edu.sc.seis.fissuresUtil.database.ConnMgr;
import edu.sc.seis.fissuresUtil.database.DBUtil;
import edu.sc.seis.fissuresUtil.database.JDBCSequence;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.database.event.EventTable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class JDBCContributor
extends EventTable {
    protected PreparedStatement getDBIdStmt;
    protected PreparedStatement getStmt;
    protected PreparedStatement putStmt;
    protected PreparedStatement getAllStmt;
    private JDBCSequence seq;

    public JDBCContributor(Connection conn) throws SQLException {
        super("contributor", conn);
        this.seq = new JDBCSequence(conn, "ContributorSeq");
        Statement stmt = conn.createStatement();
        if (!DBUtil.tableExists("contributor", conn)) {
            stmt.executeUpdate(ConnMgr.getSQL("contributor.create"));
        }
        this.putStmt = conn.prepareStatement(" INSERT INTO contributor  (contributor_id,  contributor_name) VALUES( ?, ?) ");
        this.getStmt = conn.prepareStatement(" SELECT contributor_name FROM contributor  WHERE contributor_id = ? ");
        this.getDBIdStmt = conn.prepareStatement(" SELECT contributor_id   FROM contributor  WHERE contributor_name = ?");
        this.getAllStmt = conn.prepareStatement(" SELECT DISTINCT contributor_id  FROM contributor");
    }

    public int put(String contributor) throws SQLException {
        try {
            return this.getDBId(contributor);
        }
        catch (NotFound nfe) {
            int id = this.seq.next();
            this.putStmt.setInt(1, id);
            this.putStmt.setString(2, contributor);
            this.putStmt.executeUpdate();
            return id;
        }
    }

    public int getDBId(String contributor) throws SQLException, NotFound {
        this.getDBIdStmt.setString(1, contributor);
        ResultSet rs = this.getDBIdStmt.executeQuery();
        if (rs.next()) {
            return rs.getInt("contributor_id");
        }
        throw new NotFound("the entry for the given origin object is not found");
    }

    public String get(int id) throws SQLException, NotFound {
        this.getStmt.setInt(1, id);
        ResultSet rs = this.getStmt.executeQuery();
        if (rs.next()) {
            return this.extract(rs);
        }
        throw new NotFound(" there is no Contributor name is associated  to the id " + id);
    }

    public String[] getAll() throws SQLException {
        ArrayList<String> aList = new ArrayList<String>();
        ResultSet rs = this.getAllStmt.executeQuery();
        while (rs.next()) {
            aList.add(rs.getString("contributor_name"));
        }
        String[] contributors = new String[aList.size()];
        contributors = aList.toArray(contributors);
        return contributors;
    }

    public String extract(ResultSet rs) throws SQLException {
        return rs.getString("contributor_name");
    }
}

