/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.Dimension;
import edu.iris.Fissures.IfEvent.EventAccess;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfPlottable.PlottableDC;
import edu.iris.Fissures.IfPlottable.PlottableDCOperations;
import edu.iris.Fissures.IfPlottable.PlottableNotAvailable;
import edu.iris.Fissures.IfPlottable.UnsupportedDimension;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.NotImplemented;
import edu.iris.Fissures.Plottable;
import edu.sc.seis.fissuresUtil.cache.BulletproofVestFactory;
import edu.sc.seis.fissuresUtil.cache.ProxyPlottableDC;
import edu.sc.seis.fissuresUtil.cache.ProxySeismogramDC;
import org.apache.log4j.Logger;
import org.omg.CORBA.SystemException;

public class RetryPlottableDC
implements ProxyPlottableDC {
    PlottableDCOperations plottable;
    int retry;
    private static final Logger logger = Logger.getLogger((Class)RetryPlottableDC.class);

    public RetryPlottableDC(PlottableDCOperations plottable, int retry) {
        this.plottable = plottable;
        this.retry = retry;
    }

    public boolean custom_sizes() {
        SystemException lastException = null;
        for (int count = 0; count < this.retry; ++count) {
            try {
                return this.plottable.custom_sizes();
            }
            catch (SystemException t) {
                lastException = t;
                logger.warn((Object)("Caught exception, retrying " + count), (Throwable)t);
                BulletproofVestFactory.retrySleep(count);
                this.reset();
                continue;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw lastException;
    }

    public Plottable[] get_plottable(RequestFilter request, Dimension pixel_size) throws PlottableNotAvailable, UnsupportedDimension, NotImplemented {
        SystemException lastException = null;
        for (int count = 0; count < this.retry; ++count) {
            try {
                return this.plottable.get_plottable(request, pixel_size);
            }
            catch (SystemException t) {
                lastException = t;
                logger.warn((Object)("Caught exception, retrying " + count), (Throwable)t);
                BulletproofVestFactory.retrySleep(count);
                this.reset();
                continue;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw lastException;
    }

    public Dimension[] get_whole_day_sizes() {
        SystemException lastException = null;
        for (int count = 0; count < this.retry; ++count) {
            try {
                return this.plottable.get_whole_day_sizes();
            }
            catch (SystemException t) {
                lastException = t;
                logger.warn((Object)("Caught exception, retrying " + count), (Throwable)t);
                BulletproofVestFactory.retrySleep(count);
                this.reset();
                continue;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw lastException;
    }

    public Plottable[] get_for_day(ChannelId channel_id, int year, int jday, Dimension pixel_size) throws PlottableNotAvailable, UnsupportedDimension {
        SystemException lastException = null;
        for (int count = 0; count < this.retry; ++count) {
            try {
                return this.plottable.get_for_day(channel_id, year, jday, pixel_size);
            }
            catch (SystemException t) {
                lastException = t;
                logger.warn((Object)("Caught exception, retrying " + count), (Throwable)t);
                BulletproofVestFactory.retrySleep(count);
                this.reset();
                continue;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw lastException;
    }

    public Dimension[] get_event_sizes() {
        SystemException lastException = null;
        for (int count = 0; count < this.retry; ++count) {
            try {
                return this.plottable.get_event_sizes();
            }
            catch (SystemException t) {
                lastException = t;
                logger.warn((Object)("Caught exception, retrying " + count), (Throwable)t);
                BulletproofVestFactory.retrySleep(count);
                this.reset();
                continue;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw lastException;
    }

    public Plottable[] get_for_event(EventAccess event, ChannelId channel_id, Dimension pixel_size) throws PlottableNotAvailable, UnsupportedDimension {
        SystemException lastException = null;
        for (int count = 0; count < this.retry; ++count) {
            try {
                return this.plottable.get_for_event(event, channel_id, pixel_size);
            }
            catch (SystemException t) {
                lastException = t;
                logger.warn((Object)("Caught exception, retrying " + count), (Throwable)t);
                BulletproofVestFactory.retrySleep(count);
                this.reset();
                continue;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw lastException;
    }

    public PlottableDCOperations getWrappedDC() {
        return this.plottable;
    }

    public PlottableDCOperations getWrappedDC(Class wrappedClass) {
        if (this.getWrappedDC().getClass().equals(wrappedClass)) {
            return this.getWrappedDC();
        }
        if (this.getWrappedDC().getClass().equals(ProxySeismogramDC.class)) {
            ((ProxySeismogramDC)this.getWrappedDC()).getWrappedDC(wrappedClass);
        }
        throw new IllegalArgumentException("This doesn't contain a DC of class " + wrappedClass);
    }

    public void reset() {
        if (this.plottable instanceof ProxyPlottableDC) {
            ((ProxyPlottableDC)this.plottable).reset();
        }
    }

    public PlottableDC getCorbaObject() {
        if (this.plottable instanceof PlottableDC) {
            return (PlottableDC)this.plottable;
        }
        if (this.plottable instanceof ProxyPlottableDC) {
            return ((ProxyPlottableDC)this.plottable).getCorbaObject();
        }
        throw new RuntimeException("subplottable not a PlottableDC or ProxyPlottableDC");
    }
}

