/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.LongShortTrigger;
import java.util.LinkedList;

public class LongShortStoN {
    protected TimeInterval longTime;
    protected TimeInterval shortTime;
    protected TimeInterval delay;
    protected float threshold;
    protected TimeInterval meanTime;

    public LongShortStoN(TimeInterval longTime, TimeInterval shortTime, float threshold) {
        this(longTime, shortTime, threshold, (TimeInterval)shortTime.multiplyBy(2.0));
    }

    public LongShortStoN(TimeInterval longTime, TimeInterval shortTime, float threshold, TimeInterval delay) {
        this(longTime, shortTime, threshold, delay, new TimeInterval(100.0, UnitImpl.SECOND));
    }

    public LongShortStoN(TimeInterval longTime, TimeInterval shortTime, float threshold, TimeInterval delay, TimeInterval meanTime) {
        if (longTime.lessThanEqual((QuantityImpl)shortTime)) {
            throw new IllegalArgumentException("longTime must be longer than shortTime, longTime=" + longTime + "  shortTime=" + shortTime);
        }
        if (delay.lessThan((QuantityImpl)shortTime)) {
            throw new IllegalArgumentException("delay must be longer than shortTime, shortTime=" + shortTime + "  delay=" + delay);
        }
        this.longTime = longTime;
        this.shortTime = shortTime;
        this.threshold = threshold;
        this.delay = delay;
        this.meanTime = meanTime;
    }

    public LongShortTrigger[] calcTriggers(LocalSeismogramImpl seis) throws FissuresException {
        float ratio;
        float dat;
        float mean;
        LinkedList<LongShortTrigger> out = new LinkedList<LongShortTrigger>();
        float[] seisData = seis.get_as_floats();
        double dt = seis.getSampling().getPeriod().convertTo(UnitImpl.SECOND).get_value();
        int nlta = (int)this.longTime.divideBy(dt).convertTo(UnitImpl.SECOND).getValue() + 1;
        int nsta = (int)this.shortTime.divideBy(dt).convertTo(UnitImpl.SECOND).getValue() + 1;
        int ntdly = (int)this.delay.divideBy(dt).convertTo(UnitImpl.SECOND).getValue() + 1;
        int nmean = (int)this.meanTime.divideBy(dt).convertTo(UnitImpl.SECOND).getValue() + 1;
        if (seis.getEndTime().subtract(seis.getBeginTime()).lessThan((QuantityImpl)this.delay) || nsta > ntdly || ntdly > seis.getNumPoints()) {
            return new LongShortTrigger[0];
        }
        float csta = 1.0f / (float)nsta;
        float clta = 1.0f / (float)nlta;
        float cmean = 1.0f / (float)nmean;
        float mean1 = mean = 0.0f;
        float sta = 0.0f;
        float lta = 0.0f;
        float trg = 0.0f;
        boolean hold = false;
        for (int i = 0; i < 2 * nsta; ++i) {
            mean += (seisData[i] - mean) * cmean;
            dat = seisData[i] - mean;
            mean1 += (dat - mean1) * cmean;
            sta += (Math.abs(dat -= mean1) - sta) * csta;
            lta += (Math.abs(dat) - lta) * csta;
            ratio = sta / lta;
        }
        long seisStart = 0L;
        double sampling = 0.0;
        boolean samplingAndStartSet = false;
        for (int i = 2 * nsta; i < seisData.length; ++i) {
            mean += (seisData[i] - mean) * cmean;
            dat = seisData[i] - mean;
            mean1 += (dat - mean1) * cmean;
            dat = Math.abs(dat - mean1);
            sta += (dat - sta) * csta;
            if (trg != 1.0f || !hold) {
                lta += (dat - lta) * clta;
            }
            ratio = sta / lta;
            if (!(ratio >= this.threshold)) continue;
            if (!samplingAndStartSet) {
                seisStart = seis.getBeginTime().getMicroSecondTime();
                sampling = seis.getSampling().getPeriod().convertTo(UnitImpl.MICROSECOND).get_value();
                samplingAndStartSet = true;
            }
            LongShortTrigger trigger = new LongShortTrigger(seis, i, ratio, sta, lta);
            out.add(trigger);
        }
        LongShortTrigger[] trigger = out.toArray(new LongShortTrigger[0]);
        return trigger;
    }

    public LongShortTrigger[] calcTriggersTJO(LocalSeismogramImpl seis) throws FissuresException {
        int j;
        LinkedList<LongShortTrigger> out = new LinkedList<LongShortTrigger>();
        float[] seisData = seis.get_as_floats();
        float dt = (float)seis.getSampling().getPeriod().convertTo(UnitImpl.SECOND).get_value();
        int nlta = (int)this.longTime.divideBy((double)dt).convertTo(UnitImpl.SECOND).getValue() + 1;
        int nsta = (int)this.shortTime.divideBy((double)dt).convertTo(UnitImpl.SECOND).getValue() + 1;
        int ntdly = (int)this.delay.divideBy((double)dt).convertTo(UnitImpl.SECOND).getValue() + 1;
        if (seis.getEndTime().subtract(seis.getBeginTime()).lessThan((QuantityImpl)this.delay) || nsta > ntdly || ntdly > seis.getNumPoints()) {
            return new LongShortTrigger[0];
        }
        int n100 = (int)(100.0 / (double)dt) + 1;
        float clta = 1.0f / (float)nlta;
        float csta = 1.0f / (float)nsta;
        float xmean = 0.0f;
        float ylta = 0.0f;
        float prevylta = 0.0f;
        float ysta = 0.0f;
        float prevysta = 0.0f;
        for (j = 0; j < nsta && j < ntdly; ++j) {
            ysta += seisData[ntdly - j - 1];
        }
        for (j = 0; j < nlta && j < ntdly; ++j) {
            ylta += seisData[ntdly - j - 1];
        }
        int nmean = 0;
        for (nmean = 0; nmean < n100 && nmean < ntdly; ++nmean) {
            xmean += seisData[ntdly - nmean - 1];
        }
        for (int i = ntdly; i < seisData.length; ++i) {
            if (nmean == n100) {
                xmean -= seisData[i - n100];
            } else {
                ++nmean;
            }
            prevylta = ylta;
            float nextData = Math.abs(seisData[i] - (xmean += seisData[i]) / (float)nmean);
            ylta = clta * nextData + (1.0f - clta) * prevylta - (i < nlta ? 0.0f : clta * Math.abs(seisData[i - nlta] - xmean / (float)nmean));
            prevysta = ysta;
            ysta = csta * nextData + (1.0f - csta) * prevysta - (i < nsta ? 0.0f : csta * Math.abs(seisData[i - nsta] - xmean / (float)nmean));
            float ratio = ylta != 0.0f ? ysta / ylta : (ysta != 0.0f ? this.threshold : 0.0f);
            if (!(ratio >= this.threshold)) continue;
            LongShortTrigger trigger = new LongShortTrigger(seis, i, ratio, ysta, ylta);
            out.add(trigger);
        }
        LongShortTrigger[] trigger = out.toArray(new LongShortTrigger[0]);
        return trigger;
    }
}

