/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.XMLParseException;

public class XMLEntityResolver
implements IXMLEntityResolver {
    private Hashtable<String, Object> entities = new Hashtable();

    public XMLEntityResolver() {
        this.entities.put("amp", "&#38;");
        this.entities.put("quot", "&#34;");
        this.entities.put("apos", "&#39;");
        this.entities.put("lt", "&#60;");
        this.entities.put("gt", "&#62;");
    }

    protected void finalize() throws Throwable {
        this.entities.clear();
        this.entities = null;
        super.finalize();
    }

    public void addInternalEntity(String name, String value) {
        if (!this.entities.containsKey(name)) {
            this.entities.put(name, value);
        }
    }

    public void addExternalEntity(String name, String publicID, String systemID) {
        if (!this.entities.containsKey(name)) {
            this.entities.put(name, new String[]{publicID, systemID});
        }
    }

    public Reader getEntity(IXMLReader xmlReader, String name) throws XMLParseException {
        Object obj = this.entities.get(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return new StringReader((String)obj);
        }
        String[] id = (String[])obj;
        return this.openExternalEntity(xmlReader, id[0], id[1]);
    }

    public boolean isExternalEntity(String name) {
        Object obj = this.entities.get(name);
        return !(obj instanceof String);
    }

    protected Reader openExternalEntity(IXMLReader xmlReader, String publicID, String systemID) throws XMLParseException {
        String parentSystemID = xmlReader.getSystemID();
        try {
            return xmlReader.openStream(publicID, systemID);
        }
        catch (Exception e) {
            throw new XMLParseException(parentSystemID, xmlReader.getLineNr(), "Could not open external entity at system ID: " + systemID);
        }
    }
}

