/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import net.n3.nanoxml.IXMLReader;

public class StdXMLReader
implements IXMLReader {
    private Stack<StackedReader> readers;
    private StackedReader currentReader;

    public static IXMLReader stringReader(String str) {
        return new StdXMLReader(new StringReader(str));
    }

    public static IXMLReader fileReader(String filename) throws FileNotFoundException, IOException {
        StdXMLReader r = new StdXMLReader(new FileInputStream(filename));
        r.setSystemID(filename);
        for (int i = 0; i < r.readers.size(); ++i) {
            StackedReader sr = (StackedReader)r.readers.elementAt(i);
            sr.systemId = r.currentReader.systemId;
        }
        return r;
    }

    public StdXMLReader(String publicID, String systemID) throws MalformedURLException, FileNotFoundException, IOException {
        URL systemIDasURL = null;
        try {
            systemIDasURL = new URL(systemID);
        }
        catch (MalformedURLException e) {
            systemID = "file:" + systemID;
            try {
                systemIDasURL = new URL(systemID);
            }
            catch (MalformedURLException e2) {
                throw e;
            }
        }
        this.currentReader = new StackedReader();
        this.readers = new Stack();
        Reader reader = this.openStream(publicID, systemIDasURL.toString());
        this.currentReader.lineReader = new LineNumberReader(reader);
        this.currentReader.pbReader = new PushbackReader(this.currentReader.lineReader, 2);
    }

    public StdXMLReader(Reader reader) {
        this.currentReader = new StackedReader();
        this.readers = new Stack();
        this.currentReader.lineReader = new LineNumberReader(reader);
        this.currentReader.pbReader = new PushbackReader(this.currentReader.lineReader, 2);
        this.currentReader.publicId = "";
        try {
            this.currentReader.systemId = new URL("file:.");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.currentReader.lineReader = null;
        this.currentReader.pbReader = null;
        this.currentReader.systemId = null;
        this.currentReader.publicId = null;
        this.currentReader = null;
        this.readers.clear();
        super.finalize();
    }

    protected String getEncoding(String str) {
        if (!str.startsWith("<?xml")) {
            return null;
        }
        int index = 5;
        while (index < str.length()) {
            char delimiter;
            int index2;
            StringBuffer key = new StringBuffer();
            while (index < str.length() && str.charAt(index) <= ' ') {
                ++index;
            }
            while (index < str.length() && str.charAt(index) >= 'a' && str.charAt(index) <= 'z') {
                key.append(str.charAt(index));
                ++index;
            }
            while (index < str.length() && str.charAt(index) <= ' ') {
                ++index;
            }
            if (index >= str.length() || str.charAt(index) != '=') break;
            while (index < str.length() && str.charAt(index) != '\'' && str.charAt(index) != '\"') {
                ++index;
            }
            if (index >= str.length() || (index2 = str.indexOf(delimiter = str.charAt(index), ++index)) < 0) break;
            if (key.toString().equals("encoding")) {
                return str.substring(index, index2);
            }
            index = index2 + 1;
        }
        return null;
    }

    protected Reader stream2reader(InputStream stream, StringBuffer charsRead) throws IOException {
        PushbackInputStream pbstream = new PushbackInputStream(stream);
        int b = pbstream.read();
        switch (b) {
            case 0: 
            case 254: 
            case 255: {
                pbstream.unread(b);
                return new InputStreamReader((InputStream)pbstream, "UTF-16");
            }
            case 239: {
                for (int i = 0; i < 2; ++i) {
                    pbstream.read();
                }
                return new InputStreamReader((InputStream)pbstream, "UTF-8");
            }
            case 60: {
                String encoding;
                b = pbstream.read();
                charsRead.append('<');
                while (b > 0 && b != 62) {
                    charsRead.append((char)b);
                    b = pbstream.read();
                }
                if (b > 0) {
                    charsRead.append((char)b);
                }
                if ((encoding = this.getEncoding(charsRead.toString())) == null) {
                    return new InputStreamReader((InputStream)pbstream, "UTF-8");
                }
                charsRead.setLength(0);
                try {
                    return new InputStreamReader((InputStream)pbstream, encoding);
                }
                catch (UnsupportedEncodingException e) {
                    return new InputStreamReader((InputStream)pbstream, "UTF-8");
                }
            }
        }
        charsRead.append((char)b);
        return new InputStreamReader((InputStream)pbstream, "UTF-8");
    }

    public StdXMLReader(InputStream stream) throws IOException {
        StringBuffer charsRead = new StringBuffer();
        Reader reader = this.stream2reader(stream, charsRead);
        this.currentReader = new StackedReader();
        this.readers = new Stack();
        this.currentReader.lineReader = new LineNumberReader(reader);
        this.currentReader.pbReader = new PushbackReader(this.currentReader.lineReader, 2);
        this.currentReader.publicId = "";
        try {
            this.currentReader.systemId = new URL("file:.");
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        this.startNewStream(new StringReader(charsRead.toString()));
    }

    public char read() throws IOException {
        int ch = this.currentReader.pbReader.read();
        while (ch < 0) {
            if (this.readers.empty()) {
                throw new IOException("Unexpected EOF");
            }
            this.currentReader.pbReader.close();
            this.currentReader = this.readers.pop();
            ch = this.currentReader.pbReader.read();
        }
        return (char)ch;
    }

    public boolean atEOFOfCurrentStream() throws IOException {
        int ch = this.currentReader.pbReader.read();
        if (ch < 0) {
            return true;
        }
        this.currentReader.pbReader.unread(ch);
        return false;
    }

    public boolean atEOF() throws IOException {
        int ch = this.currentReader.pbReader.read();
        while (ch < 0) {
            if (this.readers.empty()) {
                return true;
            }
            this.currentReader.pbReader.close();
            this.currentReader = this.readers.pop();
            ch = this.currentReader.pbReader.read();
        }
        this.currentReader.pbReader.unread(ch);
        return false;
    }

    public void unread(char ch) throws IOException {
        this.currentReader.pbReader.unread(ch);
    }

    public Reader openStream(String publicID, String systemID) throws MalformedURLException, FileNotFoundException, IOException {
        URL url = new URL(this.currentReader.systemId, systemID);
        if (url.getRef() != null) {
            String ref = url.getRef();
            if (url.getFile().length() > 0) {
                url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile());
                url = new URL("jar:" + url + '!' + ref);
            } else {
                url = StdXMLReader.class.getResource(ref);
            }
        }
        this.currentReader.publicId = publicID;
        this.currentReader.systemId = url;
        StringBuffer charsRead = new StringBuffer();
        Reader reader = this.stream2reader(url.openStream(), charsRead);
        if (charsRead.length() == 0) {
            return reader;
        }
        String charsReadStr = charsRead.toString();
        PushbackReader pbreader = new PushbackReader(reader, charsReadStr.length());
        for (int i = charsReadStr.length() - 1; i >= 0; --i) {
            pbreader.unread(charsReadStr.charAt(i));
        }
        return pbreader;
    }

    public void startNewStream(Reader reader) {
        this.startNewStream(reader, false);
    }

    public void startNewStream(Reader reader, boolean isInternalEntity) {
        StackedReader oldReader = this.currentReader;
        this.readers.push(this.currentReader);
        this.currentReader = new StackedReader();
        if (isInternalEntity) {
            this.currentReader.lineReader = null;
            this.currentReader.pbReader = new PushbackReader(reader, 2);
        } else {
            this.currentReader.lineReader = new LineNumberReader(reader);
            this.currentReader.pbReader = new PushbackReader(this.currentReader.lineReader, 2);
        }
        this.currentReader.systemId = oldReader.systemId;
        this.currentReader.publicId = oldReader.publicId;
    }

    public int getStreamLevel() {
        return this.readers.size();
    }

    public int getLineNr() {
        if (this.currentReader.lineReader == null) {
            StackedReader sr = this.readers.peek();
            if (sr.lineReader == null) {
                return 0;
            }
            return sr.lineReader.getLineNumber() + 1;
        }
        return this.currentReader.lineReader.getLineNumber() + 1;
    }

    public void setSystemID(String systemID) throws MalformedURLException {
        this.currentReader.systemId = new URL(this.currentReader.systemId, systemID);
    }

    public void setPublicID(String publicID) {
        this.currentReader.publicId = publicID;
    }

    public String getSystemID() {
        return this.currentReader.systemId.toString();
    }

    public String getPublicID() {
        return this.currentReader.publicId;
    }

    private class StackedReader {
        PushbackReader pbReader;
        LineNumberReader lineReader;
        URL systemId;
        String publicId;

        private StackedReader() {
        }
    }
}

