/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.tools;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class TermIO
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static JButton closeB = new JButton("Close");
    private static JButton stopB = new JButton("Stop");
    private static TermIO term = new TermIO();
    private PrintStream stdout = System.out;
    private PrintStream stderr = System.err;
    private Document d;
    private boolean autoScroll = true;

    private TermIO() {
        super("Winston Tools Console");
        FormLayout layout = new FormLayout("fill:p:G", "fill:p:G, p");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append((Component)this.createContentPane());
        builder.nextLine();
        builder.append((Component)this.createControlPanel());
        this.getContentPane().add(builder.getPanel());
        this.pack();
        this.setSize(640, 480);
        PrintStream o = new PrintStream(new DocumentOutputStream(this.d));
        System.setOut(o);
        System.setErr(o);
    }

    public static TermIO getTerm() {
        return term;
    }

    public static void showTerm(boolean b) {
        term.setVisible(b);
    }

    private JScrollPane createContentPane() {
        JTextArea t = new JTextArea("\n");
        this.d = t.getDocument();
        this.d.addDocumentListener(new ScrolledDocumentListener(t));
        JScrollPane areaScrollPane = new JScrollPane(t);
        areaScrollPane.setVerticalScrollBarPolicy(22);
        areaScrollPane.setHorizontalScrollBarPolicy(30);
        areaScrollPane.setPreferredSize(new Dimension(320, 240));
        return areaScrollPane;
    }

    private JPanel createControlPanel() {
        JPanel p = new JPanel();
        closeB.setEnabled(true);
        closeB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TermIO.this.dispose();
            }
        });
        p.add(closeB);
        this.addStopListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                stopB.setText("Stopping");
                stopB.setEnabled(false);
            }
        });
        stopB.setEnabled(false);
        p.add(stopB);
        JCheckBox autoScrollB = new JCheckBox("Auto scroll", this.autoScroll);
        autoScrollB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                TermIO.this.autoScroll = e.getStateChange() == 1;
            }
        });
        p.add(autoScrollB);
        return p;
    }

    public void addStopListener(ActionListener a) {
        stopB.addActionListener(a);
    }

    public static void startRunning(boolean b) {
        closeB.setEnabled(false);
        stopB.setEnabled(b);
    }

    public static void stopRunning() {
        closeB.setEnabled(true);
        stopB.setEnabled(false);
        stopB.setText("Stop");
    }

    public class DocumentOutputStream
    extends OutputStream {
        private Document doc;
        private boolean closed;

        public DocumentOutputStream(Document d) {
            this.doc = d;
            this.closed = false;
        }

        public void write(int i) throws IOException {
            if (this.closed) {
                return;
            }
            try {
                this.doc.insertString(this.doc.getLength() - 1, String.valueOf((char)i), null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public void write(byte[] b, int offset, int length) throws IOException {
            if (this.closed) {
                return;
            }
            if (b == null) {
                throw new NullPointerException("The byte array is null");
            }
            if (offset < 0 || length < 0 || offset + length > b.length) {
                throw new IndexOutOfBoundsException("offset and length are negative or extend outside array bounds");
            }
            String str = new String(b, offset, length);
            try {
                this.doc.insertString(this.doc.getLength() - 1, str, null);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }

        public void close() {
            this.doc = null;
            this.closed = true;
        }
    }

    private class ScrolledDocumentListener
    implements DocumentListener {
        JTextArea ta;

        public ScrolledDocumentListener(JTextArea t) {
            this.ta = t;
        }

        public void changedUpdate(DocumentEvent e) {
            if (TermIO.this.autoScroll) {
                this.ta.setCaretPosition(this.ta.getText().length());
            }
        }

        public void insertUpdate(DocumentEvent e) {
            if (TermIO.this.autoScroll) {
                this.ta.setCaretPosition(this.ta.getText().length());
            }
        }

        public void removeUpdate(DocumentEvent e) {
            if (TermIO.this.autoScroll) {
                this.ta.setCaretPosition(this.ta.getText().length());
            }
        }
    }
}

