/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server.cmd;

import gov.usgs.net.CommandHandler;
import gov.usgs.net.HttpRequest;
import gov.usgs.net.HttpResponse;
import gov.usgs.net.NetTools;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.heli.HelicorderData;
import gov.usgs.vdx.data.heli.plot.HelicorderSettings;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.server.WWS;
import gov.usgs.winston.server.cmd.BaseCommand;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;

public class HttpGetCommand
extends BaseCommand {
    private CommandHandler commandHandler;

    public HttpGetCommand(NetTools nt, WinstonDatabase db, WWS wws, CommandHandler ch) {
        super(nt, db, wws);
        this.commandHandler = ch;
    }

    public void writeSimpleHTML(String msg, SocketChannel channel) {
        String html = "<html><body>" + msg + "</body></html>";
        HttpResponse response = new HttpResponse("text/html");
        response.setLength(html.length());
        this.netTools.writeString(response.getHeaderString(), channel);
        this.netTools.writeString(html, channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCommand(Object info, SocketChannel channel) {
        block26: {
            try {
                Date bt;
                SimpleDateFormat dateFormat;
                String cmd = (String)info;
                this.wws.log(Level.FINER, cmd, channel);
                HttpRequest request = new HttpRequest(cmd);
                if (request == null || request.getFile() == null) {
                    this.wws.log(Level.INFO, "malformed HTTP request", channel);
                    break block26;
                }
                if (request.getFile().equals("/")) {
                    StringBuilder output = new StringBuilder(64000);
                    output.append("This is a Winston Wave Server.<br><br>");
                    output.append("You can construct urls that return graphical helicorders as follows:");
                    output.append("<br><br><code>http://pubavo1.wr.usgs.gov:16022/heli?code=AUI_EHZ_AV&w=1280&h=1024&tc=30&t1=-24&t2=now&tz=America/Anchorage<br><br></code>This url will return a helicorder for the channel <code>AUL EHZ AV</code> depicting the last 24 hours of data.The options (separated by the & character, all optional except for <code>code</code> ) are defined as follows:<br><br><code>w</code>: <b>Width</b> in pixels of the returned image (default = 800).<br><br><code>h</code>: <b>Height</b> in pixels of the returned image (default = 800).<br><br><code>tc</code>: <b>Time Chunk</b> length of x axis in minutes (default = 30).<br><br><code>t1</code>: <b>Start Time</b> The start time (local) of the helicorder as given by the number of hours before present or a specific time in the format YYYYMMDDHHMM.  Note that, in the first case, this is a negative number (default = -12).<br><br><code>t2</code>: <b>End Time</b> The end time (local) of the helicorder as given by the format YYYYMMDDHHMM or 'now' (default = 'now').<br><br><code>tz</code>: <b>Time Zone</b> The time zone, a complete list of time zones that WWS understands is shown below.<br><br><code>sc</code>: <b>Show Clip</b> Whether to show a clipped value as red, 1 is yes, 0 is no (default = 0).<br><br><code>fc</code>: <b>Force Center</b> Whether to center traces, 1 is yes, 0 is no (default = 0).<br><br><code>br</code>: <b>Bar Range</b> Controls the size of helicorder lines (default = auto).<br><br><code>cv</code>: <b>Clip Value</b> Sets the number of counts above which to clip (default = auto).<br><br><code>lb</code>: <b>Label</b> Whether to display a large label, 1 is yes, 0 is no (default = 0).<br><br>The WWS does basic argument checking to prevent malignant attacks (like SQL injection) or just silly requests (like a 10000 x 10000 pixel graph).<br><br><hr><b>Time Zones:</b><br><br>");
                    Object[] tzs = TimeZone.getAvailableIDs();
                    Arrays.sort(tzs);
                    for (Object tz : tzs) {
                        output.append((String)tz);
                        output.append("<br>");
                    }
                    this.writeSimpleHTML(output.toString(), channel);
                    break block26;
                }
                if (!request.getFile().equals("/heli")) break block26;
                String error = "";
                double now = CurrentTime.getInstance().nowJ2K();
                HelicorderSettings settings = new HelicorderSettings();
                settings.channel = request.getArguments().get("code");
                if (settings.channel == null) {
                    error = "Error: you must specify a channel (code).";
                } else {
                    settings.channel = settings.channel.replace('_', '$');
                    if (settings.channel.indexOf(";") != -1) {
                        error = "Error: illegal characters in channel (code).";
                    }
                }
                String tz = Util.stringToString(request.getArguments().get("tz"), "UTC");
                settings.timeZone = TimeZone.getTimeZone(tz);
                String t1 = request.getArguments().get("t1");
                String t2 = request.getArguments().get("t2");
                try {
                    if (t2 == null || t2.equalsIgnoreCase("now")) {
                        settings.endTime = now;
                    } else {
                        dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
                        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                        bt = dateFormat.parse(t2);
                        settings.endTime = Util.dateToJ2K(bt) - 1.0;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    error = error + "Error: could not parse end time (t2). Should be yyyyMMddHHmm.";
                }
                if (t1 == null || t1.substring(0, 1).equals("-")) {
                    double hrs = Util.stringToDouble(t1, -12.0);
                    if (hrs < -144.0 || hrs > -1.0) {
                        error = error + "Error: start time (t1) must be between -1 and -144.";
                    }
                    settings.startTime = settings.endTime + hrs * 3600.0;
                } else {
                    try {
                        dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
                        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                        bt = dateFormat.parse(t1);
                        settings.startTime = Util.dateToJ2K(bt);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        error = error + t1.substring(1, 1) + "Error: could not parse start time (t1). Should be yyyyMMddHHmm or -HH.";
                    }
                }
                settings.timeChunk = Util.stringToDouble(request.getArguments().get("tc"), 20.0) * 60.0;
                if (settings.timeChunk <= 0.0 || settings.timeChunk > 21600.0) {
                    error = error + "Error: time chunk (tc) must be greater than 0.";
                }
                int width = Util.stringToInt(request.getArguments().get("w"), 800);
                int height = Util.stringToInt(request.getArguments().get("h"), 800);
                settings.setSizeFromPlotSize(width, height);
                if (settings.height * settings.width <= 0 || settings.height * settings.width > this.wws.httpMaxSize()) {
                    error = error + "Error: product of width (w) and height (h) must be between 1 and " + this.wws.httpMaxSize() + ".";
                }
                settings.showClip = Util.stringToBoolean(request.getArguments().get("sc"));
                settings.forceCenter = Util.stringToBoolean(request.getArguments().get("fc"));
                settings.barRange = Util.stringToInt(request.getArguments().get("br"), -1);
                settings.clipValue = Util.stringToInt(request.getArguments().get("cv"), -1);
                settings.largeChannelDisplay = Util.stringToBoolean(request.getArguments().get("lb"));
                settings.minimumAxis = Util.stringToBoolean(request.getArguments().get("min"));
                if (settings.minimumAxis) {
                    settings.setMinimumSizes();
                }
                if (error.length() > 0) {
                    this.writeSimpleHTML(error, channel);
                } else {
                    HelicorderData heliData = this.data.getHelicorderData(settings.channel, settings.startTime, settings.endTime);
                    if (heliData == null || heliData.rows() <= 0) {
                        this.writeSimpleHTML("Error: could not get helicorder data, check channel (code).", channel);
                    } else {
                        HttpResponse response = new HttpResponse("image/png");
                        response.setVersion(request.getVersion());
                        byte[] png = settings.createPlot(heliData).getPNGBytes();
                        response.setLength(png.length);
                        this.netTools.writeString(response.getHeaderString(), channel);
                        this.netTools.writeByteBuffer(ByteBuffer.wrap(png), channel);
                    }
                }
            }
            finally {
                if (channel.isOpen()) {
                    this.commandHandler.closeConnection();
                }
            }
        }
    }
}

