/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server;

import gov.usgs.earthworm.WaveServer;
import gov.usgs.net.ReadListener;
import gov.usgs.util.Arguments;
import gov.usgs.util.Log;
import gov.usgs.util.Retriable;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.heli.HelicorderData;
import gov.usgs.vdx.data.rsam.RSAMData;
import gov.usgs.vdx.data.wave.SAC;
import gov.usgs.vdx.data.wave.Wave;
import gov.usgs.winston.Channel;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WWSClient
extends WaveServer {
    protected ReadListener readListener;

    public WWSClient(String h, int p) {
        super(h, p);
        this.setTimeout(60000);
        this.logger = Log.getLogger("gov.usgs.winston");
    }

    public void setReadListener(ReadListener rl) {
        this.readListener = rl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProtocolVersion() {
        int version = 1;
        try {
            if (!this.connected()) {
                this.connect();
            }
            this.socket.setSoTimeout(1000);
            this.writeString("VERSION\n");
            String result = this.readString();
            version = Integer.parseInt(result.split(" ")[1]);
        }
        catch (Exception e) {
        }
        finally {
            try {
                this.socket.setSoTimeout(this.timeout);
            }
            catch (Exception e) {}
        }
        return version;
    }

    protected byte[] getData(final String req, final boolean compressed) {
        Retriable<byte[]> rt = new Retriable<byte[]>("WWSClient.getData()", this.maxRetries){

            @Override
            public void attemptFix() {
                WWSClient.this.close();
            }

            @Override
            public boolean attempt() {
                try {
                    if (!WWSClient.this.connected()) {
                        WWSClient.this.connect();
                    }
                    WWSClient.this.writeString(req);
                    String info = WWSClient.this.readString();
                    String[] ss = info.split(" ");
                    int bytes = Integer.parseInt(ss[1]);
                    if (bytes == 0) {
                        return true;
                    }
                    byte[] buf = WWSClient.this.readBinary(bytes, WWSClient.this.readListener);
                    if (compressed) {
                        buf = Util.decompress(buf);
                    }
                    this.result = buf;
                    return true;
                }
                catch (SocketTimeoutException e) {
                    WWSClient.this.logger.warning("WWSClient.getData() timeout.");
                }
                catch (IOException e) {
                    WWSClient.this.logger.warning("WWSClient.getData() IOException: " + e.getMessage());
                }
                return false;
            }
        };
        return (byte[])rt.go();
    }

    public List<Channel> getChannels() {
        return this.getChannels(false);
    }

    public List<Channel> getChannels(final boolean meta) {
        Retriable<String[]> rt = new Retriable<String[]>("WWSClient.getChannels()", this.maxRetries){

            @Override
            public void attemptFix() {
                WWSClient.this.close();
            }

            @Override
            public boolean attempt() {
                try {
                    if (!WWSClient.this.connected()) {
                        WWSClient.this.connect();
                    }
                    String cmd = "";
                    if (meta) {
                        cmd = cmd + " METADATA";
                    }
                    WWSClient.this.writeString(cmd + "\n");
                    String info = WWSClient.this.readString();
                    String[] ss = info.split(" ");
                    int lines = Integer.parseInt(ss[1]);
                    if (lines == 0) {
                        return true;
                    }
                    ss = new String[lines];
                    for (int i = 0; i < ss.length; ++i) {
                        ss[i] = WWSClient.this.readString();
                    }
                    this.result = ss;
                    return true;
                }
                catch (SocketTimeoutException e) {
                    WWSClient.this.logger.warning("WWSClient.getChannels() timeout.");
                }
                catch (IOException e) {
                    WWSClient.this.logger.warning("WWSClient.getChannels() IOException: " + e.getMessage());
                }
                return false;
            }
        };
        String[] result = (String[])rt.go();
        if (result == null) {
            return null;
        }
        ArrayList<Channel> chs = new ArrayList<Channel>(result.length);
        for (String s : result) {
            Channel ch = new Channel(s);
            chs.add(ch);
        }
        return chs;
    }

    public Wave getWave(String station, String comp, String network, String location, double start, double end, boolean compress) {
        String req = String.format(Locale.US, "GETWAVERAW: GS %s %s %s %s %f %f %s\n", station, comp, network, location == null ? "--" : location, start, end, compress ? "1" : "0");
        byte[] buf = this.getData(req, compress);
        if (buf == null) {
            return null;
        }
        return new Wave(ByteBuffer.wrap(buf));
    }

    public HelicorderData getHelicorder(String station, String comp, String network, String location, double start, double end, boolean compress) {
        String req = String.format(Locale.US, "GETSCNLHELIRAW: GS %s %s %s %s %f %f %s\n", station, comp, network, location, start, end, compress ? "1" : "0");
        byte[] buf = this.getData(req, compress);
        if (buf == null) {
            return null;
        }
        return new HelicorderData(ByteBuffer.wrap(buf));
    }

    public String[] getStatus() {
        return this.getStatus(0.0);
    }

    public String[] getStatus(Double d) {
        final double ageThreshold = d;
        Retriable<String[]> rt = new Retriable<String[]>("WWSClient.getStatus()", this.maxRetries){

            @Override
            public void attemptFix() {
                WWSClient.this.close();
            }

            @Override
            public boolean attempt() {
                try {
                    if (!WWSClient.this.connected()) {
                        WWSClient.this.connect();
                    }
                    String cmd = "STATUS: GC " + ageThreshold;
                    WWSClient.this.writeString(cmd + "\n");
                    String info = WWSClient.this.readString();
                    String[] ss = info.split(": ");
                    int lines = Integer.parseInt(ss[1]);
                    if (lines == 0) {
                        return true;
                    }
                    ss = new String[lines];
                    for (int i = 0; i < ss.length; ++i) {
                        ss[i] = WWSClient.this.readString();
                    }
                    this.result = ss;
                    return true;
                }
                catch (SocketTimeoutException e) {
                    WWSClient.this.logger.warning("WWSClient.getStatus() timeout.");
                }
                catch (IOException e) {
                    WWSClient.this.logger.warning("WWSClient.getChannels() IOException: " + e.getMessage());
                }
                return false;
            }
        };
        return (String[])rt.go();
    }

    public RSAMData getRSAMData(String station, String comp, String network, String location, double start, double end, double period, boolean compress) {
        String req = String.format(Locale.US, "GETSCNLRSAMRAW: GS %s %s %s %s %f %f %f %s\n", station, comp, network, location, start, end, period, compress ? "1" : "0");
        byte[] buf = this.getData(req, compress);
        if (buf == null) {
            return null;
        }
        return new RSAMData(ByteBuffer.wrap(buf));
    }

    public static void outputSac(String s, int p, Double st, Double et, String c) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String date = df.format(Util.j2KToDate(st)) + "-" + df.format(Util.j2KToDate(et));
        WWSClient.outputSac(s, p, st, et, c, c.replace('$', '_') + "_" + date + ".sac");
    }

    public static void outputSac(String s, int p, Double st, Double et, String c, String fn) {
        WWSClient winston = new WWSClient(s, p);
        winston.connect();
        String[] chan = c.split("\\$");
        String sta = chan[0];
        String comp = chan[1];
        String net = chan[2];
        String loc = chan.length == 4 ? chan[3] : null;
        Wave wave = winston.getWave(sta, comp, net, loc, st, et, false);
        if (wave != null) {
            wave = wave.subset(st, et);
            SAC sac = wave.toSAC();
            try {
                sac.write(fn);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Wave not found");
        }
    }

    public static void main(String[] as) {
        Logger logger = Log.getLogger("gov.usgs.winston");
        logger.setLevel(Level.INFO);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        Double st = null;
        Double et = null;
        HashSet<String> keys = new HashSet<String>();
        HashSet<String> flags = new HashSet<String>();
        flags.add("--help");
        flags.add("-sac");
        keys.add("-s");
        keys.add("-p");
        keys.add("-st");
        keys.add("-et");
        keys.add("-c");
        Arguments args = new Arguments(as, flags, keys);
        if (args.flagged("--help")) {
            System.err.println("java gov.usgs.winston.server.WWSClient [OPTIONS]");
            System.out.println("-s [server]\t\t\t\tWinston server");
            System.out.println("-p [port]      \t\t\tport");
            System.out.println("-st [yyyymmddHHmmss]\tstart time");
            System.out.println("-et [yymmssHHmmss]      end time");
            System.out.println("-c [s$c$n$l]\t\t\tchannel");
            System.out.println("-sac\t\t\t\t\toutput sac file");
            System.exit(-1);
        }
        String s = args.get("-s");
        int p = Integer.parseInt(args.get("-p"));
        try {
            st = Util.dateToJ2K(df.parse(args.get("-st")));
            et = Util.dateToJ2K(df.parse(args.get("-et")));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String c = args.get("-c");
        if (args.flagged("-sac")) {
            System.out.println(s + ":" + p + ":" + st + ":" + et + ":" + c);
        }
        WWSClient.outputSac(s, p, st, et, c);
    }
}

