/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.monitor;

import gov.usgs.net.HttpRequest;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.util.Util;
import gov.usgs.winston.db.WinstonDatabase;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rrd4j.graph.RrdGraphDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Collector
extends Thread {
    public static final String DEFAULT_LOG_LEVEL = "FINE";
    public static final String DEFAULT_DRIVER = "com.mysql.jdbc.Driver";
    public static final int DEFAULT_PLOT_HEIGHT = 134;
    public static final int DEFAULT_PLOT_WIDTH = 581;
    protected final Logger logger;
    protected String logFile;
    protected int logNumFiles;
    protected int logSize;
    protected boolean quit;
    protected String rrdBase;
    protected int inspectionInterval;
    protected Color avgColor = new Color(2, 71, 105);
    protected Color minColor = new Color(1.0f, 1.0f, 1.0f);
    protected Color maxColor = new Color(149, 203, 233, 136);
    protected WinstonDatabase winston;

    public abstract void configure(String var1, ConfigFile var2, ConfigFile var3);

    public abstract byte[] createPlot(HttpRequest var1) throws IOException;

    public abstract String createPlotPane(HttpRequest var1) throws IOException;

    protected abstract void poll();

    public abstract String getMenu();

    @Override
    public void run() {
        while (!this.quit) {
            this.poll();
            try {
                Thread.sleep(this.inspectionInterval * 60 * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public ArrayList<String> getStations() {
        ArrayList<String> files = new ArrayList<String>();
        File rrdDir = new File(this.rrdBase);
        Pattern p = Pattern.compile(this.getName() + "_(.*)\\.rrd");
        for (String fn : rrdDir.list()) {
            Matcher m = p.matcher(fn);
            if (!m.matches()) continue;
            files.add(m.replaceFirst("$1").replace('$', ' '));
        }
        Collections.sort(files);
        return files;
    }

    public Collector() {
        Thread.currentThread().setName("Collector");
        this.logger = Log.getLogger("gov.usgs.winston.monitor.collector");
        this.logger.setLevel(Level.parse(DEFAULT_LOG_LEVEL));
    }

    protected void fatalError(String msg) {
        this.logger.severe(msg);
        System.exit(1);
    }

    protected void winstonConfig(ConfigFile wc) {
        String winstonDriver = Util.stringToString(wc.getString("driver"), DEFAULT_DRIVER);
        this.logger.info("config: winston.driver=" + winstonDriver);
        String winstonPrefix = wc.getString("prefix");
        if (winstonPrefix == null) {
            this.fatalError("winston.prefix is missing from config file.");
        }
        this.logger.info("config: winston.prefix=" + winstonPrefix);
        String winstonURL = wc.getString("url");
        if (winstonURL == null) {
            this.fatalError("winston.url is missing from config file.");
        }
        this.logger.info("config: winston.url=" + winstonURL);
        this.winston = new WinstonDatabase(winstonDriver, winstonURL, winstonPrefix);
        if (!this.winston.checkDatabase()) {
            this.fatalError("Winston database does not exist.");
        }
    }

    public void quit() {
        this.quit = true;
    }

    protected RrdGraphDef getGDef() {
        RrdGraphDef gDef = new RrdGraphDef();
        gDef.setPoolUsed(false);
        gDef.setShowSignature(false);
        gDef.setImageFormat("png");
        gDef.setFilename("-");
        gDef.setHeight(134);
        gDef.setWidth(581);
        gDef.setEndTime(System.currentTimeMillis() / 1000L);
        return gDef;
    }
}

