/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in.tilt;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.vdx.data.GenericDataMatrix;
import gov.usgs.vdx.data.tilt.SQLTiltDataSource;
import gov.usgs.vdx.data.tilt.ptx.PTXRecord;
import gov.usgs.vdx.db.VDXDatabase;
import java.io.DataInputStream;
import java.io.FileInputStream;

public class ImportPTX {
    public static void main(String[] args) throws Exception {
        SQLTiltDataSource dataSource = new SQLTiltDataSource();
        VDXDatabase database = VDXDatabase.getVDXDatabase("vdx.config");
        String channel = args[1];
        byte[] buffer = new byte[1024];
        boolean done = false;
        for (int j = 2; j < args.length; ++j) {
            System.out.println("file: " + args[j]);
            done = false;
            DataInputStream dis = new DataInputStream(new FileInputStream(args[j]));
            while (!done) {
                try {
                    for (int read = 0; read < 1024; read += dis.read(buffer, read, 1024 - read)) {
                    }
                    PTXRecord ptx = new PTXRecord(buffer);
                    double[][] data = ptx.getImportData();
                    for (int i = 0; i < data.length; ++i) {
                        DoubleMatrix2D dm = DoubleFactory2D.dense.make(1, 5);
                        dm.setQuick(0, 0, data[i][0]);
                        dm.setQuick(0, 1, data[i][1]);
                        dm.setQuick(0, 2, data[i][2]);
                        dm.setQuick(0, 3, data[i][3]);
                        dm.setQuick(0, 4, data[i][4]);
                        String[] columnNames = new String[]{"j2ksec", "xTilt", "yTilt", "instVolt", "holeTemp"};
                        GenericDataMatrix gdm = new GenericDataMatrix(dm);
                        gdm.setColumnNames(columnNames);
                        dataSource.defaultInsertData(channel, gdm, dataSource.getTranslationsFlag(), dataSource.getRanksFlag(), 1);
                    }
                }
                catch (Exception e) {
                    done = true;
                }
            }
            dis.close();
        }
    }
}

