/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in.hypo;

import gov.usgs.util.Arguments;
import gov.usgs.util.ResourceReader;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.hypo.Hypocenter;
import gov.usgs.vdx.data.hypo.SQLHypocenterDataSource;
import gov.usgs.vdx.in.hypo.Importer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportH71
extends Importer {
    private SimpleDateFormat dateIn = new SimpleDateFormat("yyyyMMddHHmmsss.SS");

    public ImportH71(SQLHypocenterDataSource ds) {
        super(ds);
        this.dateIn.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    @Override
    public List<Hypocenter> importResource(String resource) {
        String s;
        ResourceReader rr = ResourceReader.getResourceReader(resource);
        if (rr == null) {
            return null;
        }
        ArrayList<Hypocenter> hypos = new ArrayList<Hypocenter>();
        int lines = 0;
        while ((s = rr.nextLine()) != null) {
            try {
                ++lines;
                String year = s.substring(0, 4);
                String monthDay = s.substring(4, 8);
                if (!s.substring(8, 9).equals(" ")) {
                    throw new Exception("corrupt data at column 9");
                }
                String hourMin = s.substring(9, 13);
                String sec = s.substring(13, 19).trim();
                Date date = this.dateIn.parse(year + monthDay + hourMin + sec);
                double j2ksec = Util.dateToJ2K(date);
                double latdeg = Double.parseDouble(s.substring(19, 22).trim());
                double latmin = Double.parseDouble(s.substring(23, 28).trim());
                double lat = latdeg + latmin / 60.0;
                char ns = s.charAt(22);
                if (ns == 'S') {
                    lat *= -1.0;
                }
                double londeg = Double.parseDouble(s.substring(28, 32).trim());
                char ew = s.charAt(32);
                double lonmin = Double.parseDouble(s.substring(33, 38).trim());
                double lon = londeg + lonmin / 60.0;
                if (ew != 'W') {
                    lon *= -1.0;
                }
                double depth = -Double.parseDouble(s.substring(38, 45).trim());
                double mag = Double.parseDouble(s.substring(47, 52).trim());
                if (!s.substring(45, 46).equals(" ")) {
                    throw new Exception("corrupt data at column 46");
                }
                System.out.println("HC: " + j2ksec + " : " + lon + " : " + lat + " : " + depth + " : " + mag);
                Hypocenter hc = new Hypocenter(j2ksec, 0, lat, lon, depth, mag);
                hypos.add(hc);
            }
            catch (Exception e) {
                System.err.println("Line " + lines + ": " + e.getMessage());
            }
        }
        rr.close();
        return hypos;
    }

    public static void main(String[] as) {
        Arguments args = new Arguments(as, flags, keys);
        SQLHypocenterDataSource ds = Importer.getDataSource(args);
        ImportH71.process(args, new ImportH71(ds));
    }
}

