/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.tilt;

import gov.usgs.util.ConfigFile;
import gov.usgs.vdx.data.Channel;
import gov.usgs.vdx.data.Column;
import gov.usgs.vdx.data.DataSource;
import gov.usgs.vdx.data.SQLDataSource;
import gov.usgs.vdx.data.tilt.TiltData;
import gov.usgs.vdx.server.BinaryResult;
import gov.usgs.vdx.server.RequestResult;
import gov.usgs.vdx.server.TextResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLTiltDataSource
extends SQLDataSource
implements DataSource {
    public static final String DATABASE_NAME = "tilt";
    public static final boolean channels = true;
    public static final boolean translations = true;
    public static final boolean channelTypes = false;
    public static final boolean ranks = true;
    public static final boolean columns = true;
    public static final boolean menuColumns = true;
    public static final Column[] DATA_COLUMNS = new Column[]{new Column(1, "xTilt", "East", "tilt (microradians)", false, true), new Column(2, "yTilt", "North", "tilt (microradians)", false, true), new Column(3, "holeTemp", "Hole Temperature", "temperature (C)", false, true), new Column(4, "boxTemp", "Box Temperature", "temperature (C)", false, true), new Column(5, "instVolt", "Instrument Voltage", "voltage (V)", false, true), new Column(6, "gndVolt", "Ground Voltage", "voltage (V)", false, true), new Column(7, "rainfall", "Rainfall", "rainfall (cm)", false, true)};
    public static final Column[] MENU_COLUMNS = new Column[]{new Column(1, "radial", "Radial", "tilt (microradians)", true, true), new Column(2, "tangential", "Tangential", "tilt (microradians)", true, true), new Column(3, "xTilt", "East", "tilt (microradians)", false, true), new Column(4, "yTilt", "North", "tilt (microradians)", false, true), new Column(5, "magnitude", "Magnitude", "tilt (microradians)", false, false), new Column(6, "azimuth", "Azimuth", "tilt (microradians)", false, false), new Column(7, "holeTemp", "Hole Temperature", "temperature (C)", false, false), new Column(8, "boxTemp", "Box Temperature", "temperature (C)", false, false), new Column(9, "instVolt", "Instrument Voltage", "voltage (V)", false, false), new Column(10, "rainfall", "Rainfall", "rainfall (cm)", false, false)};

    @Override
    public String getType() {
        return DATABASE_NAME;
    }

    @Override
    public boolean getChannelsFlag() {
        return true;
    }

    @Override
    public boolean getTranslationsFlag() {
        return true;
    }

    @Override
    public boolean getChannelTypesFlag() {
        return false;
    }

    @Override
    public boolean getRanksFlag() {
        return true;
    }

    @Override
    public boolean getColumnsFlag() {
        return true;
    }

    @Override
    public boolean getMenuColumnsFlag() {
        return true;
    }

    @Override
    public void initialize(ConfigFile params) {
        this.defaultInitialize(params);
        if (!this.databaseExists()) {
            this.createDatabase();
        }
    }

    @Override
    public void disconnect() {
        this.defaultDisconnect();
    }

    @Override
    public boolean databaseExists() {
        return this.defaultDatabaseExists();
    }

    @Override
    public boolean createDatabase() {
        try {
            int i;
            this.defaultCreateDatabase(true, true, false, true, true, true);
            for (i = 0; i < DATA_COLUMNS.length; ++i) {
                this.defaultInsertColumn(DATA_COLUMNS[i]);
            }
            for (i = 0; i < MENU_COLUMNS.length; ++i) {
                this.defaultInsertMenuColumn(MENU_COLUMNS[i]);
            }
            this.defaultCreateTranslation();
            this.database.useDatabase(this.dbName);
            this.st = this.database.getStatement();
            this.st.execute("ALTER TABLE channels\t ADD azimuth DOUBLE DEFAULT 0");
            this.st.execute("ALTER TABLE translations ADD azimuth DOUBLE DEFAULT 0");
            return true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLTiltDataSource.createDatabase() failed.", e);
            return false;
        }
    }

    public boolean createChannel(String channelCode, String channelName, double lon, double lat, double height, int tid, double azimuth) {
        Channel channel = new Channel(0, channelCode, channelName, lon, lat, height);
        return this.defaultCreateTiltChannel(channel, tid, azimuth, true, true, true, true);
    }

    @Override
    public RequestResult getData(Map<String, String> params) {
        double et;
        double st;
        int rid;
        int cid;
        TiltData data;
        String action = params.get("action");
        if (action == null) {
            return null;
        }
        if (action.equals("channels")) {
            return new TextResult(this.defaultGetChannels(false));
        }
        if (action.equals("ranks")) {
            return new TextResult(this.defaultGetRanks());
        }
        if (action.equals("columns")) {
            return new TextResult(this.defaultGetMenuColumns(true));
        }
        if (action.equals("azimuths")) {
            return new TextResult(this.getAzimuths());
        }
        if (action.equals("data") && (data = this.getTiltData(cid = Integer.parseInt(params.get("ch")), rid = Integer.parseInt(params.get("rk")), st = Double.parseDouble(params.get("st")), et = Double.parseDouble(params.get("et")))) != null) {
            return new BinaryResult(data);
        }
        return null;
    }

    public TiltData getTiltData(int cid, int rid, double st, double et) {
        ArrayList<double[]> pts = new ArrayList<double[]>();
        TiltData result = null;
        int columnsReturned = 0;
        try {
            this.database.useDatabase(this.dbName);
            Channel channel = this.defaultGetChannel(cid, false);
            columnsReturned = 8;
            this.sql = "SELECT a.j2ksec, c.rid, ";
            this.sql = this.sql + "       COS(RADIANS(b.azimuth))  * (xTilt * cxTilt + dxTilt) + SIN(RADIANS(b.azimuth)) * (yTilt * cyTilt + dyTilt), ";
            this.sql = this.sql + "       -SIN(RADIANS(b.azimuth)) * (xTilt * cxTilt + dxTilt) + COS(RADIANS(b.azimuth)) * (yTilt * cyTilt + dyTilt), ";
            this.sql = this.sql + "       holeTemp * choleTemp + dholeTemp, ";
            this.sql = this.sql + "       boxTemp  * cboxTemp  + dboxTemp,  ";
            this.sql = this.sql + "       instVolt * cinstVolt + dinstVolt, ";
            this.sql = this.sql + "       rainfall * crainfall + drainfall  ";
            this.sql = this.sql + "FROM " + channel.getCode() + " a ";
            this.sql = this.sql + "       INNER JOIN translations  b ON a.tid = b.tid ";
            this.sql = this.sql + "       INNER JOIN ranks         c ON a.rid = c.rid ";
            this.sql = this.sql + "WHERE  j2ksec >= ? ";
            this.sql = this.sql + "AND    j2ksec <= ? ";
            if (rid != 0) {
                this.sql = this.sql + "AND   c.rid = ? ";
            } else if (rid == 0) {
                this.sql = this.sql + "AND   c.rank = (SELECT MAX(e.rank) " + "FROM   " + channel.getCode() + " d, ranks e " + "WHERE  d.rid = e.rid  " + "AND    a.j2ksec = d.j2ksec) ";
            }
            this.sql = this.sql + "ORDER BY j2ksec ASC";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.ps.setDouble(1, st);
            this.ps.setDouble(2, et);
            if (rid != 0) {
                this.ps.setInt(3, rid);
            }
            this.rs = this.ps.executeQuery();
            while (this.rs.next()) {
                double[] dataRow = new double[columnsReturned];
                for (int i = 0; i < columnsReturned; ++i) {
                    double value = this.rs.getDouble(i + 1);
                    if (this.rs.wasNull()) {
                        value = Double.NaN;
                    }
                    dataRow[i] = value;
                }
                pts.add(dataRow);
            }
            this.rs.close();
            if (pts.size() > 0) {
                return new TiltData(pts);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLTiltDataSource.getTiltData()", e);
        }
        return result;
    }

    public List<String> getAzimuths() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            this.database.useDatabase(this.dbName);
            this.rs = this.database.getPreparedStatement("SELECT cid, azimuth FROM channels ORDER BY cid").executeQuery();
            while (this.rs.next()) {
                result.add(String.format("%d:%f", this.rs.getInt(1), this.rs.getDouble(2)));
            }
            this.rs.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLTiltDataSource.getAzimuths() failed.", e);
        }
        return result;
    }

    public double getNominalAzimuth(String channelCode) {
        double result = 0.0;
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("SELECT azimuth FROM channels WHERE code = ?");
            this.ps.setString(1, channelCode);
            this.rs = this.ps.executeQuery();
            this.rs.next();
            result = this.rs.getDouble(1);
            this.rs.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLTiltDataSource.getNominalAzimuth() failed.", e);
        }
        return result;
    }
}

