/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.hypo;

import gov.usgs.proj.Projection;
import java.awt.geom.Point2D;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.nio.ByteBuffer;

public class Hypocenter {
    public double j2ksec;
    public String eid;
    public Integer rid;
    public double lat;
    public double lon;
    public double depth;
    public double prefmag;
    public double ampmag;
    public double codamag;
    public Integer nphases;
    public Integer azgap;
    public double dmin;
    public double rms;
    public Integer nstimes;
    public double herr;
    public double verr;
    public String magtype;
    public String rmk;

    public Hypocenter(double j2ksec, Integer rid, double lat, double lon, double depth, double prefmag) {
        this(j2ksec, null, rid, lat, lon, depth, prefmag, Double.NaN, Double.NaN, null, null, Double.NaN, Double.NaN, null, Double.NaN, Double.NaN, null, null);
    }

    public Hypocenter(double j2ksec, String eid, Integer rid, double lat, double lon, double depth, double prefmag, double ampmag, double codamag, Integer nphases, Integer azgap, double dmin, double rms, Integer nstimes, double herr, double verr, String magtype, String rmk) {
        this.j2ksec = j2ksec;
        this.eid = eid;
        this.rid = rid;
        this.lat = lat;
        this.lon = lon;
        this.depth = depth;
        this.prefmag = prefmag;
        this.ampmag = ampmag;
        this.codamag = codamag;
        this.nphases = nphases;
        this.azgap = azgap;
        this.dmin = dmin;
        this.rms = rms;
        this.nstimes = nstimes;
        this.herr = herr;
        this.verr = verr;
        this.magtype = magtype;
        this.rmk = rmk;
    }

    public void project(Projection proj) {
        Point2D.Double pt = new Point2D.Double(this.lon, this.lat);
        pt = proj.forward(pt);
        this.lon = pt.x;
        this.lat = pt.y;
    }

    public static String getHeaderLine() {
        return "j2ksec,lat,lon,depth,mag";
    }

    public String toString() {
        return this.j2ksec + "," + this.lat + "," + this.lon + "," + this.depth + "," + this.prefmag;
    }

    public void insertIntoByteBuffer(ByteBuffer buffer) {
        buffer.putDouble(this.j2ksec);
        buffer.putInt(this.rid);
        buffer.putDouble(this.lat);
        buffer.putDouble(this.lon);
        buffer.putDouble(this.depth);
        buffer.putDouble(this.prefmag);
    }

    public static void outputRawData(String fn, String extra, Hypocenter[] data) {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(fn, true));
            out.print("Earthquake hypocenters");
            if (extra != null) {
                out.println(" [" + extra + "]");
            } else {
                out.println();
            }
            Hypocenter.getHeaderLine();
            for (int i = 0; i < data.length; ++i) {
                out.println(data[i].toString());
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

