/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.generic.variable;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Station
implements Comparable<Object> {
    private int sid;
    private String org;
    private String siteNo;
    private String name;
    private double lon;
    private double lat;
    private String tz;
    private boolean active;

    public Station() {
        this.sid = -1;
        this.org = null;
        this.siteNo = null;
        this.name = null;
        this.lon = -999.0;
        this.lat = -999.0;
        this.tz = "GMT";
        this.active = true;
    }

    public Station(String s) {
        String[] parts = s.split(":");
        this.sid = Integer.parseInt(parts[0]);
        this.org = parts[4];
        this.siteNo = parts[5];
        this.name = parts[6];
        this.lon = Double.parseDouble(parts[1]);
        this.lat = Double.parseDouble(parts[2]);
        this.active = true;
    }

    public Station(int id, String o, String s, String n, double ln, double lt, String t, boolean a) {
        this.sid = id;
        this.org = o;
        this.siteNo = s;
        this.name = n;
        this.lon = ln;
        this.lat = lt;
        this.tz = t;
        this.active = a;
    }

    public static List<Station> fromStringsToList(List<String> ss) {
        ArrayList<Station> stations = new ArrayList<Station>();
        for (String s : ss) {
            stations.add(new Station(s));
        }
        return stations;
    }

    public static Map<String, Station> fromStringsToMap(List<String> ss) {
        HashMap<String, Station> map = new HashMap<String, Station>();
        for (String s : ss) {
            Station station = new Station(s);
            map.put(Integer.toString(station.getId()), station);
        }
        return map;
    }

    public void setId(int i) {
        this.sid = i;
    }

    public int getId() {
        return this.sid;
    }

    public void setOrg(String o) {
        this.org = o;
    }

    public String getOrg() {
        return this.org;
    }

    public void setSiteNo(String s) {
        this.siteNo = s;
    }

    public String getSiteNo() {
        return this.siteNo;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public double getLon() {
        return this.lon;
    }

    public double getLat() {
        return this.lat;
    }

    public String getTz() {
        return this.tz;
    }

    public boolean getActive() {
        return this.active;
    }

    public Point2D.Double getLonLat() {
        return new Point2D.Double(this.lon, this.lat);
    }

    public String toString() {
        return this.org + this.siteNo;
    }

    public String toFullString() {
        return this.sid + ":" + this.lon + ":" + this.lat + ":" + this.tz + ":" + this.org + ":" + this.siteNo + ":" + this.name;
    }

    @Override
    public int compareTo(Object s) {
        if (s instanceof String) {
            return this.siteNo.compareTo((String)s);
        }
        return this.siteNo.compareTo(((Station)s).siteNo);
    }
}

