/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util.xml;

import gov.usgs.util.xml.SimpleXMLParser;
import gov.usgs.util.xml.XMLDocHandler;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLToMap
implements XMLDocHandler {
    private List<String> path = new ArrayList<String>();
    private String current;
    private boolean ended;
    public Map<String, String> text = new HashMap<String, String>();
    public Map<String, Map<String, String>> attributes = new HashMap<String, Map<String, String>>();

    @Override
    public void startDocument() throws Exception {
    }

    @Override
    public void endDocument() throws Exception {
    }

    @Override
    public void startElement(String tag, Map<String, String> h) throws Exception {
        StringBuilder sb = new StringBuilder(256);
        for (String p : this.path) {
            sb.append(p);
            sb.append('/');
        }
        this.path.add(tag == null ? "" : tag);
        sb.append(this.path.get(this.path.size() - 1));
        this.current = sb.toString();
        this.attributes.put(this.current, h);
        this.ended = false;
    }

    @Override
    public void endElement(String tag) throws Exception {
        this.ended = true;
        this.path.remove(this.path.size() - 1);
    }

    @Override
    public void text(String str) throws Exception {
        if (!this.ended) {
            this.text.put(this.current, str);
        }
    }

    public static void reportOnFile(String file) throws Exception {
        FileReader fr = new FileReader(file);
        XMLToMap map = new XMLToMap();
        SimpleXMLParser.parse(map, fr);
        System.out.println("Text:");
        for (String key : map.text.keySet()) {
            System.out.println(key + " = " + map.text.get(key));
        }
        System.out.println("Attributes:");
        for (String key : map.attributes.keySet()) {
            Map<String, String> attr = map.attributes.get(key);
            if (attr == null || attr.size() <= 0) continue;
            System.out.println(key + ":");
            for (String akey : attr.keySet()) {
                System.out.println("\t" + akey + " = " + attr.get(akey));
            }
        }
        fr.close();
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            XMLToMap.reportOnFile(args[0]);
        }
    }
}

