/**EWQuakeAlert generates email messages when receiving HYP2000ARC
 * messages from Earthworm.
 * Copyright (C) 2009 Ruben S. Luis
 * This program is free software: you ca redistribute it an/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be usefull,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with EWQuakeAlert. If not, see <http://www.gnu.org/licenses/>.
 **/

package ewquakealert;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;

/**
 *
 * @author RL197718
 */
public class Configuration implements Serializable{

    static public boolean useWaveServer = true;
    static public String waveserverIP = "192.168.0.1";
    static public int waveserverPort = 16022;
    static public String last_png = "";
    public static int graphHeight = 50;
    public static int graphWidth = 800;
    
    static public int clientStatus = 0;
    static public Socket socket;
    static public DataInputStream Sinput;
    static public DataOutputStream Soutput;
    static public String serverIP = "192.168.0.1";
    static public int serverPort = 16005;
    static public boolean automaticReconnect = true;
    static public int sendAliveInt = 30;
    static public int recvAliveInt = 30;
    static public String sendAliveText = "toEW";
    static public String recvAliveText = "fromEW";

    public static String email = "recipient@domain.pt";
    public static String host = "smtp.domain.pt";
    public static String username = "username";
    public static String password = "password";
    public static String[] destEmail = {"destination@domain.pt",
        "",
        "",
        "",
        ""};

    public static boolean sendPicks = true;
    public static boolean alertWhenFail = true;
    public static boolean alertWhenRestore = true;
    public static boolean alreadyAlerted = false;

    public static boolean sendSMS = true;
    public static String SMSProvider = "clickatell";
    public static String SMSAPIid = "0000000";
    public static String SMSuser = "username";
    public static String SMSpassword = "password";
    public static String[] SMSdestinations = {"351000000000","","","",""};





    private String waveserverIPt, serverIPt, sendAliveTextt, recvAliveTextt,
            emailt, hostt, usernamet, passwordt, SMSProvidert, SMSAPIidt, SMSusert,
            SMSpasswordt;
    private String[] destEmailt, SMSdestinationst;
    private int waveserverPortt, graphHeightt, graphWidtht, serverPortt,
            sendAliveIntt, recvAliveIntt;
    private boolean useWaveServert, automaticReconnectt, sendPickst, alertWhenFailt,
            sendSMSt, alertWhenRestoret;



    public void saveConfig(Configuration config) {
        waveserverIPt = waveserverIP;
        serverIPt = serverIP;
        sendAliveTextt = sendAliveText;
        recvAliveTextt = recvAliveText;
        emailt = email;
        hostt = host;
        usernamet = username;
        passwordt = password;
        destEmailt = destEmail;
        waveserverPortt = waveserverPort;
        graphHeightt = graphHeight;
        graphWidtht = graphWidth;
        serverPortt = serverPort;
        sendAliveIntt = sendAliveInt;
        recvAliveIntt = recvAliveInt;
        useWaveServert = useWaveServer;
        automaticReconnectt = automaticReconnect;
        sendPickst = sendPicks;
        alertWhenFailt = alertWhenFail;
        sendSMSt = sendSMS;
        SMSProvidert = SMSProvider;
        SMSAPIidt = SMSAPIid;
        SMSusert = SMSuser;
        SMSpasswordt = SMSpassword;
        SMSdestinationst = SMSdestinations;
        alertWhenRestoret = alertWhenRestore;

        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream("EWquakealert.cfg"));
            out.writeObject(config);
            out.close();
            EWQuakeAlertView.println("Saved configuration.");
        }
        catch (Exception e){
            EWQuakeAlertView.println("Failed to save configuration.");
        }
    } //End of saveConfig

    @SuppressWarnings("static-access")
    public void loadConfig(Configuration config) {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream("EWquakealert.cfg"));
            config = (Configuration)in.readObject();
            in.close();
            EWQuakeAlertView.println("Configuration loaded.");

            waveserverIP = config.waveserverIPt;
            serverIP = config.serverIPt;
            sendAliveText = config.sendAliveTextt;
            recvAliveText = config.recvAliveTextt;
            email = config.emailt;
            host = config.hostt;
            username = config.usernamet;
            password = config.passwordt;
            destEmail = config.destEmailt;
            waveserverPort = config.waveserverPortt;
            graphHeight = config.graphHeightt;
            graphWidth = config.graphWidtht;
            serverPort = config.serverPortt;
            sendAliveInt = config.sendAliveIntt;
            recvAliveInt = config.recvAliveIntt;
            useWaveServer = config.useWaveServert;
            automaticReconnect = config.automaticReconnectt;
            sendPicks = config.sendPickst;
            alertWhenFail = config.alertWhenFailt;
            sendSMS = config.sendSMSt;
            SMSProvider = config.SMSProvidert;
            SMSAPIid = config.SMSAPIidt;
            SMSuser = config.SMSusert;
            SMSpassword = config.SMSpasswordt;
            SMSdestinations = config.SMSdestinationst;
            alertWhenRestore = config.alertWhenRestoret;
        }
        catch (Exception e) {
            EWQuakeAlertView.println("Failed to load configuration.");
        }
    } //End loadConfig

}
