/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130.packetTypes;

import edu.sc.seis.fissuresUtil.rt130.PacketType;
import java.io.DataInput;
import java.io.IOException;

public class StationChannelParameterPacket
extends PacketType {
    public String experimentNumber;
    public String experimentName;
    public String experimentComment;
    public String stationNumber;
    public String stationName;
    public String stationComment;
    public String dasModel;
    public String dasSerialNumber;
    public String experimentStart;
    public String timeClockType;
    public String timeClockSignalToNoiseRatio;
    public String[] channelNumber = new String[5];
    public String[] channelName = new String[5];
    public String[] azimuth = new String[5];
    public String[] inclination = new String[5];
    public String[] xCoordinate = new String[5];
    public String[] yCoordinate = new String[5];
    public String[] zCoordinate = new String[5];
    public String[] unitTypeXY = new String[5];
    public String[] unitTypeZ = new String[5];
    public String[] preampGain = new String[5];
    public String[] sensorModel = new String[5];
    public String[] sensorSerialNumber = new String[5];
    public String[] comments = new String[5];
    public String[] adjustedNominalBitWeight = new String[5];

    public StationChannelParameterPacket(StationChannelParameterPacket original) {
    }

    public StationChannelParameterPacket(DataInput in) throws IOException {
        this.read(in);
    }

    private void read(DataInput in) throws IOException {
        this.experimentNumber = new String(this.readBytes(in, 2));
        this.experimentName = new String(this.readBytes(in, 24));
        this.experimentComment = new String(this.readBytes(in, 40));
        this.stationNumber = new String(this.readBytes(in, 4));
        this.stationName = new String(this.readBytes(in, 24));
        this.stationComment = new String(this.readBytes(in, 40));
        this.dasModel = new String(this.readBytes(in, 12));
        this.dasSerialNumber = new String(this.readBytes(in, 12));
        this.experimentStart = new String(this.readBytes(in, 14));
        this.timeClockType = new String(this.readBytes(in, 4));
        this.timeClockSignalToNoiseRatio = new String(this.readBytes(in, 10));
        for (int i = 0; i < 5; ++i) {
            this.channelNumber[i] = new String(this.readBytes(in, 2));
            this.channelName[i] = new String(this.readBytes(in, 10)).trim();
            this.azimuth[i] = new String(this.readBytes(in, 10));
            this.inclination[i] = new String(this.readBytes(in, 10));
            this.xCoordinate[i] = new String(this.readBytes(in, 10));
            this.yCoordinate[i] = new String(this.readBytes(in, 10));
            this.zCoordinate[i] = new String(this.readBytes(in, 10));
            this.unitTypeXY[i] = new String(this.readBytes(in, 4));
            this.unitTypeZ[i] = new String(this.readBytes(in, 4));
            this.preampGain[i] = new String(this.readBytes(in, 4));
            this.sensorModel[i] = new String(this.readBytes(in, 12));
            this.sensorSerialNumber[i] = new String(this.readBytes(in, 12));
            this.comments[i] = new String(this.readBytes(in, 40));
            this.adjustedNominalBitWeight[i] = new String(this.readBytes(in, 8));
        }
        in.skipBytes(92);
    }

    private byte[] readBytes(DataInput in, int numBytes) throws IOException {
        byte[] seqBytes = new byte[numBytes];
        in.readFully(seqBytes);
        return seqBytes;
    }
}

