/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.parmo3d;

import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import edu.sc.seis.fissuresUtil.exceptionHandler.GUIReporter;
import edu.sc.seis.fissuresUtil.parmo3d.Shaker3D;
import edu.sc.seis.fissuresUtil.parmo3d.Text2D;
import edu.sc.seis.fissuresUtil.parmo3d.tjoInterpolator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class PartMo
extends JPanel {
    public BranchGroup createSceneGraph(float baz, float ang) {
        int i;
        BranchGroup objRoot = new BranchGroup();
        BranchGroup Axes = new Axis().getAxisBG();
        BranchGroup Surface = new Axis().getSurfaceBG();
        BranchGroup Motion = new MotionVector(baz, ang).getMotionBG();
        BranchGroup Trace = new Traces(baz, ang).getTraceBG();
        Transform3D rotateX = new Transform3D();
        Transform3D rotateY = new Transform3D();
        Transform3D rotateZ = new Transform3D();
        double zRotation = 90.0;
        double xRotation = -135.0;
        double yRotation = -45.0;
        rotateX.rotX(Math.toRadians(xRotation));
        rotateZ.rotZ(Math.toRadians(zRotation));
        rotateY.rotY(Math.toRadians(yRotation));
        Transform3D rotate = new Transform3D();
        Transform3D shift = new Transform3D();
        Transform3D scale = new Transform3D();
        Transform3D PlaceCoordSystem = new Transform3D();
        rotate.mul(rotateZ);
        rotate.mul(rotateY);
        rotate.mul(rotateX);
        scale.setScale(0.5);
        shift.setTranslation(new Vector3f(0.0f, 0.4f, 0.0f));
        PlaceCoordSystem.mul(shift);
        PlaceCoordSystem.mul(rotate);
        PlaceCoordSystem.mul(scale);
        Transform3D SurfShift = new Transform3D();
        SurfShift.setTranslation(new Vector3f(0.0f, 0.36f, 0.0f));
        Transform3D PlaceSurface = new Transform3D();
        PlaceSurface.mul(SurfShift);
        PlaceSurface.mul(rotate);
        PlaceSurface.mul(scale);
        Point3f textpt = new Point3f(1.0f, 0.0f, 0.0f);
        PlaceCoordSystem.transform(textpt);
        Text2D up = new Text2D("Up", textpt, new Color3f(1.0f, 0.0f, 0.0f), "Helvetica", 16, 1);
        objRoot.addChild((Node)up);
        textpt = new Point3f(-1.2f, 0.0f, 0.0f);
        PlaceCoordSystem.transform(textpt);
        Text2D down = new Text2D("Down", textpt, new Color3f(1.0f, 0.0f, 0.0f), "Helvetica", 16, 1);
        objRoot.addChild((Node)down);
        textpt = new Point3f(0.0f, 1.2f, 0.0f);
        PlaceCoordSystem.transform(textpt);
        Text2D east = new Text2D("East", textpt, new Color3f(0.0f, 1.0f, 0.2f), "Helvetica", 16, 1);
        objRoot.addChild((Node)east);
        textpt = new Point3f(0.0f, -1.2f, 0.2f);
        PlaceCoordSystem.transform(textpt);
        Text2D west = new Text2D("West", textpt, new Color3f(0.0f, 1.0f, 0.0f), "Helvetica", 16, 1);
        objRoot.addChild((Node)west);
        textpt = new Point3f(0.0f, 0.0f, 1.1f);
        PlaceCoordSystem.transform(textpt);
        Text2D north = new Text2D("North", textpt, new Color3f(0.0f, 0.0f, 1.0f), "Helvetica", 16, 1);
        objRoot.addChild((Node)north);
        textpt = new Point3f(0.0f, 0.0f, -1.2f);
        PlaceCoordSystem.transform(textpt);
        Text2D south = new Text2D("South", textpt, new Color3f(0.0f, 0.0f, 1.0f), "Helvetica", 16, 1);
        objRoot.addChild((Node)south);
        textpt = new Point3f(-1.2f, -1.4f, -1.0f);
        Text2D caption = new Text2D("Press and Hold any key to start animation", textpt, new Color3f(0.0f, 0.0f, 0.0f), "TimesRoman", 24, 1);
        objRoot.addChild((Node)caption);
        Alpha alpha = new Alpha(-1, 4000L);
        TransformGroup ZsingAlong = new TransformGroup();
        Transform3D ZaxisOfPos = new Transform3D();
        ZaxisOfPos.set(new Vector3f(1.0f, 0.0f, 0.0f));
        ZsingAlong.setCapability(18);
        TransformGroup NsingAlong = new TransformGroup();
        Transform3D NaxisOfPos = new Transform3D();
        NaxisOfPos.set(new Vector3f(1.0f, 0.0f, 0.0f));
        NsingAlong.setCapability(18);
        TransformGroup EsingAlong = new TransformGroup();
        Transform3D EaxisOfPos = new Transform3D();
        EaxisOfPos.set(new Vector3f(1.0f, 0.0f, 0.0f));
        EsingAlong.setCapability(18);
        int nknots = new Traces(baz, ang).getNumberOfPoints();
        Point3f[] zSing = new Point3f[nknots];
        Point3f[] eSing = new Point3f[nknots];
        Point3f[] nSing = new Point3f[nknots];
        float[] knots = new float[nknots];
        float[] zknots = new float[nknots];
        float knotInc = 1.0f / (float)(nknots - 1);
        for (i = 0; i < nknots; ++i) {
            knots[i] = (float)i * knotInc;
            zknots[i] = (float)i * knotInc;
        }
        new Traces(baz, ang).getSingAlongPoints(zSing, nSing, eSing);
        tjoInterpolator nSinger = new tjoInterpolator(alpha, NsingAlong, NaxisOfPos, knots, nSing);
        nSinger.setSchedulingBounds((Bounds)new BoundingSphere());
        tjoInterpolator eSinger = new tjoInterpolator(alpha, EsingAlong, EaxisOfPos, knots, eSing);
        eSinger.setSchedulingBounds((Bounds)new BoundingSphere());
        tjoInterpolator zSinger = new tjoInterpolator(alpha, ZsingAlong, ZaxisOfPos, knots, zSing);
        zSinger.setSchedulingBounds((Bounds)new BoundingSphere());
        int GMknots = 41;
        Point3f[] GMpoints = new Point3f[41];
        Point3f[] GMzOnly = new Point3f[41];
        Point3f[] GMeOnly = new Point3f[41];
        Point3f[] GMnOnly = new Point3f[41];
        new MotionVector(baz, ang).getMotionPoints(GMpoints);
        float[] gknots = new float[GMknots];
        float gnotInc = 1.0f / (float)(GMknots - 1);
        for (i = 0; i < GMknots; ++i) {
            gknots[i] = (float)i * gnotInc;
            float[] t = new float[3];
            GMpoints[i].get(t);
            GMzOnly[i] = new Point3f(t[0], 0.0f, 0.0f);
            GMeOnly[i] = new Point3f(0.0f, t[1], 0.0f);
            GMnOnly[i] = new Point3f(0.0f, 0.0f, t[2]);
            PlaceCoordSystem.transform(GMpoints[i]);
            PlaceCoordSystem.transform(GMzOnly[i]);
            PlaceCoordSystem.transform(GMeOnly[i]);
            PlaceCoordSystem.transform(GMnOnly[i]);
        }
        TransformGroup GMsingAlong = new TransformGroup();
        GMsingAlong.setCapability(18);
        TransformGroup GMzOnly_singAlong = new TransformGroup();
        GMzOnly_singAlong.setCapability(18);
        TransformGroup GMnOnly_singAlong = new TransformGroup();
        GMnOnly_singAlong.setCapability(18);
        TransformGroup GMeOnly_singAlong = new TransformGroup();
        GMeOnly_singAlong.setCapability(18);
        Transform3D GMaxisOfPos = new Transform3D();
        GMaxisOfPos.set(new Vector3f(0.0f, 1.0f, 0.0f));
        tjoInterpolator gmSinger = new tjoInterpolator(alpha, GMsingAlong, GMaxisOfPos, gknots, GMpoints);
        gmSinger.setSchedulingBounds((Bounds)new BoundingSphere());
        tjoInterpolator gmZonlySinger = new tjoInterpolator(alpha, GMzOnly_singAlong, GMaxisOfPos, gknots, GMzOnly);
        gmZonlySinger.setSchedulingBounds((Bounds)new BoundingSphere());
        tjoInterpolator gmNonlySinger = new tjoInterpolator(alpha, GMnOnly_singAlong, GMaxisOfPos, gknots, GMnOnly);
        gmNonlySinger.setSchedulingBounds((Bounds)new BoundingSphere());
        tjoInterpolator gmEonlySinger = new tjoInterpolator(alpha, GMeOnly_singAlong, GMaxisOfPos, gknots, GMeOnly);
        gmEonlySinger.setSchedulingBounds((Bounds)new BoundingSphere());
        TransformGroup objPlace3D = new TransformGroup(PlaceCoordSystem);
        TransformGroup objPlaceSurf = new TransformGroup(PlaceSurface);
        Background background = new Background();
        background.setColor(0.6f, 0.6f, 0.6f);
        background.setApplicationBounds((Bounds)new BoundingSphere());
        objRoot.addChild((Node)background);
        objPlace3D.addChild((Node)Axes);
        objPlace3D.addChild((Node)Motion);
        objRoot.addChild((Node)objPlace3D);
        objPlaceSurf.addChild((Node)Surface);
        objRoot.addChild((Node)objPlaceSurf);
        objRoot.addChild((Node)Trace);
        objRoot.addChild((Node)ZsingAlong);
        objRoot.addChild((Node)zSinger);
        Appearance zSphere = new Appearance();
        ColoringAttributes zCA = new ColoringAttributes();
        zCA.setColor(1.0f, 0.0f, 0.0f);
        zSphere.setColoringAttributes(zCA);
        ZsingAlong.addChild((Node)new Sphere(0.02f, zSphere));
        objRoot.addChild((Node)NsingAlong);
        objRoot.addChild((Node)nSinger);
        Appearance nSphere = new Appearance();
        ColoringAttributes nCA = new ColoringAttributes();
        nCA.setColor(0.0f, 0.0f, 1.0f);
        nSphere.setColoringAttributes(nCA);
        NsingAlong.addChild((Node)new Sphere(0.02f, nSphere));
        objRoot.addChild((Node)EsingAlong);
        objRoot.addChild((Node)eSinger);
        Appearance eSphere = new Appearance();
        ColoringAttributes eCA = new ColoringAttributes();
        eCA.setColor(0.0f, 1.0f, 0.0f);
        eSphere.setColoringAttributes(eCA);
        EsingAlong.addChild((Node)new Sphere(0.02f, eSphere));
        objRoot.addChild((Node)GMzOnly_singAlong);
        objRoot.addChild((Node)gmZonlySinger);
        Appearance gmZonlySphere = new Appearance();
        ColoringAttributes gmZonlyCA = new ColoringAttributes();
        gmZonlyCA.setColor(1.0f, 0.0f, 0.0f);
        gmZonlySphere.setColoringAttributes(gmZonlyCA);
        GMzOnly_singAlong.addChild((Node)new Sphere(0.015f, gmZonlySphere));
        objRoot.addChild((Node)GMnOnly_singAlong);
        objRoot.addChild((Node)gmNonlySinger);
        Appearance gmNonlySphere = new Appearance();
        ColoringAttributes gmNonlyCA = new ColoringAttributes();
        gmNonlyCA.setColor(0.0f, 0.0f, 1.0f);
        gmNonlySphere.setColoringAttributes(gmNonlyCA);
        GMnOnly_singAlong.addChild((Node)new Sphere(0.015f, gmNonlySphere));
        objRoot.addChild((Node)GMeOnly_singAlong);
        objRoot.addChild((Node)gmEonlySinger);
        Appearance gmEonlySphere = new Appearance();
        ColoringAttributes gmEonlyCA = new ColoringAttributes();
        gmEonlyCA.setColor(0.0f, 1.0f, 0.0f);
        gmEonlySphere.setColoringAttributes(gmEonlyCA);
        GMeOnly_singAlong.addChild((Node)new Sphere(0.015f, gmEonlySphere));
        objRoot.addChild((Node)GMsingAlong);
        objRoot.addChild((Node)gmSinger);
        Appearance gmSphere = new Appearance();
        ColoringAttributes gmCA = new ColoringAttributes();
        gmCA.setColor(0.4f, 0.2f, 0.2f);
        gmSphere.setColoringAttributes(gmCA);
        GMsingAlong.addChild((Node)new Sphere(0.02f, gmSphere));
        objRoot.compile();
        return objRoot;
    }

    public PartMo(float baz, float ang) {
        this.setLayout(new BorderLayout());
        try {
            GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
            Canvas3D canvas3D = new Canvas3D(config);
            this.add("Center", (Component)canvas3D);
            BranchGroup scene = this.createSceneGraph(baz, ang);
            SimpleUniverse simpleU = new SimpleUniverse(canvas3D);
            simpleU.getViewingPlatform().setNominalViewingTransform();
            simpleU.addBranchGraph(scene);
        }
        catch (Throwable t) {
            GUIReporter.swapGreetingAndHandle(t, "Oooops!  GEE was unable to create the particle motion animation.  There must be a problem in the configuration of the animation on this system.  Don't panic ... this is our fault, not yours. If you use the Save button at the bottom of this screen to make a file of the details of this problem and email it to: geebugs@seis.sc.edu and we will try to help fix the configuration problem leading to this little hiccup. You should be able to continue your current GEE session without trouble.  Only particle motion animations are affected by this problem. Thanks for your help in improving GEE!");
        }
    }

    public class MotionVector {
        private BranchGroup motionBG;
        LineArray GroundMotion = new LineArray(82, 5);

        public MotionVector(float backAzimuth, float angleOfIncidence) {
            int jj;
            this.motionBG = new BranchGroup();
            for (jj = 0; jj < 82; ++jj) {
                this.GroundMotion.setCoordinate(jj, new Point3f(0.0f, 0.0f, 0.0f));
                this.GroundMotion.setColor(jj, new Color3f(0.0f, 0.0f, 0.0f));
            }
            LineAttributes la = new LineAttributes();
            float three = 3.0f;
            la.setLineWidth(three);
            la.setLinePattern(0);
            Appearance app = new Appearance();
            app.setLineAttributes(la);
            Shape3D gm = new Shape3D((Geometry)this.GroundMotion);
            gm.setAppearance(app);
            this.motionBG.addChild((Node)gm);
            Shaker3D shaker = new Shaker3D(0, backAzimuth, angleOfIncidence);
            shaker.getWaveLineArray(this.GroundMotion);
            for (jj = 0; jj < 82; ++jj) {
                Point3f point = new Point3f();
                this.GroundMotion.getCoordinate(jj, point);
                this.GroundMotion.setColor(jj, new Color3f(0.6f, 0.9f, 0.9f));
                float[] t = new float[3];
                point.get(t);
                if (!((double)t[0] < 0.0)) continue;
                this.GroundMotion.setColor(jj, new Color3f(0.6f, 0.9f, 0.9f));
            }
        }

        public BranchGroup getMotionBG() {
            return this.motionBG;
        }

        public void getMotionPoints(Point3f[] pointsGM) {
            int i = 0;
            int count = 0;
            while (i < 41) {
                Point3f point = new Point3f();
                this.GroundMotion.getCoordinate(count, point);
                pointsGM[i] = point;
                count = ++i * 2;
            }
        }
    }

    public class Traces {
        private BranchGroup traceBG;
        private BranchGroup singAlongBG;
        int numberOfPoints = 82;
        PointArray zPointArray = new PointArray(this.numberOfPoints, 1);
        PointArray ePointArray = new PointArray(this.numberOfPoints, 1);
        PointArray nPointArray = new PointArray(this.numberOfPoints, 1);

        public Traces(float backAzimuth, float angleOfIncidence) {
            this.traceBG = new BranchGroup();
            this.singAlongBG = new BranchGroup();
            this.zPointArray.setCapability(0);
            this.ePointArray.setCapability(0);
            this.nPointArray.setCapability(0);
            Appearance zApp = new Appearance();
            Appearance eApp = new Appearance();
            Appearance nApp = new Appearance();
            ColoringAttributes z_coloring = new ColoringAttributes();
            ColoringAttributes e_coloring = new ColoringAttributes();
            ColoringAttributes n_coloring = new ColoringAttributes();
            z_coloring.setColor(1.0f, 1.0f, 1.0f);
            e_coloring.setColor(1.0f, 1.0f, 1.0f);
            n_coloring.setColor(1.0f, 1.0f, 1.0f);
            zApp.setColoringAttributes(z_coloring);
            eApp.setColoringAttributes(e_coloring);
            nApp.setColoringAttributes(n_coloring);
            PointAttributes points_points = new PointAttributes(5.0f, true);
            zApp.setPointAttributes(points_points);
            eApp.setPointAttributes(points_points);
            nApp.setPointAttributes(points_points);
            Shape3D ztr = new Shape3D((Geometry)this.zPointArray);
            ztr.setAppearance(zApp);
            this.traceBG.addChild((Node)ztr);
            Shape3D etr = new Shape3D((Geometry)this.ePointArray);
            etr.setAppearance(eApp);
            this.traceBG.addChild((Node)etr);
            Shape3D ntr = new Shape3D((Geometry)this.nPointArray);
            ntr.setAppearance(nApp);
            this.traceBG.addChild((Node)ntr);
            Appearance zSingAlong = new Appearance();
            Appearance eSingAlong = new Appearance();
            Appearance nSingAlong = new Appearance();
            ColoringAttributes z_sing = new ColoringAttributes();
            ColoringAttributes e_sing = new ColoringAttributes();
            ColoringAttributes n_sing = new ColoringAttributes();
            z_sing.setColor(1.0f, 0.0f, 0.0f);
            e_sing.setColor(0.0f, 1.0f, 0.0f);
            n_sing.setColor(0.0f, 0.0f, 1.0f);
            zSingAlong.setColoringAttributes(z_sing);
            eSingAlong.setColoringAttributes(e_sing);
            nSingAlong.setColoringAttributes(n_sing);
            PointAttributes sing_points = new PointAttributes(8.0f, true);
            zSingAlong.setPointAttributes(sing_points);
            eSingAlong.setPointAttributes(sing_points);
            nSingAlong.setPointAttributes(sing_points);
            Shape3D zSing = new Shape3D((Geometry)this.zPointArray);
            zSing.setAppearance(zSingAlong);
            this.singAlongBG.addChild((Node)zSing);
            Shape3D eSing = new Shape3D((Geometry)this.ePointArray);
            eSing.setAppearance(eSingAlong);
            this.singAlongBG.addChild((Node)eSing);
            Shape3D nSing = new Shape3D((Geometry)this.nPointArray);
            nSing.setAppearance(nSingAlong);
            this.singAlongBG.addChild((Node)nSing);
            Shaker3D shaker = new Shaker3D(0, this.numberOfPoints, backAzimuth, angleOfIncidence);
            shaker.getSeisPointArrays(this.zPointArray, this.ePointArray, this.nPointArray);
        }

        public BranchGroup getTraceBG() {
            return this.traceBG;
        }

        public void getSingAlongPoints(Point3f[] zSingArray, Point3f[] eSingArray, Point3f[] nSingArray) {
            int vertex = this.zPointArray.getVertexCount();
            for (int i = 0; i < vertex; ++i) {
                Point3f pointZ = new Point3f();
                Point3f pointE = new Point3f();
                Point3f pointN = new Point3f();
                this.zPointArray.getCoordinate(i, pointZ);
                zSingArray[i] = pointZ;
                this.ePointArray.getCoordinate(i, pointE);
                eSingArray[i] = pointE;
                this.nPointArray.getCoordinate(i, pointN);
                nSingArray[i] = pointN;
            }
        }

        public int getNumberOfPoints() {
            return this.numberOfPoints;
        }
    }

    public class Axis {
        private BranchGroup axisBG = new BranchGroup();
        private BranchGroup textBG = new BranchGroup();
        private BranchGroup surfaceBG = new BranchGroup();

        public Axis() {
            LineArray axisXLines = new LineArray(2, 1);
            this.axisBG.addChild((Node)new Shape3D((Geometry)axisXLines));
            axisXLines.setCoordinate(0, new Point3f(-1.0f, 0.0f, 0.0f));
            axisXLines.setCoordinate(1, new Point3f(1.0f, 0.0f, 0.0f));
            LineArray axisYLines = new LineArray(2, 1);
            this.axisBG.addChild((Node)new Shape3D((Geometry)axisYLines));
            axisYLines.setCoordinate(0, new Point3f(0.0f, -1.0f, 0.0f));
            axisYLines.setCoordinate(1, new Point3f(0.0f, 1.0f, 0.0f));
            LineArray axisZLines = new LineArray(2, 1);
            this.axisBG.addChild((Node)new Shape3D((Geometry)axisZLines));
            axisZLines.setCoordinate(0, new Point3f(0.0f, 0.0f, -1.0f));
            axisZLines.setCoordinate(1, new Point3f(0.0f, 0.0f, 1.0f));
            Appearance SurfaceLook = new Appearance();
            TransparencyAttributes SurfaceTransp = new TransparencyAttributes();
            SurfaceTransp.setTransparency(0.5f);
            SurfaceTransp.setTransparencyMode(2);
            ColoringAttributes SurfaceColor = new ColoringAttributes();
            SurfaceColor.setColor(0.0f, 0.8f, 0.0f);
            SurfaceColor.setShadeModel(3);
            SurfaceLook.setTransparencyAttributes(SurfaceTransp);
            SurfaceLook.setColoringAttributes(SurfaceColor);
            this.surfaceBG.addChild((Node)new Box(0.05f, 0.75f, 0.75f, SurfaceLook));
        }

        public BranchGroup getAxisBG() {
            return this.axisBG;
        }

        public BranchGroup getTextBG() {
            return this.textBG;
        }

        public BranchGroup getSurfaceBG() {
            return this.surfaceBG;
        }
    }
}

