/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.mseed;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfParameterMgr.ParameterRef;
import edu.iris.Fissures.IfRealTimeCollector.DataChunk;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.Property;
import edu.iris.Fissures.IfTimeSeries.EncodedData;
import edu.iris.Fissures.IfTimeSeries.TimeSeriesDataSel;
import edu.iris.Fissures.IfTimeSeries.TimeSeriesType;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.Fissures.seismogramDC.SeismogramAttrImpl;
import edu.sc.seis.fissuresUtil.database.DataCenterUtil;
import edu.sc.seis.seisFile.mseed.Blockette;
import edu.sc.seis.seisFile.mseed.Blockette100;
import edu.sc.seis.seisFile.mseed.Blockette1000;
import edu.sc.seis.seisFile.mseed.Btime;
import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.TimeZone;

public class FissuresConvert {
    static final byte RECORD_SIZE_POWER = 12;
    static int RECORD_SIZE = (int)Math.pow(2.0, 12.0);

    private FissuresConvert() {
    }

    public static DataRecord[] toMSeed(LocalSeismogram seis) throws SeedFormatException {
        return FissuresConvert.toMSeed(seis, 1);
    }

    public static DataRecord[] toMSeed(LocalSeismogram seis, int seqStart) throws SeedFormatException {
        LinkedList outRecords = new LinkedList();
        MicroSecondDate start = new MicroSecondDate(seis.begin_time);
        if (seis.data.discriminator().equals(TimeSeriesType.TYPE_ENCODED)) {
            EncodedData[] eData = seis.data.encoded_values();
            outRecords = FissuresConvert.toMSeed(eData, seis.channel_id, start, (SamplingImpl)seis.sampling_info, seqStart);
        } else if (seis.data.discriminator().equals(TimeSeriesType.TYPE_FLOAT)) {
            try {
                EncodedData[] eData = new EncodedData[(int)Math.ceil((float)seis.num_points * 4.0f / 3968.0f)];
                float[] data = seis.get_as_floats();
                for (int i = 0; i < eData.length; ++i) {
                    int j;
                    byte[] dataBytes = new byte[3968];
                    for (j = 0; j + 992 * i < data.length && j < 992; ++j) {
                        int val = Float.floatToIntBits(data[j + 992 * i]);
                        dataBytes[4 * j] = (byte)((val & 0xFF000000) >> 24);
                        dataBytes[4 * j + 1] = (byte)((val & 0xFF0000) >> 16);
                        dataBytes[4 * j + 2] = (byte)((val & 0xFF00) >> 8);
                        dataBytes[4 * j + 3] = (byte)(val & 0xFF);
                    }
                    if (j == 0) {
                        throw new SeedFormatException("try to put 0 float samples into an encodedData object j=" + j + " i=" + i + " seis.num_ppoints=" + seis.num_points);
                    }
                    eData[i] = new EncodedData(4, dataBytes, j, false);
                }
                outRecords = FissuresConvert.toMSeed(eData, seis.channel_id, start, (SamplingImpl)seis.sampling_info, seqStart);
            }
            catch (FissuresException e) {
                throw new SeedFormatException("Problem getting float data", (Throwable)e);
            }
        } else {
            throw new SeedFormatException("Can only handle EncodedData now, type=" + seis.data.discriminator().value());
        }
        return outRecords.toArray(new DataRecord[0]);
    }

    public static DataRecord[] toMSeed(DataChunk chunk) throws SeedFormatException {
        if (!chunk.data.discriminator().equals(TimeSeriesType.TYPE_ENCODED)) {
            throw new SeedFormatException("Can only handle EncodedData now");
        }
        LinkedList outRecords = FissuresConvert.toMSeed(chunk.data.encoded_values(), chunk.channel, new MicroSecondDate(chunk.begin_time), DataCenterUtil.getSampling(chunk), chunk.seq_num);
        return outRecords.toArray(new DataRecord[0]);
    }

    public static LinkedList toMSeed(EncodedData[] eData, ChannelId channel_id, MicroSecondDate start, SamplingImpl sampling_info, int seqStart) throws SeedFormatException {
        LinkedList<DataRecord> list = new LinkedList<DataRecord>();
        for (int i = 0; i < eData.length; ++i) {
            DataHeader header = new DataHeader(seqStart++, 'D', false);
            Blockette1000 b1000 = new Blockette1000();
            Blockette100 b100 = new Blockette100();
            if (eData[i].values.length + header.getSize() + b1000.getSize() + b100.getSize() >= RECORD_SIZE) {
                if (eData[i].values.length + header.getSize() + b1000.getSize() < RECORD_SIZE) {
                    b100 = null;
                } else {
                    throw new SeedFormatException("Can't fit data into record " + (eData[i].values.length + header.getSize() + b1000.getSize() + b100.getSize()) + " " + eData[i].values.length + " " + (header.getSize() + b1000.getSize() + b100.getSize()));
                }
            }
            header.setStationIdentifier(channel_id.station_code);
            header.setLocationIdentifier(channel_id.site_code);
            header.setChannelIdentifier(channel_id.channel_code);
            header.setNetworkCode(channel_id.network_id.network_code);
            TimeInterval sampPeriod = sampling_info.getPeriod();
            header.setStartBtime(FissuresConvert.getBtime(start));
            header.setNumSamples((short)eData[i].num_points);
            start = start.add((TimeInterval)sampPeriod.multiplyBy((double)eData[i].num_points));
            double sps = 1.0 / sampPeriod.convertTo(UnitImpl.SECOND).getValue();
            int divisor = (int)Math.ceil(-32766.0 / sps);
            if (divisor < -32766) {
                divisor = -32766;
            }
            int factor = (int)Math.round(-1.0 * sps * (double)divisor);
            header.setSampleRateFactor((short)factor);
            header.setSampleRateMultiplier((short)divisor);
            b1000.setEncodingFormat((byte)eData[i].compression);
            if (eData[i].byte_order) {
                b1000.setWordOrder((byte)0);
            } else {
                b1000.setWordOrder((byte)1);
            }
            b1000.setDataRecordLength((byte)12);
            DataRecord dr = new DataRecord(header);
            dr.addBlockette((Blockette)b1000);
            QuantityImpl hertz = sampling_info.getFrequency().convertTo(UnitImpl.HERTZ);
            if (b100 != null) {
                b100.setActualSampleRate((float)hertz.getValue());
                dr.addBlockette((Blockette)b100);
            }
            dr.setData(eData[i].values);
            list.add(dr);
        }
        return list;
    }

    public static LocalSeismogramImpl toFissures(DataRecord[] seed) throws SeedFormatException, FissuresException {
        LocalSeismogramImpl seis = FissuresConvert.toFissures(seed[0]);
        for (int i = 1; i < seed.length; ++i) {
            FissuresConvert.append(seis, seed[i]);
        }
        return seis;
    }

    public static LocalSeismogramImpl append(LocalSeismogramImpl seis, DataRecord[] seed) throws SeedFormatException, FissuresException {
        for (int i = 0; i < seed.length; ++i) {
            FissuresConvert.append(seis, seed[i]);
        }
        return seis;
    }

    public static LocalSeismogramImpl append(LocalSeismogramImpl seis, DataRecord seed) throws SeedFormatException, FissuresException {
        TimeSeriesDataSel bits = FissuresConvert.convertData(seed);
        EncodedData[] edata = bits.encoded_values();
        for (int j = 0; j < edata.length; ++j) {
            if (edata[j] == null) {
                System.err.println("encoded data is null " + j);
                System.exit(1);
            }
            seis.append_encoded(edata[j]);
        }
        return seis;
    }

    public static LocalSeismogramImpl toFissures(DataRecord seed) throws SeedFormatException {
        TimeInterval timeInterval;
        int numPerSampling;
        DataHeader header = seed.getHeader();
        String isoTime = FissuresConvert.getISOTime(header.getStartBtime());
        ChannelId channelId = new ChannelId(new NetworkId(header.getNetworkCode().trim(), new Time(isoTime, -1)), header.getStationIdentifier().trim(), header.getLocationIdentifier().trim(), header.getChannelIdentifier().trim(), new Time(isoTime, -1));
        String seisId = channelId.network_id.network_code + ":" + channelId.station_code + ":" + channelId.site_code + ":" + channelId.channel_code + ":" + FissuresConvert.getISOTime(header.getStartBtime());
        Property[] props = new Property[]{new Property("Name", seisId)};
        Blockette[] blocketts = seed.getBlockettes(100);
        if (blocketts.length != 0) {
            Blockette100 b100 = (Blockette100)blocketts[0];
            float f = b100.getActualSampleRate();
            numPerSampling = 1;
            timeInterval = new TimeInterval((double)(1.0f / f), UnitImpl.SECOND);
        } else if (header.getSampleRateFactor() > 0) {
            numPerSampling = header.getSampleRateFactor();
            timeInterval = new TimeInterval(1.0, UnitImpl.SECOND);
            if (header.getSampleRateMultiplier() > 0) {
                numPerSampling *= header.getSampleRateMultiplier();
            } else {
                timeInterval = (TimeInterval)timeInterval.multiplyBy((double)(-1 * header.getSampleRateMultiplier()));
            }
        } else {
            numPerSampling = 1;
            timeInterval = new TimeInterval((double)(-1 * header.getSampleRateFactor()), UnitImpl.SECOND);
            if (header.getSampleRateMultiplier() > 0) {
                numPerSampling *= header.getSampleRateMultiplier();
            } else {
                timeInterval = (TimeInterval)timeInterval.multiplyBy((double)(-1 * header.getSampleRateMultiplier()));
            }
        }
        SamplingImpl sampling = new SamplingImpl(numPerSampling, timeInterval);
        TimeSeriesDataSel bits = FissuresConvert.convertData(seed);
        return new LocalSeismogramImpl(seisId, props, new Time(isoTime, -1), header.getNumSamples(), (Sampling)sampling, (Unit)UnitImpl.COUNT, channelId, new ParameterRef[0], (Quantity[])new QuantityImpl[0], (Sampling[])new SamplingImpl[0], bits);
    }

    public static TimeSeriesDataSel convertData(DataRecord seed) throws SeedFormatException {
        Blockette[] allBs = seed.getBlockettes(1000);
        if (allBs.length == 0) {
            throw new SeedFormatException("No blockette 1000s in the volume.");
        }
        if (allBs.length > 1) {
            throw new SeedFormatException("Multiple blockette 1000s in the volume. " + allBs.length);
        }
        Blockette1000 b1000 = (Blockette1000)allBs[0];
        EncodedData eData = new EncodedData((short)b1000.getEncodingFormat(), seed.getData(), seed.getHeader().getNumSamples(), !b1000.isBigEndian());
        EncodedData[] eArray = new EncodedData[]{eData};
        TimeSeriesDataSel bits = new TimeSeriesDataSel();
        bits.encoded_values(eArray);
        return bits;
    }

    public static SeismogramAttrImpl convertAttributes(DataRecord seed) throws SeedFormatException {
        return FissuresConvert.toFissures(seed);
    }

    public static String getISOTime(Btime startStruct) {
        float fSecond = (float)startStruct.sec + (float)startStruct.tenthMilli / 10000.0f;
        return ISOTime.getISOString((int)startStruct.year, (int)startStruct.jday, (int)startStruct.hour, (int)startStruct.min, (float)fSecond);
    }

    public MicroSecondDate getMicroSecondTime(Btime startStruct) {
        ISOTime iso = new ISOTime(startStruct.year, startStruct.jday, startStruct.hour, startStruct.min, (float)startStruct.sec);
        MicroSecondDate d = iso.getDate().add(new TimeInterval((double)startStruct.tenthMilli, UnitImpl.TENTHMILLISECOND));
        return d;
    }

    public static Btime getBtime(MicroSecondDate date) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime((Date)date);
        Btime btime = new Btime();
        btime.tenthMilli = (int)((long)(cal.get(14) * 10) + Math.round((double)date.getMicroSeconds() / 100.0));
        btime.year = cal.get(1);
        btime.jday = cal.get(6);
        btime.hour = cal.get(11);
        btime.min = cal.get(12);
        btime.sec = cal.get(13);
        return btime;
    }
}

