/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.mockFissures.IfNetwork;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.mockFissures.IfNetwork.MockChannelId;
import edu.sc.seis.fissuresUtil.mockFissures.IfNetwork.MockSite;
import edu.sc.seis.fissuresUtil.mockFissures.IfNetwork.MockStation;

public class MockChannel {
    private static final Orientation VERTICAL = new Orientation(0.0f, 90.0f);
    private static final Orientation EAST = new Orientation(90.0f, 0.0f);
    private static final Orientation NORTH = new Orientation(0.0f, 0.0f);
    private static final Orientation[] ORIENTATIONS = new Orientation[]{VERTICAL, NORTH, EAST};

    public static Channel createChannel() {
        return MockChannel.createChannel(MockChannelId.createVerticalChanId(), "Vertical Channel", MockSite.createSite(), VERTICAL);
    }

    public static Channel createNorthChannel() {
        return MockChannel.createChannel(MockChannelId.createNorthChanId(), "North Channel", MockSite.createSite(), NORTH);
    }

    public static Channel createEastChannel() {
        return MockChannel.createChannel(MockChannelId.createEastChanId(), "East Channel", MockSite.createSite(), EAST);
    }

    public static Channel createOtherSiteSameStationChan() {
        return MockChannel.createChannel(MockChannelId.createOtherSiteSameStationChanId(), "Other Site Same Station Vertical Channel", MockSite.createOtherSiteSameStation(), VERTICAL);
    }

    public static Channel createOtherNetChan() {
        return MockChannel.createChannel(MockChannelId.createOtherNetChanId(), "Other Net Vertical Channel", MockSite.createOtherSite(), VERTICAL);
    }

    public static Channel[] createChannelsAtLocs(Location[] locs) {
        Channel[] chans = new Channel[locs.length];
        for (int i = 0; i < chans.length; ++i) {
            chans[i] = MockChannel.createChannel(locs[i]);
        }
        return chans;
    }

    private static Channel createChannel(Location location) {
        Site s = MockSite.createSite(location);
        return MockChannel.createChannel(MockChannelId.createChanId("BHZ", s), location.toString(), s, VERTICAL);
    }

    private static Channel createChannel(ChannelId id, String info, Site s, Orientation o) {
        return new ChannelImpl(id, info, o, (Sampling)new SamplingImpl(20, new TimeInterval(1.0, UnitImpl.SECOND)), s.effective_time, s);
    }

    public static Channel[] createMotionVector() {
        return MockChannel.createMotionVector(MockStation.createStation());
    }

    public static Channel[] createMotionVector(Station station) {
        Channel[] channels = new Channel[3];
        Site s = MockSite.createSite(station);
        String[] codes = new String[]{"BHZ", "BHN", "BHE"};
        for (int i = 0; i < codes.length; ++i) {
            channels[i] = MockChannel.createChannel(MockChannelId.createChanId(codes[i], s), "Motion Vector Channel " + codes[i], s, ORIENTATIONS[i]);
        }
        return channels;
    }
}

