/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.freq;

import edu.sc.seis.fissuresUtil.freq.Cmplx;
import edu.sc.seis.fissuresUtil.freq.FilterException;
import edu.sc.seis.fissuresUtil.freq.FrequencyDomainProcess;
import edu.sc.seis.fissuresUtil.freq.SeisGramText;

public class ButterworthFilter
implements FrequencyDomainProcess {
    private SeisGramText localeText;
    public double highFreqCorner;
    public double lowFreqCorner;
    public int numPoles;
    public int filterType;
    public String errorMessage;
    private static final double FREQ_MIN = 1.0E-5;
    private static final double FREQ_MAX = 100000.0;
    private static final double NUM_POLES_MIN = 2.0;
    private static final double NUM_POLES_MAX = 20.0;
    private static final double PI = Math.PI;
    private static final double TWOPI = Math.PI * 2;
    public static final int CAUSAL = 0;
    public static final int NONCAUSAL = 1;
    public static final int TWOPASS = 1;

    public ButterworthFilter(SeisGramText localeText, double lowFreqCorner, double highFreqCorner, int numPoles) {
        this(localeText, lowFreqCorner, highFreqCorner, numPoles, 0);
    }

    public ButterworthFilter(SeisGramText localeText, double lowFreqCorner, double highFreqCorner, int numPoles, int filterType) {
        this.localeText = localeText;
        this.highFreqCorner = highFreqCorner;
        this.lowFreqCorner = lowFreqCorner;
        this.numPoles = numPoles;
        this.filterType = filterType;
        this.errorMessage = " ";
    }

    public void setHighFreqCorner(double freqValue) throws FilterException {
        if (freqValue < 1.0E-5 || freqValue > 100000.0) {
            throw new FilterException(this.localeText.invalid_high_frequency_corner);
        }
        this.highFreqCorner = freqValue;
    }

    public void setHighFreqCorner(String str) throws FilterException {
        double freqValue;
        try {
            freqValue = Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new FilterException(this.localeText.invalid_high_frequency_corner);
        }
        this.setHighFreqCorner(freqValue);
    }

    public void setLowFreqCorner(double freqValue) throws FilterException {
        if (freqValue < 1.0E-5 || freqValue > 100000.0) {
            throw new FilterException(this.localeText.invalid_low_frequency_corner);
        }
        this.lowFreqCorner = freqValue;
    }

    public void setLowFreqCorner(String str) throws FilterException {
        double freqValue;
        try {
            freqValue = Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new FilterException(this.localeText.invalid_low_frequency_corner);
        }
        this.setLowFreqCorner(freqValue);
    }

    public void setNumPoles(int nPoles) throws FilterException {
        if ((double)nPoles < 2.0 || (double)nPoles > 20.0 || nPoles % 2 != 0) {
            throw new FilterException(this.localeText.invalid_number_of_poles);
        }
        this.numPoles = nPoles;
    }

    public void setNumPoles(String str) throws FilterException {
        int nPoles;
        try {
            nPoles = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new FilterException(this.localeText.invalid_number_of_poles);
        }
        this.setNumPoles(nPoles);
    }

    void checkSettings() throws FilterException {
        String errMessage = "";
        int badSettings = 0;
        if (this.highFreqCorner < 1.0E-5 || this.highFreqCorner > 100000.0) {
            errMessage = errMessage + ": " + this.localeText.invalid_high_frequency_corner;
            ++badSettings;
        }
        if (this.lowFreqCorner < 1.0E-5 || this.lowFreqCorner > 100000.0) {
            errMessage = errMessage + ": " + this.localeText.invalid_low_frequency_corner;
            ++badSettings;
        }
        if (this.lowFreqCorner >= this.highFreqCorner) {
            errMessage = errMessage + ": " + this.localeText.low_corner_greater_than_high_corner;
            ++badSettings;
        }
        if ((double)this.numPoles < 2.0 || (double)this.numPoles > 20.0 || this.numPoles % 2 != 0) {
            errMessage = errMessage + ": " + this.localeText.invalid_number_of_poles;
            ++badSettings;
        }
        if (badSettings > 0) {
            throw new FilterException(errMessage + ".");
        }
    }

    public Cmplx[] apply(double dt, Cmplx[] cx) {
        double ai;
        double ar;
        double ak;
        int i;
        int npts = cx.length;
        double fl = this.lowFreqCorner;
        double fh = this.highFreqCorner;
        int npole = this.numPoles;
        Cmplx c0 = new Cmplx(0.0, 0.0);
        Cmplx c1 = new Cmplx(1.0, 0.0);
        Cmplx[] sph = new Cmplx[this.numPoles];
        Cmplx[] spl = new Cmplx[this.numPoles];
        if (npole % 2 != 0) {
            System.out.println("WARNING - Number of poles not a multiple of 2!");
        }
        int nop = npole - 2 * (npole / 2);
        int nepp = npole / 2;
        double wch = Math.PI * 2 * fh;
        double wcl = Math.PI * 2 * fl;
        int np = -1;
        if (nop > 0) {
            sph[++np] = new Cmplx(1.0, 0.0);
        }
        if (nepp > 0) {
            for (i = 0; i < nepp; ++i) {
                ak = 2.0 * Math.sin((2.0 * (double)i + 1.0) * Math.PI / (2.0 * (double)npole));
                ar = ak * wch / 2.0;
                ai = wch * Math.sqrt(4.0 - ak * ak) / 2.0;
                sph[++np] = new Cmplx(-ar, -ai);
                sph[++np] = new Cmplx(-ar, ai);
            }
        }
        np = -1;
        if (nop > 0) {
            spl[++np] = new Cmplx(1.0, 0.0);
        }
        if (nepp > 0) {
            for (i = 0; i < nepp; ++i) {
                ak = 2.0 * Math.sin((2.0 * (double)i + 1.0) * Math.PI / (2.0 * (double)npole));
                ar = ak * wcl / 2.0;
                ai = wcl * Math.sqrt(4.0 - ak * ak) / 2.0;
                spl[++np] = new Cmplx(-ar, -ai);
                spl[++np] = new Cmplx(-ar, ai);
            }
        }
        cx[0] = c0;
        double dw = Math.PI * 2 / ((double)npts * dt);
        double w = 0.0;
        for (i = 1; i < npts / 2 + 1; ++i) {
            Cmplx cjw = new Cmplx(0.0, -(w += dw));
            Cmplx cph = c1;
            Cmplx cpl = c1;
            for (int j = 0; j < npole; ++j) {
                cph = Cmplx.div(Cmplx.mul(cph, sph[j]), Cmplx.add(sph[j], cjw));
                cpl = Cmplx.div(Cmplx.mul(cpl, cjw), Cmplx.add(spl[j], cjw));
            }
            cx[i] = Cmplx.mul(cx[i], Cmplx.mul(cph, cpl).conjg());
            if (this.filterType == 1) {
                cx[i] = Cmplx.mul(cx[i], Cmplx.mul(cph, cpl));
            }
            cx[npts - i] = cx[i].conjg();
        }
        return cx;
    }
}

