/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.registrar;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeListener;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class RTTimeRangeConfig
implements TimeConfig,
TimeListener {
    private List listeners = Collections.synchronizedList(new ArrayList());
    private TimeConfig internalTimeConfig;
    private TimeInterval update;
    public static final TimeInterval serverTimeOffset = ClockUtil.getTimeOffset();
    private MicroSecondDate lastDate;
    private TimeEvent time;
    private float speed = 1.0f;
    protected Timer timer;
    protected TimeInterval width;
    private static Logger logger = Logger.getLogger((Class)RTTimeRangeConfig.class);
    public static TimeInterval DEFAULT_REFRESH = new TimeInterval(0.125, UnitImpl.SECOND);
    private static TimeInterval THREE_MINUTES = new TimeInterval(3.0, UnitImpl.MINUTE);

    public RTTimeRangeConfig(TimeConfig internalConfig) {
        this(internalConfig, DEFAULT_REFRESH);
    }

    public RTTimeRangeConfig(TimeConfig internalConfig, TimeInterval update) {
        this(internalConfig, update, 1.0f);
    }

    public RTTimeRangeConfig(TimeConfig internalConfig, TimeInterval update, float speed) {
        this.update = update;
        this.speed = speed;
        this.setInternalConfig(internalConfig);
    }

    public void setInternalConfig(TimeConfig config) {
        if (this.internalTimeConfig != null) {
            this.internalTimeConfig.removeListener(this);
            this.add(config.getSeismograms());
        }
        this.internalTimeConfig = config;
        this.time = config.fireTimeEvent();
        config.addListener(this);
    }

    public TimeConfig getInternalConfig() {
        return this.internalTimeConfig;
    }

    public void add(DataSetSeismogram[] seismos) {
        this.internalTimeConfig.add(seismos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTime(TimeEvent event) {
        this.time = event;
        List list = this.listeners;
        synchronized (list) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ((TimeListener)it.next()).updateTime(event);
            }
        }
    }

    public void startTimer() {
        if (this.timer == null) {
            this.timer = new Timer((int)this.update.convertTo((UnitImpl)UnitImpl.MILLISECOND).value, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (RTTimeRangeConfig.this.speed != 0.0f && RTTimeRangeConfig.this.lastDate != null) {
                        MicroSecondDate now = ClockUtil.now();
                        TimeInterval timeInterval = new TimeInterval(RTTimeRangeConfig.this.lastDate, now);
                        RTTimeRangeConfig.this.lastDate = now;
                        RTTimeRangeConfig.this.shaleTime(timeInterval.divideBy((QuantityImpl)RTTimeRangeConfig.this.time.getTime().getInterval()).getValue() * (double)RTTimeRangeConfig.this.speed, 1.0);
                    } else {
                        RTTimeRangeConfig.this.lastDate = ClockUtil.now();
                    }
                }
            });
            this.timer.setCoalesce(true);
            this.timer.start();
        }
    }

    public void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public void reset() {
        this.speed = 1.0f;
        this.stopTimer();
        this.internalTimeConfig.reset();
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getSpeed() {
        return this.speed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TimeListener listener) {
        List list = this.listeners;
        synchronized (list) {
            if (listener != null) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(TimeListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public void shaleTime(double shift, double scale, DataSetSeismogram[] seismos) {
        this.internalTimeConfig.shaleTime(shift, scale, seismos);
    }

    public void shaleTime(double shift, double scale) {
        this.internalTimeConfig.shaleTime(shift, scale);
    }

    public void remove(DataSetSeismogram[] seismos) {
        this.internalTimeConfig.remove(seismos);
    }

    public double getShift() {
        return this.internalTimeConfig.getShift();
    }

    public double getScale() {
        return this.internalTimeConfig.getScale();
    }

    public void reset(DataSetSeismogram[] seismos) {
        this.internalTimeConfig.reset(seismos);
    }

    public boolean contains(DataSetSeismogram seismo) {
        return this.internalTimeConfig.contains(seismo);
    }

    public TimeEvent fireTimeEvent() {
        return this.internalTimeConfig.fireTimeEvent();
    }

    public MicroSecondTimeRange getTime() {
        return this.internalTimeConfig.getTime();
    }

    public MicroSecondTimeRange getTime(DataSetSeismogram seis) {
        return this.internalTimeConfig.getTime();
    }

    public DataSetSeismogram[] getSeismograms() {
        return this.internalTimeConfig.getSeismograms();
    }

    public void clear() {
        this.internalTimeConfig.removeListener(this);
        this.internalTimeConfig.clear();
        this.internalTimeConfig.addListener(this);
    }
}

