/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.registrar;

import edu.sc.seis.fissuresUtil.display.RecordSectionDisplay;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LayoutScaler
extends JSlider
implements ChangeListener {
    private RecordSectionDisplay recSec;
    public static final int MIN_SCALE = 10;
    public static final int INITIAL_SCALE = 45;

    public LayoutScaler(RecordSectionDisplay recSec) {
        super(1);
        this.setMinPoint(10, 45);
        this.setValue(45);
        this.setPaintLabels(true);
        this.setPaintTicks(true);
        this.recSec = recSec;
        this.addChangeListener(this);
        recSec.setLayoutScaler(this);
    }

    public void stateChanged(ChangeEvent ce) {
        this.recSec.scalingChanged(this.getValue());
    }

    public void increaseScale(double factor) {
        int curMin = this.getMinimum();
        int newMin = (int)Math.ceil((double)curMin * factor);
        this.setMinPoint(newMin, (int)((double)this.getValue() * ((double)curMin / (double)newMin)));
    }

    private void setMinPoint(int minpoint, int curValue) {
        this.setMinimum(minpoint);
        int maxpoint = minpoint + minpoint * 10;
        this.setMaximum(maxpoint);
        this.setValue(curValue);
        this.setMajorTickSpacing((maxpoint - minpoint) / 10);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(minpoint), new JLabel("Min"));
        labelTable.put(new Integer(maxpoint), new JLabel("Max"));
        this.setLabelTable(labelTable);
    }
}

