/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.configuration;

import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.display.configuration.ConfigDefinitions;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.display.registrar.BasicTimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.OriginAlignedTimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.PhaseAlignedTimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.RTTimeRangeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.RelativeTimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import org.w3c.dom.Element;

public class TimeConfigConfiguration
implements Cloneable {
    private String type;
    private String phaseName;
    private TimeConfigConfiguration realTimeInternalTimeConfig;
    private TimeInterval advanceInterval = RTTimeRangeConfig.DEFAULT_REFRESH;
    float advPerSec = 1.0f;
    private static ConfigDefinitions defs = new ConfigDefinitions();

    public void configure(Element element) throws NoSuchFieldException {
        this.type = DOMHelper.extractText(element, "type", this.type);
        if (this.type.equals("autoAdvance")) {
            this.configureRealTimeConfig(element);
        } else if (this.type.equals("phaseAligned")) {
            this.phaseName = DOMHelper.extractText(element, "phaseName");
        }
    }

    private void configureRealTimeConfig(Element element) throws NoSuchFieldException {
        if (DOMHelper.hasElement(element, "timeConfig")) {
            Element el = DOMHelper.getElement(element, "timeConfig");
            this.realTimeInternalTimeConfig = TimeConfigConfiguration.create(el);
        }
        if (DOMHelper.hasElement(element, "advanceInterval")) {
            Element intervalEl = DOMHelper.getElement(element, "advanceInterval");
            this.advanceInterval = TimeConfigConfiguration.getAdvanceInterval(intervalEl);
        }
        if (DOMHelper.hasElement(element, "advancesPerSecond")) {
            this.advPerSec = new Float(DOMHelper.extractText(element, "advancesPerSecond")).floatValue();
        }
    }

    public static TimeInterval getAdvanceInterval(Element el) throws NoSuchFieldException {
        double value = new Double(DOMHelper.extractText(el, "value"));
        String unit = DOMHelper.extractText(el, "unit");
        UnitImpl units = UnitImpl.getUnitFromString((String)unit);
        return new TimeInterval(value, units);
    }

    public static TimeConfigConfiguration create(Element el) throws NoSuchFieldException {
        TimeConfigConfiguration c = null;
        if (defs.referencesDefinition(el)) {
            TimeConfigConfiguration base = (TimeConfigConfiguration)defs.getDefinition(el);
            c = (TimeConfigConfiguration)base.clone();
        } else {
            c = new TimeConfigConfiguration();
        }
        c.configure(el);
        defs.updateDefinitions(el, c);
        return c;
    }

    public TimeConfig createTimeConfig() {
        TimeConfig tc = null;
        if (this.type.equals("basic")) {
            tc = new BasicTimeConfig();
        } else if (this.type.equals("relative")) {
            tc = new RelativeTimeConfig();
        } else if (this.type.equals("originAligned")) {
            tc = new OriginAlignedTimeConfig();
        } else if (this.type.equals("phaseAligned")) {
            tc = new PhaseAlignedTimeConfig(this.phaseName);
        } else if (this.type.equals("autoAdvance")) {
            tc = new RTTimeRangeConfig(this.realTimeInternalTimeConfig.createTimeConfig(), this.advanceInterval, this.advPerSec);
        }
        return tc;
    }

    public Object clone() {
        TimeConfigConfiguration clone = new TimeConfigConfiguration();
        clone.type = this.type;
        clone.phaseName = this.phaseName;
        clone.realTimeInternalTimeConfig = this.realTimeInternalTimeConfig;
        clone.advanceInterval = this.advanceInterval;
        clone.advPerSec = this.advPerSec;
        return clone;
    }
}

