/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.configuration;

import edu.sc.seis.fissuresUtil.display.configuration.ConfigDefinitions;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.awt.Font;
import org.w3c.dom.Element;

public class FontConfiguration
implements Cloneable {
    private String size = "12";
    private String name = "Serif";
    private String styleString = "plain";
    private static ConfigDefinitions defs = new ConfigDefinitions();

    private FontConfiguration() {
    }

    public void configure(Element el) {
        this.size = DOMHelper.extractText(el, "size", this.size);
        this.name = DOMHelper.extractText(el, "name", this.name);
        this.styleString = DOMHelper.extractText(el, "style", this.styleString);
    }

    public static FontConfiguration create(Element el) {
        FontConfiguration c = null;
        if (defs.referencesDefinition(el)) {
            try {
                FontConfiguration base = (FontConfiguration)defs.getDefinition(el);
                c = (FontConfiguration)base.clone();
            }
            catch (CloneNotSupportedException e) {
                GlobalExceptionHandler.handle("But I added clone to this object....");
            }
        } else {
            c = new FontConfiguration();
        }
        c.configure(el);
        defs.updateDefinitions(el, c);
        return c;
    }

    public Font createFont() {
        int style;
        if (this.styleString.equals("plain")) {
            style = 0;
        } else if (this.styleString.equals("bold")) {
            style = 1;
        } else if (this.styleString.equals("italic")) {
            style = 2;
        } else {
            throw new IllegalArgumentException("The value of style must be plain, bold or italic.  You specified " + this.styleString + ".");
        }
        return new Font(this.name, style, Integer.parseInt(this.size));
    }

    public String toString() {
        return "FontConfiguration of size " + this.size + " font " + this.name + " with style " + this.styleString;
    }
}

