/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.borders;

import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.borders.Border;
import edu.sc.seis.fissuresUtil.display.borders.TitleProvider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractUnitRangeBorder
extends Border
implements TitleProvider {
    private Color c = null;
    private Font titleFont = DisplayUtils.DEFAULT_FONT;

    public AbstractUnitRangeBorder(int side, int order) {
        super(side, order);
        this.add(this);
        this.setPreferredSize(new Dimension(80, 50));
    }

    protected List createFormats() {
        ArrayList<UnitRangeFormatter> formats = new ArrayList<UnitRangeFormatter>();
        for (double i = 1.0E-9; i <= 1.0E8; i *= 10.0) {
            formats.add(new UnitRangeFormatter(i, 2));
            formats.add(new UnitRangeFormatter(i * 2.0, 2));
            formats.add(new UnitRangeFormatter(i * 3.0, 3));
            formats.add(new UnitRangeFormatter(i * 5.0, 5));
        }
        return formats;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font f) {
        this.titleFont = f;
    }

    public String getMaxLengthFormattedString() {
        return "0.000E00";
    }

    public Color getTitleColor() {
        return this.c;
    }

    public void setTitleColor(Color newColor) {
        this.c = newColor;
    }

    private class UnitRangeFormatter
    extends Border.BorderFormat {
        private DecimalFormat df;

        public UnitRangeFormatter(double division, int ticksPerDivision) {
            super(AbstractUnitRangeBorder.this, division, ticksPerDivision);
            this.df = division < 0.01 ? new DecimalFormat("#.###E00") : (division < 10.0 && division != 0.0 ? new DecimalFormat("0.00###") : (division < 100000.0 ? new DecimalFormat("#.####") : new DecimalFormat("#.###E00")));
        }

        public String getMaxString() {
            return this.df.format(this.divSize * 10.0);
        }

        public String getLabel(double value) {
            return this.df.format(value);
        }

        public String toString() {
            return "UnitRange " + this.getDivSize() + " " + this.ticksPerDiv;
        }
    }
}

