/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfParameterMgr.ParameterRef;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.Property;
import edu.iris.Fissures.IfTimeSeries.TimeSeriesDataSel;
import edu.iris.Fissures.Plottable;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.model.UnitRangeImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.dmc.seedcodec.CodecException;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.display.IntRange;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import java.awt.Dimension;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.Category;

public class SimplePlotUtil {
    public static final TimeInterval ONE_DAY = new TimeInterval(1.0, UnitImpl.DAY);
    public static final int SPIKE_SAMPLES_PER_SECOND = 20;
    static Category logger = Category.getInstance((String)SimplePlotUtil.class.getName());

    public static Plottable makePlottable(LocalSeismogramImpl seis, MicroSecondTimeRange tr, int pixelsPerDay) throws CodecException {
        logger.debug((Object)("making plottable from seismogram spanning from " + seis.getBeginTime() + " to " + seis.getEndTime() + " within time range " + tr + " at resolution " + pixelsPerDay));
        if (tr.getEndTime().before((Date)seis.getBeginTime()) || tr.getBeginTime().after((Date)seis.getEndTime()) || !SimplePlotUtil.canMakeAtLeastOnePixel((LocalSeismogram)seis, pixelsPerDay)) {
            return SimplePlotUtil.getEmptyPlottable();
        }
        MicroSecondTimeRange correctedSeisRange = SimplePlotUtil.correctTimeRangeForPixelData((LocalSeismogram)seis, pixelsPerDay);
        int startPoint = SimplePlotUtil.getPoint(seis, correctedSeisRange.getBeginTime());
        int endPoint = SimplePlotUtil.getPoint(seis, correctedSeisRange.getEndTime());
        IntRange seisPixelRange = SimplePlotUtil.getDayPixelRange((LocalSeismogram)seis, pixelsPerDay, tr.getBeginTime());
        int numPixels = seisPixelRange.getDifference();
        MicroSecondDate rangeEnd = correctedSeisRange.getBeginTime().add(new TimeInterval((Quantity)SimplePlotUtil.getPixelPeriod(pixelsPerDay).multiplyBy((double)numPixels)));
        boolean corrected = false;
        if (rangeEnd.after((Date)correctedSeisRange.getEndTime())) {
            --numPixels;
            corrected = true;
        }
        int startPixel = seisPixelRange.getMin();
        int[][] pixels = new int[2][numPixels * 2];
        int pixelPoint = startPixel < 0 ? 0 : startPoint;
        MicroSecondDate pixelEndTime = correctedSeisRange.getBeginTime();
        TimeInterval pixelPeriod = SimplePlotUtil.getPixelPeriod(pixelsPerDay);
        if (corrected) {
            logger.warn((Object)"corrected for freak extra pixel!");
            logger.debug((Object)("end of range would have been " + rangeEnd + " without correction"));
            logger.debug((Object)("correctedSeisRange: " + correctedSeisRange));
            logger.debug((Object)("end of range would have been " + rangeEnd + " without correction"));
            logger.debug((Object)("seis.num_points: " + seis.num_points));
            logger.debug((Object)("startPoint: " + startPoint));
            logger.debug((Object)("endPoint: " + endPoint));
            logger.debug((Object)("seisPixelRange: " + seisPixelRange));
            logger.debug((Object)("numPixels after correction: " + numPixels));
            logger.debug((Object)("startPixel: " + startPixel));
            logger.debug((Object)("pixelPeriod: " + pixelPeriod));
        }
        for (int i = 0; i < numPixels; ++i) {
            pixelEndTime = pixelEndTime.add(pixelPeriod);
            int pos = 2 * i;
            int nextPos = pos + 1;
            pixels[0][pos] = startPixel + i;
            pixels[0][nextPos] = pixels[0][pos];
            int nextPixelPoint = SimplePlotUtil.getPixel(startPoint, endPoint, correctedSeisRange.getBeginTime(), correctedSeisRange.getEndTime(), pixelEndTime);
            QuantityImpl min = seis.getMinValue(pixelPoint, nextPixelPoint);
            pixels[1][pos] = (int)min.getValue();
            QuantityImpl max = seis.getMaxValue(pixelPoint, nextPixelPoint);
            pixels[1][nextPos] = (int)max.getValue();
            if (corrected && (i < 2 || i >= numPixels - 2)) {
                logger.debug((Object)(pixels[0][pos] + ": min " + min.value + " max " + max.value));
            }
            pixelPoint = nextPixelPoint;
        }
        return new Plottable(pixels[0], pixels[1]);
    }

    public static Plottable getEmptyPlottable() {
        int[] empty = new int[]{};
        return new Plottable(empty, empty);
    }

    public static TimeInterval getPixelPeriod(int pixelsPerDay) {
        double pixelPeriod = 1.0 / (double)pixelsPerDay;
        return new TimeInterval(pixelPeriod, UnitImpl.DAY);
    }

    public static MicroSecondDate getBeginningOfDay(MicroSecondDate date) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime((Date)date);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        cal.set(14, 0);
        return new MicroSecondDate(cal.getTime());
    }

    public static MicroSecondTimeRange getDay(MicroSecondDate date) {
        return new MicroSecondTimeRange(SimplePlotUtil.getBeginningOfDay(date), ONE_DAY);
    }

    public static MicroSecondDate getPixelBeginTime(MicroSecondTimeRange day, int pixel, int pixelsPerDay) {
        TimeInterval pixelPeriod = SimplePlotUtil.getPixelPeriod(pixelsPerDay);
        return day.getBeginTime().add(new TimeInterval((Quantity)pixelPeriod.multiplyBy((double)pixel)));
    }

    public static MicroSecondTimeRange getPixelTimeRange(MicroSecondDate point, int pixelsPerDay, boolean after) {
        TimeInterval pixelPeriod = SimplePlotUtil.getPixelPeriod(pixelsPerDay);
        MicroSecondTimeRange day = SimplePlotUtil.getDay(point);
        int pixel = SimplePlotUtil.getPixel(pixelsPerDay, day, point);
        if (after) {
            ++pixel;
        }
        MicroSecondDate pixelBegin = SimplePlotUtil.getPixelBeginTime(day, pixel, pixelsPerDay);
        return new MicroSecondTimeRange(pixelBegin, pixelPeriod);
    }

    public static IntRange getDayPixelRange(LocalSeismogram seis, int pixelsPerDay) {
        return SimplePlotUtil.getDayPixelRange(seis, pixelsPerDay, SimplePlotUtil.getBeginningOfDay(new MicroSecondDate(seis.begin_time)));
    }

    public static IntRange getDayPixelRange(LocalSeismogram seis, int pixelsPerDay, MicroSecondDate startOfDay) {
        int endPixel;
        MicroSecondTimeRange seisTR = new MicroSecondTimeRange((LocalSeismogramImpl)seis);
        MicroSecondTimeRange dayTR = new MicroSecondTimeRange(startOfDay, ONE_DAY);
        int startPixel = SimplePlotUtil.getPixel(pixelsPerDay, dayTR, seisTR.getBeginTime());
        if (SimplePlotUtil.getPixelTimeRange(seisTR.getBeginTime(), pixelsPerDay, false).getBeginTime().before((Date)seisTR.getBeginTime())) {
            ++startPixel;
        }
        if ((endPixel = SimplePlotUtil.getPixel(pixelsPerDay, dayTR, seisTR.getEndTime())) < startPixel) {
            endPixel = startPixel;
        }
        return new IntRange(startPixel, endPixel);
    }

    public static boolean canMakeAtLeastOnePixel(LocalSeismogram seis, int pixelsPerDay) {
        IntRange pixelRange = SimplePlotUtil.getDayPixelRange(seis, pixelsPerDay);
        return pixelRange.getMax() > pixelRange.getMin();
    }

    public static MicroSecondTimeRange correctTimeRangeForPixelData(LocalSeismogram seis, int pixelsPerDay) {
        IntRange pixelRange = SimplePlotUtil.getDayPixelRange(seis, pixelsPerDay);
        MicroSecondTimeRange day = SimplePlotUtil.getDay(new MicroSecondDate(seis.begin_time));
        MicroSecondDate start = SimplePlotUtil.getPixelBeginTime(day, pixelRange.getMin(), pixelsPerDay);
        MicroSecondDate end = SimplePlotUtil.getPixelBeginTime(day, pixelRange.getMax(), pixelsPerDay);
        return new MicroSecondTimeRange(start, end);
    }

    public static int[][] compressXvalues(LocalSeismogram seismogram, MicroSecondTimeRange timeRange, Dimension size) throws CodecException {
        LocalSeismogramImpl seis = (LocalSeismogramImpl)seismogram;
        int width = size.width;
        int[][] out = new int[2][];
        if (seis.getEndTime().before((Date)timeRange.getBeginTime()) || seis.getBeginTime().after((Date)timeRange.getEndTime())) {
            out[0] = new int[0];
            out[1] = new int[0];
            logger.info((Object)"The end time is before the beginTime in simple seismogram");
            return out;
        }
        MicroSecondDate tMin = timeRange.getBeginTime();
        MicroSecondDate tMax = timeRange.getEndTime();
        int seisStartIndex = SimplePlotUtil.getPoint(seis, tMin);
        int seisEndIndex = SimplePlotUtil.getPoint(seis, tMax);
        if (seisStartIndex < 0) {
            seisStartIndex = 0;
        }
        if (seisEndIndex >= seis.getNumPoints()) {
            seisEndIndex = seis.getNumPoints() - 1;
        }
        MicroSecondDate tempdate = SimplePlotUtil.getValue(seis.getNumPoints(), seis.getBeginTime(), seis.getEndTime(), seisStartIndex);
        int pixelStartIndex = SimplePlotUtil.getPixel(width, timeRange, tempdate);
        tempdate = SimplePlotUtil.getValue(seis.getNumPoints(), seis.getBeginTime(), seis.getEndTime(), seisEndIndex);
        int pixelEndIndex = SimplePlotUtil.getPixel(width, timeRange, tempdate);
        int pixels = seisEndIndex - seisStartIndex + 1;
        out[0] = new int[2 * pixels];
        out[1] = new int[out[0].length];
        int[] tempYvalues = new int[out[0].length];
        int seisIndex = seisStartIndex;
        int numAdded = 0;
        int xvalue = Math.round((float)SimplePlotUtil.linearInterp(seisStartIndex, pixelStartIndex, seisEndIndex, pixelEndIndex, seisIndex));
        int tempValue = 0;
        ++seisIndex;
        int j = 0;
        while (seisIndex <= seisEndIndex) {
            tempValue = Math.round((float)SimplePlotUtil.linearInterp(seisStartIndex, pixelStartIndex, seisEndIndex, pixelEndIndex, seisIndex));
            tempYvalues[j++] = (int)seis.getValueAt(seisIndex).getValue();
            if (tempValue != xvalue) {
                out[0][numAdded] = xvalue;
                out[0][numAdded + 1] = xvalue;
                out[1][numAdded] = SimplePlotUtil.getMinValue(tempYvalues, 0, j - 1);
                out[1][numAdded + 1] = SimplePlotUtil.getMaxValue(tempYvalues, 0, j - 1);
                j = 0;
                xvalue = tempValue;
                numAdded += 2;
            }
            ++seisIndex;
        }
        int[][] temp = new int[2][numAdded];
        System.arraycopy(out[0], 0, temp[0], 0, numAdded);
        System.arraycopy(out[1], 0, temp[1], 0, numAdded);
        return temp;
    }

    private static int getMinValue(int[] yValues, int startIndex, int endIndex) {
        int minValue = Integer.MAX_VALUE;
        for (int i = startIndex; i <= endIndex; ++i) {
            if (yValues[i] >= minValue) continue;
            minValue = yValues[i];
        }
        return minValue;
    }

    private static int getMaxValue(int[] yValues, int startIndex, int endIndex) {
        int maxValue = Integer.MIN_VALUE;
        for (int i = startIndex; i <= endIndex; ++i) {
            if (yValues[i] <= maxValue) continue;
            maxValue = yValues[i];
        }
        return maxValue;
    }

    public static final double linearInterp(double xa, double ya, double xb, double yb, double x) {
        if (x == xa) {
            return ya;
        }
        if (x == xb) {
            return yb;
        }
        return (yb - ya) * (x - xa) / (xb - xa) + ya;
    }

    public static final int getPixel(int totalPixels, MicroSecondTimeRange tr, MicroSecondDate value) {
        return SimplePlotUtil.getPixel(totalPixels, tr.getBeginTime(), tr.getEndTime(), value);
    }

    public static final int getPoint(LocalSeismogramImpl seis, MicroSecondDate time) {
        return SimplePlotUtil.getPixel(seis.getNumPoints(), seis.getBeginTime(), seis.getEndTime(), time);
    }

    public static final int getPixel(int totalPixels, MicroSecondDate begin, MicroSecondDate end, MicroSecondDate value) {
        return SimplePlotUtil.getPixel(0, totalPixels, begin, end, value);
    }

    public static final int getPixel(int startPixel, int endPixel, MicroSecondDate begin, MicroSecondDate end, MicroSecondDate value) {
        return (int)SimplePlotUtil.linearInterp(begin.getMicroSecondTime(), startPixel, end.getMicroSecondTime(), endPixel, value.getMicroSecondTime());
    }

    public static final MicroSecondDate getValue(int totalPixels, MicroSecondDate begin, MicroSecondDate end, int pixel) {
        return SimplePlotUtil.getValue(0, totalPixels, begin, end, pixel);
    }

    public static final MicroSecondDate getValue(int startPixel, int endPixel, MicroSecondDate begin, MicroSecondDate end, int pixel) {
        double value = SimplePlotUtil.linearInterp(startPixel, 0.0, endPixel, end.getMicroSecondTime() - begin.getMicroSecondTime(), pixel);
        return new MicroSecondDate(begin.getMicroSecondTime() + (long)value);
    }

    public static final int getPixel(int totalPixels, UnitRangeImpl range, QuantityImpl value) {
        QuantityImpl converted = value.convertTo(range.getUnit());
        return SimplePlotUtil.getPixel(totalPixels, range, converted.getValue());
    }

    public static final int getPixel(int totalPixels, UnitRangeImpl range, double value) {
        return (int)SimplePlotUtil.linearInterp(range.getMinValue(), 0.0, range.getMaxValue(), totalPixels, value);
    }

    public static final QuantityImpl getValue(int totalPixels, UnitRangeImpl range, int pixel) {
        double value = SimplePlotUtil.linearInterp(0.0, range.getMinValue(), totalPixels, range.getMaxValue(), pixel);
        return new QuantityImpl(value, (Unit)range.getUnit());
    }

    public static final MicroSecondDate getTimeForIndex(int index, MicroSecondDate beginTime, SamplingImpl sampling) {
        TimeInterval width = sampling.getPeriod();
        width = (TimeInterval)width.multiplyBy((double)index);
        return beginTime.add(width);
    }

    public static LocalSeismogramImpl createTestData() {
        return SimplePlotUtil.createTestData("Fake Data");
    }

    public static LocalSeismogramImpl createTestData(String name) {
        int[] dataBits = new int[100];
        for (int i = 0; i < dataBits.length; ++i) {
            double tmpDouble = Math.random() * 2.0 - 1.0;
            tmpDouble = tmpDouble * tmpDouble * tmpDouble * tmpDouble * tmpDouble;
            dataBits[i] = (int)Math.round(tmpDouble * 2000.0);
        }
        return SimplePlotUtil.createTestData(name, dataBits);
    }

    public static LocalSeismogramImpl createTestData(String name, int[] dataBits) {
        String id = "Nowhere: " + name;
        Time time = new Time("19991231T235959.000Z", -1);
        TimeInterval timeInterval = new TimeInterval(1.0, UnitImpl.SECOND);
        SamplingImpl sampling = new SamplingImpl(20, timeInterval);
        ChannelId channelID = new ChannelId(new NetworkId("XX", time), "FAKE", "00", "BHZ", time);
        TimeSeriesDataSel bits = new TimeSeriesDataSel();
        bits.int_values(dataBits);
        Property[] props = new Property[]{new Property("Name", name)};
        TimeInterval[] time_corr = new TimeInterval[]{new TimeInterval(0.123, UnitImpl.SECOND)};
        LocalSeismogramImpl seis = new LocalSeismogramImpl(id, props, time, dataBits.length, (Sampling)sampling, (Unit)UnitImpl.COUNT, channelID, new ParameterRef[0], (Quantity[])time_corr, (Sampling[])new SamplingImpl[0], bits);
        return seis;
    }

    public static ChannelId makeChanId(Time time) {
        return new ChannelId(new NetworkId("XX", time), "FAKE", "00", "BHZ", time);
    }

    public static LocalSeismogramImpl createTestData(String name, int[] dataBits, Time time) {
        return SimplePlotUtil.createTestData(name, dataBits, time, SimplePlotUtil.makeChanId(time));
    }

    public static LocalSeismogramImpl createTestData(String name, int[] dataBits, Time time, ChannelId channelID) {
        TimeInterval timeInterval = new TimeInterval(1.0, UnitImpl.SECOND);
        SamplingImpl sampling = new SamplingImpl(20, timeInterval);
        return SimplePlotUtil.createTestData(name, dataBits, time, channelID, sampling);
    }

    public static LocalSeismogramImpl createTestData(String name, int[] dataBits, Time time, ChannelId channelID, SamplingImpl sampling) {
        String id = "Nowhere: " + name;
        TimeSeriesDataSel bits = new TimeSeriesDataSel();
        bits.int_values(dataBits);
        Property[] props = new Property[]{new Property("Name", name)};
        TimeInterval[] time_corr = new TimeInterval[]{new TimeInterval(0.123, UnitImpl.SECOND)};
        LocalSeismogramImpl seis = new LocalSeismogramImpl(id, props, time, dataBits.length, (Sampling)sampling, (Unit)UnitImpl.COUNT, channelID, new ParameterRef[0], (Quantity[])time_corr, (Sampling[])new SamplingImpl[0], bits);
        return seis;
    }

    public static LocalSeismogramImpl createCustomSineWave() {
        int[] dataBits = new int[1200];
        for (int i = 0; i < dataBits.length; ++i) {
            dataBits[i] = (int)Math.round(Math.sin(0.0 + (double)i * Math.PI * 1.0 / 20.0) * 1000.0);
        }
        return SimplePlotUtil.createTestData("Sine Wave", dataBits, new Time("19911015T163000.000Z", -1));
    }

    public static LocalSeismogramImpl createSineWave() {
        return SimplePlotUtil.createSineWave(0.0);
    }

    public static LocalSeismogramImpl createSineWave(double phase) {
        return SimplePlotUtil.createSineWave(phase, 1.0);
    }

    public static LocalSeismogramImpl createSineWave(double phase, double hertz) {
        return SimplePlotUtil.createSineWave(phase, hertz, 1200);
    }

    public static LocalSeismogramImpl createSineWave(double phase, double hertz, int numPoints) {
        return SimplePlotUtil.createSineWave(phase, hertz, numPoints, 1000.0);
    }

    public static LocalSeismogramImpl createSineWave(double phase, double hertz, int numPoints, double amp) {
        int[] dataBits = new int[numPoints];
        for (int i = 0; i < dataBits.length; ++i) {
            dataBits[i] = (int)Math.round(Math.sin(phase + (double)i * Math.PI * hertz / 20.0) * amp);
        }
        return SimplePlotUtil.createTestData("Sine Wave, phase " + phase + " hertz " + hertz, dataBits);
    }

    public static LocalSeismogramImpl createHighSineWave(double phase, double hertz) {
        int[] dataBits = new int[120];
        for (int i = 0; i < dataBits.length; ++i) {
            dataBits[i] = (int)Math.round(Math.sin(phase + (double)i * Math.PI * hertz / 20.0) * 1000.0 + 500.0);
        }
        return SimplePlotUtil.createTestData("Sine Wave, phase " + phase + " hertz " + hertz, dataBits);
    }

    public static LocalSeismogramImpl createLowSineWave(double phase, double hertz) {
        int[] dataBits = new int[120];
        for (int i = 0; i < dataBits.length; ++i) {
            dataBits[i] = (int)Math.round(Math.sin(phase + (double)i * Math.PI * hertz / 20.0) * 1000.0 - 500.0);
        }
        return SimplePlotUtil.createTestData("Sine Wave, phase " + phase + " hertz " + hertz, dataBits);
    }

    public static LocalSeismogramImpl createDelta() {
        MicroSecondDate now = ClockUtil.now();
        TimeInterval traceLength = new TimeInterval(50.0, UnitImpl.SECOND);
        double traceSecs = traceLength.getValue(UnitImpl.SECOND);
        int[] dataBits = new int[(int)(20.0 * traceSecs)];
        dataBits[0] = 1;
        return SimplePlotUtil.createTestData("kronecker delta at 0", dataBits, now.getFissuresTime(), SimplePlotUtil.makeChanId(now.getFissuresTime()));
    }

    public static LocalSeismogramImpl createSpike() {
        return SimplePlotUtil.createSpike(ClockUtil.now());
    }

    public static LocalSeismogramImpl createSpike(MicroSecondDate spikeTime) {
        return SimplePlotUtil.createSpike(spikeTime, new TimeInterval(50.0, UnitImpl.SECOND));
    }

    public static LocalSeismogramImpl createSpike(MicroSecondDate spikeTime, TimeInterval traceLength) {
        return SimplePlotUtil.createSpike(spikeTime, traceLength, 20, SimplePlotUtil.makeChanId(spikeTime.getFissuresTime()));
    }

    public static LocalSeismogramImpl createSpike(MicroSecondDate time, TimeInterval traceLength, int samplesPerSpike, ChannelId id) {
        return SimplePlotUtil.createRaggedSpike(time, traceLength, samplesPerSpike, 0, id);
    }

    public static LocalSeismogramImpl createRaggedSpike(MicroSecondDate time, TimeInterval traceLength, int samplesPerSpike, int missingSamples, ChannelId id) {
        return SimplePlotUtil.createRaggedSpike(time, traceLength, samplesPerSpike, missingSamples, id, 20.0);
    }

    public static LocalSeismogramImpl createRaggedSpike(MicroSecondDate time, TimeInterval traceLength, int samplesPerSpike, int missingSamples, ChannelId id, double samplesPerSecond) {
        double secondShift = (double)missingSamples / samplesPerSecond;
        TimeInterval shiftInt = new TimeInterval(secondShift, UnitImpl.SECOND);
        time = time.add(shiftInt);
        traceLength = traceLength.subtract(shiftInt);
        String name = "spike at " + time.toString();
        double traceSecs = traceLength.convertTo(UnitImpl.SECOND).getValue();
        int[] dataBits = new int[(int)Math.round(samplesPerSecond * traceSecs)];
        for (int i = 0; i < dataBits.length; ++i) {
            if ((i + missingSamples) % samplesPerSpike != 0) continue;
            dataBits[i] = 100;
        }
        return SimplePlotUtil.createTestData(name, dataBits, time.getFissuresTime(), id, new SamplingImpl(dataBits.length, new TimeInterval(traceSecs, UnitImpl.SECOND)));
    }
}

