/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.ScaleBorder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;

public class LeftTitleBorder
extends AbstractBorder {
    private String title;
    private Rectangle2D titleBounds;
    private int top = 0;
    private int left = 0;
    private int bottom = 0;
    private int right = 0;

    public LeftTitleBorder(String title) {
        this.setTitle(title);
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(this.top, this.left, this.bottom, this.right);
    }

    public Insets getBorderInsets(Component c, Insets i) {
        i.top = this.top;
        i.left = this.left;
        i.right = this.right;
        i.bottom = this.bottom;
        return new Insets(this.top, this.left, this.bottom, this.right);
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.title == null || this.title.equals("")) {
            return;
        }
        Graphics2D g2D = (Graphics2D)g;
        g2D.setFont(DisplayUtils.BORDER_FONT);
        if (this.titleBounds == null) {
            this.titleBounds = g2D.getFontMetrics().getStringBounds(this.title, g2D);
            this.left = (int)this.titleBounds.getHeight();
        }
        Insets componentInsets = ((JComponent)c).getInsets();
        height = height - componentInsets.bottom - componentInsets.top;
        double yTranslate = (double)(componentInsets.top + height) - ((double)(height - y) - this.titleBounds.getWidth()) / 2.0;
        double xTranslate = (double)x + this.titleBounds.getHeight();
        g2D.translate(xTranslate, yTranslate);
        g2D.rotate(-1.5707963267948966);
        g2D.drawString(this.title, 0, 0);
        g2D.rotate(1.5707963267948966);
        g2D.translate(-xTranslate, -yTranslate);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String v) {
        this.title = v;
        if (this.title != null && !this.title.equals("")) {
            this.left = ScaleBorder.getFontHeight(this.title);
        }
        this.titleBounds = null;
    }
}

