/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class BorderedDisplay
extends JPanel {
    public static final int TOP_LEFT = 0;
    public static final int TOP_CENTER = 1;
    public static final int TOP_RIGHT = 2;
    public static final int CENTER_LEFT = 3;
    public static final int CENTER = 4;
    public static final int CENTER_RIGHT = 5;
    public static final int BOTTOM_LEFT = 6;
    public static final int BOTTOM_CENTER = 7;
    public static final int BOTTOM_RIGHT = 8;
    private JComponent[] comps = new JComponent[9];

    public BorderedDisplay() {
        this.setLayout(new GridBagLayout());
    }

    public BorderedDisplay(JComponent centerPanel) {
        this();
        this.add(centerPanel, 4);
    }

    public JComponent get(int position) {
        return this.comps[position];
    }

    public void outputToPNG(String filename) throws IOException {
        this.outputToPNG(new File(filename));
    }

    public void outputToPNG(File f) throws IOException {
        this.outputToPNG(f, this.getPreferredSize());
    }

    public void outputToPNG(File loc, Dimension size) throws IOException {
        loc.getCanonicalFile().getParentFile().mkdirs();
        File temp = File.createTempFile(loc.getName(), null, loc.getParentFile());
        this.outputToPNG(new BufferedOutputStream(new FileOutputStream(temp)), size);
        loc.delete();
        temp.renameTo(loc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputToPNG(OutputStream loc, Dimension size) throws IOException {
        BufferedImage bImg = new BufferedImage(size.width, size.height, 1);
        Graphics2D g2d = bImg.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.renderToGraphics(g2d, size);
        try {
            ImageIO.write((RenderedImage)bImg, "png", loc);
        }
        finally {
            loc.close();
        }
    }

    public void renderToGraphics(Graphics2D g) {
        this.renderToGraphics(g, this.getPreferredSize());
    }

    public void renderToGraphics(Graphics2D g, Dimension size) {
        if (this.getRootPane() == null) {
            this.addNotify();
        }
        Dimension curSize = this.getSize();
        this.setSize(size);
        this.validate();
        this.print(g);
        this.setSize(curSize);
    }

    public Component add(Component comp) {
        throw new UnsupportedOperationException("Use add(JComponent, int) instead");
    }

    public void add(Component comp, Object obj) {
        throw new UnsupportedOperationException("Use add(JComponent, int) instead");
    }

    public Component add(Component comp, int position) {
        throw new UnsupportedOperationException("Use add(JComponent, int) instead");
    }

    public void add(JComponent comp, int position) {
        this.clear(position);
        this.comps[position] = comp;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = position % 3;
        gbc.gridy = position / 3;
        gbc.weightx = gbc.gridx == 1 ? 1.0 : 0.0;
        gbc.weighty = gbc.gridy == 1 ? 1.0 : 0.0;
        super.add((Component)comp, gbc);
    }

    public void clearBorders() {
        for (int i = 0; i < this.comps.length; ++i) {
            if (i == 4) continue;
            this.clear(i);
        }
    }

    public void clear(int position) {
        if (this.isFilled(position)) {
            this.remove(this.comps[position]);
            this.comps[position] = null;
        }
    }

    public void removeAll() {
        for (int i = 0; i < this.comps.length; ++i) {
            this.clear(i);
        }
        super.removeAll();
    }

    public boolean isFilled(int position) {
        return this.comps[position] != null;
    }
}

