/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.dataset;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EarthquakeStationIterator
implements Iterator {
    private Iterator evIterator;
    private Iterator curEvIterator;
    private Map eqToStationMaps = new HashMap();
    private List evs = new ArrayList();

    public EarthquakeStationIterator(DataSet ds) {
        this.buildIterationSequence(ds, ds.getEvent());
        this.evIterator = this.evs.iterator();
    }

    private void buildIterationSequence(DataSet ds, EventAccessOperations ev) {
        String[] names = ds.getDataSetSeismogramNames();
        if (names.length > 0) {
            Map stations = null;
            if (ds.getEvent() != null) {
                stations = this.updateMap(ds.getEvent());
            } else if (ev == null) {
                stations = this.updateMap("No Earthquake");
            }
            for (int i = 0; i < names.length; ++i) {
                DataSetSeismogram seis = ds.getDataSetSeismogram(names[i]);
                String sta = seis.getRequestFilter().channel_id.station_code;
                if (!stations.containsKey(sta)) {
                    stations.put(sta, new ArrayList());
                }
                ((List)stations.get(sta)).add(seis);
            }
        }
        names = ds.getDataSetNames();
        if (ds.getEvent() != null) {
            ev = ds.getEvent();
        }
        for (int i = 0; i < names.length; ++i) {
            this.buildIterationSequence(ds.getDataSet(names[i]), ev);
        }
    }

    private Map updateMap(Object key) {
        if (!this.eqToStationMaps.containsKey(key)) {
            this.eqToStationMaps.put(key, new HashMap());
            this.evs.add(key);
        }
        return (Map)this.eqToStationMaps.get(key);
    }

    public void remove() {
        throw new UnsupportedOperationException("Can't remove from the seismograms using the iterator");
    }

    public boolean hasNext() {
        return this.evIterator.hasNext() || this.hasNext(this.curEvIterator);
    }

    public Object next() {
        if (this.hasNext(this.curEvIterator)) {
            return this.curEvIterator.next();
        }
        if (this.evIterator.hasNext()) {
            this.curEvIterator = ((Map)this.eqToStationMaps.get(this.evIterator.next())).values().iterator();
            return this.next();
        }
        throw new IllegalStateException("Iterator is done!  Call hasNext before you call next!");
    }

    private boolean hasNext(Iterator it) {
        return it != null && it.hasNext();
    }
}

