/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.seismogram;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.Fissures.seismogramDC.SeismogramAttrImpl;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.database.seismogram.JDBCSeismogramFiles;
import edu.sc.seis.fissuresUtil.database.seismogram.PopulationProperties;
import edu.sc.seis.fissuresUtil.database.seismogram.RT130Report;
import edu.sc.seis.fissuresUtil.mseed.FissuresConvert;
import edu.sc.seis.fissuresUtil.rt130.RT130FileHandler;
import edu.sc.seis.fissuresUtil.rt130.RT130FileHandlerFlag;
import edu.sc.seis.fissuresUtil.sac.SacToFissures;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import edu.sc.seis.fissuresUtil.xml.SeismogramFileTypes;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.MiniSeedRead;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class RT130ReportGenerator {
    public static final String BASE_FILE_SYSTEM_LOCATION = "seismogramDir";
    private static RT130FileHandler fileHandler;
    private static final Logger logger;

    public static void main(String[] args) throws FissuresException, IOException, SeedFormatException, SQLException, NotFound, ParseException {
        int i;
        Properties props = Initializer.loadProperties(args);
        PropertyConfigurator.configure((Properties)props);
        boolean finished = false;
        String baseFileSystemLocation = props.getProperty(BASE_FILE_SYSTEM_LOCATION);
        RT130FileHandlerFlag scanMode = RT130FileHandlerFlag.SCAN;
        RT130FileHandlerFlag makeLogs = RT130FileHandlerFlag.MAKE_LOGS;
        for (i = 1; i < args.length - 1; ++i) {
            File file;
            if (args[i].equals("-props")) {
                String propFileLocation = args[i + 1];
                file = new File(propFileLocation);
                logger.debug((Object)("Properties file location: " + file.getCanonicalPath()));
                continue;
            }
            if (args[i].equals("-hsql")) {
                String hsqlFileLocation = args[i + 1];
                file = new File(hsqlFileLocation);
                logger.debug((Object)("HSQL properties file location: " + file.getCanonicalPath()));
                continue;
            }
            if (!args[i].equals("-f")) continue;
            baseFileSystemLocation = args[i + 1];
            logger.debug((Object)("Using alternative data location: " + baseFileSystemLocation));
        }
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-full")) {
                scanMode = RT130FileHandlerFlag.FULL;
                logger.debug((Object)"Full processing of RT130 data: ON");
                continue;
            }
            if (args[i].equals("-nologs")) {
                makeLogs = RT130FileHandlerFlag.NO_LOGS;
                logger.debug((Object)"Log creation: OFF");
                continue;
            }
            if (!args[i].equals("-h") && !args[i].equals("-help")) continue;
            RT130ReportGenerator.printHelp();
        }
        if (scanMode == RT130FileHandlerFlag.SCAN) {
            logger.debug((Object)"Scan processing of RT130 data: ON");
        }
        if (makeLogs == RT130FileHandlerFlag.MAKE_LOGS) {
            logger.debug((Object)"Log creation: ON");
        }
        File file = new File(baseFileSystemLocation);
        LinkedList<RT130FileHandlerFlag> flags = new LinkedList<RT130FileHandlerFlag>();
        flags.add(scanMode);
        flags.add(makeLogs);
        fileHandler = new RT130FileHandler(props, flags);
        if (file.isDirectory()) {
            finished = RT130ReportGenerator.readEntireDirectory(file);
        } else if (file.isFile()) {
            finished = RT130ReportGenerator.readSingleFile(baseFileSystemLocation);
        } else {
            logger.error((Object)("File: " + file + " is not a file or a directory. This can" + " be caused in Windows when the file path includes" + " a Unix-style reference (soft or hard)."));
        }
        if (finished) {
            System.out.println();
            System.out.println("Database population complete.");
            System.out.println();
            fileHandler.getReport().printReport();
            fileHandler.getReport().makeReportImage();
        } else {
            RT130ReportGenerator.printHelp();
        }
    }

    private static boolean readSingleFile(String fileLoc) throws IOException, FissuresException, SeedFormatException, SQLException, NotFound, ParseException {
        boolean finished = false;
        StringTokenizer t = System.getProperty("os.name").startsWith("Windows") ? new StringTokenizer(fileLoc, "\\") : new StringTokenizer(fileLoc, "/");
        String fileName = "";
        while (t.hasMoreTokens()) {
            fileName = t.nextToken();
        }
        if (fileName.length() == 18 && fileName.charAt(9) == '_') {
            finished = fileHandler.getFlags().contains(RT130FileHandlerFlag.SCAN) ? fileHandler.processSingleRefTekScan(fileLoc, fileName) : fileHandler.processSingleRefTekFull(fileLoc, fileName);
        } else if (fileName.endsWith(".mseed")) {
            finished = RT130ReportGenerator.processMSeed(fileHandler.getJDBCSeismogramFiles(), fileHandler.getReport(), fileLoc, fileName);
        } else if (fileName.endsWith(".sac")) {
            finished = RT130ReportGenerator.processSac(fileHandler.getJDBCSeismogramFiles(), fileHandler.getReport(), fileLoc, fileName, fileHandler.getProps());
        } else if (fileName.equals("SOH.RT")) {
            logger.debug((Object)("Ignoring Ref Tek file: " + fileName));
        } else if (fileName.equals(".DS_Store") || fileName.equals("._501") || fileName.equals("._504")) {
            logger.debug((Object)("Ignoring Mac OS X file: " + fileName));
        } else {
            fileHandler.getReport().addProblemFile(fileLoc, fileName + " can not be processed because it's file" + " name is not formatted correctly, and therefore" + " is assumed to be an invalid file format. If" + " the data file format is valid (mini seed, sac, rt130)" + " try renaming the file.");
            logger.debug((Object)(fileName + " can not be processed because it's file" + " name is not formatted correctly, and therefore" + " is assumed to be an invalid file format. If" + " the data file format is valid (mini seed, sac, rt130)" + " try renaming the file."));
        }
        return finished;
    }

    private static boolean readEntireDirectory(File baseDirectory) throws FissuresException, IOException, SeedFormatException, SQLException, NotFound, ParseException {
        File[] files = baseDirectory.listFiles();
        if (files == null) {
            throw new IOException("Unable to get listing of directory: " + baseDirectory);
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                RT130ReportGenerator.readEntireDirectory(files[i]);
                continue;
            }
            RT130ReportGenerator.readSingleFile(files[i].getCanonicalPath());
        }
        return true;
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("    The default SOD properties file is server.properties.");
        System.out.println("    The default database properties file is server.properties.");
        System.out.println();
        System.out.println("    -props   | Accepts alternate properties file");
        System.out.println("    -hsql    | Accepts alternate database properties file");
        System.out.println("    -f    | Accepts alternate data directory");
        System.out.println("    -full    | Turn on full processing of RT130 data");
        System.out.println("             | Scan processing of RT130 data is on by default");
        System.out.println("             |   No other types of data can be processed");
        System.out.println("    -nologs  | Do not produce master SOH file log.");
        System.out.println();
        System.out.println();
        System.out.println("Program finished before database population was completed.");
        System.out.println();
    }

    private static boolean processSac(JDBCSeismogramFiles jdbcSeisFile, RT130Report report, String fileLoc, String fileName, Properties props) throws IOException, FissuresException, SQLException {
        SacTimeSeries sacTime = new SacTimeSeries();
        try {
            sacTime.readHeader(new DataInputStream(new BufferedInputStream(new FileInputStream(fileLoc))));
        }
        catch (EOFException e) {
            report.addProblemFile(fileLoc, fileName + " seems to be an invalid sac file." + "\n" + e.getMessage());
            logger.error((Object)(fileName + " seems to be an invalid sac file." + "\n" + e.getMessage()));
            return false;
        }
        catch (FileNotFoundException e) {
            report.addProblemFile(fileLoc, "Unable to find file " + fileName + "\n" + e.getMessage());
            logger.error((Object)("Unable to find file " + fileName + "\n" + e.getMessage()));
            return false;
        }
        SeismogramAttrImpl seis = SacToFissures.getSeismogramAttr(sacTime);
        Channel chan = SacToFissures.getChannel(sacTime);
        chan = PopulationProperties.fix(chan, props);
        RT130ReportGenerator.saveSacToDatabase(jdbcSeisFile, report, chan, seis, fileLoc);
        return true;
    }

    private static boolean processMSeed(JDBCSeismogramFiles jdbcSeisFile, RT130Report report, String fileLoc, String fileName) throws IOException, SeedFormatException, FissuresException, SQLException {
        MiniSeedRead mseedRead = null;
        try {
            mseedRead = new MiniSeedRead((DataInput)new DataInputStream(new BufferedInputStream(new FileInputStream(fileLoc))));
        }
        catch (EOFException e) {
            report.addProblemFile(fileLoc, fileName + " seems to be an invalid mseed file." + "\n" + e.getMessage());
            logger.error((Object)(fileName + " seems to be an invalid mseed file." + "\n" + e.getMessage()));
            return false;
        }
        catch (FileNotFoundException e) {
            report.addProblemFile(fileLoc, "Unable to find file " + fileName + "\n" + e.getMessage());
            logger.error((Object)("Unable to find file " + fileName + "\n" + e.getMessage()));
            return false;
        }
        LinkedList<DataRecord> list = new LinkedList<DataRecord>();
        try {
            DataRecord dr = mseedRead.getNextRecord();
            list.add(dr);
        }
        catch (EOFException e) {
            // empty catch block
        }
        LocalSeismogramImpl seis = FissuresConvert.toFissures(list.toArray(new DataRecord[0]));
        RT130ReportGenerator.saveMSeedToDatabase(jdbcSeisFile, report, (SeismogramAttrImpl)seis, fileLoc);
        return true;
    }

    private static void saveSacToDatabase(JDBCSeismogramFiles jdbcSeisFile, RT130Report report, Channel chan, SeismogramAttrImpl seis, String fileLoc) throws SQLException {
        report.addSacSeismogram();
        jdbcSeisFile.saveSeismogramToDatabase(chan, seis, fileLoc, SeismogramFileTypes.SAC);
    }

    private static void saveMSeedToDatabase(JDBCSeismogramFiles jdbcSeisFile, RT130Report report, SeismogramAttrImpl seis, String fileLoc) throws SQLException {
        report.addMSeedSeismogram();
        jdbcSeisFile.saveSeismogramToDatabase(seis.channel_id, seis, fileLoc, SeismogramFileTypes.MSEED);
    }

    static {
        logger = Logger.getLogger((Class)RT130ReportGenerator.class);
    }
}

