/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.seismogram;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.Fissures.seismogramDC.SeismogramAttrImpl;
import edu.sc.seis.fissuresUtil.bag.DistAz;
import edu.sc.seis.fissuresUtil.bag.EncodedCut;
import edu.sc.seis.fissuresUtil.database.JDBCTable;
import edu.sc.seis.fissuresUtil.database.JDBCTime;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.database.network.JDBCChannel;
import edu.sc.seis.fissuresUtil.database.util.TableSetup;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.rt130.PacketType;
import edu.sc.seis.fissuresUtil.rt130.RT130FileReader;
import edu.sc.seis.fissuresUtil.rt130.RT130FormatException;
import edu.sc.seis.fissuresUtil.rt130.RT130ToLocalSeismogram;
import edu.sc.seis.fissuresUtil.time.ReduceTool;
import edu.sc.seis.fissuresUtil.xml.SeismogramFileTypes;
import edu.sc.seis.fissuresUtil.xml.URLDataSetSeismogram;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class JDBCSeismogramFiles
extends JDBCTable {
    private Map chanIdToChannel = new HashMap();
    private static final TimeInterval ONE_SECOND = new TimeInterval(1.0, UnitImpl.SECOND);
    private static final Logger logger = Logger.getLogger((Class)JDBCSeismogramFiles.class);
    private PreparedStatement insert;
    private PreparedStatement select;
    private PreparedStatement updateChannelBeginTime;
    private PreparedStatement selectSeismogram;
    private PreparedStatement updateUnitName;
    private PreparedStatement populateStationName;
    private PreparedStatement remove;
    private ResultSet databaseResults;
    private JDBCChannel chanTable;
    private JDBCTime timeTable;

    public JDBCSeismogramFiles(Connection conn) throws SQLException {
        super("seisfilereference", conn);
        this.timeTable = new JDBCTime(conn);
        this.chanTable = new JDBCChannel(conn);
        TableSetup.setup(this, "edu/sc/seis/fissuresUtil/database/seismogram/seisfilereference.vm");
    }

    public void saveSeismogramToDatabase(Channel channel, SeismogramAttrImpl seis, String fileLocation, SeismogramFileTypes filetype) throws SQLException {
        this.chanTable.put(channel);
        this.saveSeismogramToDatabase(channel.get_id(), seis, fileLocation, filetype);
    }

    public void saveSeismogramToDatabase(ChannelId channelId, SeismogramAttrImpl seis, String fileLocation, SeismogramFileTypes filetype) throws SQLException {
        this.saveSeismogramToDatabase(this.chanTable.put(channelId), this.timeTable.put(seis.getBeginTime().getFissuresTime()), this.timeTable.put(seis.getEndTime().getFissuresTime()), fileLocation, filetype);
    }

    public void saveSeismogramToDatabase(int channelDbId, int beginTimeId, int endTimeId, String fileLocation, SeismogramFileTypes filetype) throws SQLException {
        String filePath = this.getLocation(fileLocation);
        int fileTypeInt = filetype.getIntValue();
        this.selectSeismogram.setInt(1, channelDbId);
        this.selectSeismogram.setString(2, filePath);
        ResultSet results = this.selectSeismogram.executeQuery();
        if (!results.next()) {
            this.insert.setInt(1, channelDbId);
            this.insert.setInt(2, beginTimeId);
            this.insert.setInt(3, endTimeId);
            this.insert.setString(4, filePath);
            this.insert.setInt(5, fileTypeInt);
            this.insert.executeUpdate();
        }
    }

    private String getLocation(String fileLocation) {
        File seismogramFile = new File(fileLocation);
        return seismogramFile.getPath();
    }

    public int removeSeismogramFromDatabase(Channel channel, String seisFile) throws SQLException {
        this.remove.setInt(1, this.chanTable.put(channel.get_id()));
        this.remove.setString(2, this.getLocation(seisFile));
        return this.remove.executeUpdate();
    }

    public RequestFilter[] findMatchingSeismograms(RequestFilter[] requestArray, boolean ignoreNetworkTimes) throws SQLException {
        List results = this.queryDatabaseForSeismograms(requestArray, false, ignoreNetworkTimes);
        RequestFilter[] request = results.toArray(new RequestFilter[results.size()]);
        RequestFilter[] reduced = ReduceTool.merge(request);
        logger.debug((Object)("Reduced " + request.length + " to " + reduced.length));
        return reduced;
    }

    public LocalSeismogram[] getMatchingSeismograms(RequestFilter[] requestArray, boolean ignoreNetworkTimes) throws SQLException {
        List results = this.queryDatabaseForSeismograms(requestArray, true, ignoreNetworkTimes);
        LocalSeismogramImpl[] seis = results.toArray(new LocalSeismogramImpl[results.size()]);
        LocalSeismogramImpl[] reduced = ReduceTool.merge(seis);
        logger.debug((Object)("Reduced " + seis.length + " to " + reduced.length));
        return reduced;
    }

    public List queryDatabaseForSeismograms(RequestFilter[] request, boolean returnSeismograms, boolean ignoreNetworkTimes) throws SQLException {
        RequestFilter[] minimalRequest = ReduceTool.merge(request);
        ArrayList resultCollector = new ArrayList();
        for (int i = 0; i < minimalRequest.length; ++i) {
            this.queryDatabaseForSeismogram(resultCollector, minimalRequest[i], returnSeismograms, ignoreNetworkTimes);
        }
        return resultCollector;
    }

    public Channel findCloseChannel(Channel newChannel, QuantityImpl distance) throws SQLException, NotFound {
        ChannelId[] channelId;
        try {
            channelId = this.chanTable.getIdsByCode(newChannel.get_id().network_id, newChannel.get_id().station_code, newChannel.get_id().site_code, newChannel.get_code());
        }
        catch (NotFound e) {
            return null;
        }
        ChannelId newChannelId = newChannel.get_id();
        for (int i = 0; i < channelId.length; ++i) {
            if (!ChannelIdUtil.areEqualExceptForBeginTime((ChannelId)newChannelId, (ChannelId)channelId[i])) continue;
            Channel closeChannel = this.getChannel(channelId[i]);
            Location locationFromDatabase = closeChannel.my_site.my_location;
            DistAz da = new DistAz(locationFromDatabase, newChannel.my_site.my_location);
            QuantityImpl siteDistance = new QuantityImpl(DistAz.degreesToKilometers(da.getDelta()), (Unit)UnitImpl.KILOMETER);
            if (!siteDistance.lessThan(distance)) continue;
            return closeChannel;
        }
        return null;
    }

    private Channel getChannel(ChannelId channelId) throws SQLException, NotFound {
        String chanIdString = ChannelIdUtil.toString((ChannelId)channelId);
        Channel closeChannel = (Channel)this.chanIdToChannel.get(chanIdString);
        if (closeChannel == null) {
            closeChannel = this.chanTable.get(channelId);
            this.chanIdToChannel.put(chanIdString, closeChannel);
        }
        return closeChannel;
    }

    public void setChannelBeginTimeToEarliest(Channel channelFromDatabase, Channel newChannel) throws SQLException, NotFound {
        MicroSecondDate newChannelBeginTime = new MicroSecondDate(newChannel.get_id().begin_time);
        MicroSecondDate newChannelEndTime = new MicroSecondDate(newChannel.effective_time.end_time);
        MicroSecondDate channelFromDatabaseBeginTime = new MicroSecondDate(channelFromDatabase.get_id().begin_time);
        MicroSecondDate channelFromDatabaseEndTime = new MicroSecondDate(channelFromDatabase.effective_time.end_time);
        if (newChannelBeginTime.before((Date)channelFromDatabaseBeginTime) && newChannelEndTime.equals((Object)channelFromDatabaseEndTime)) {
            this.updateChannelBeginTime.setInt(1, this.timeTable.put(newChannel.get_id().begin_time));
            this.updateChannelBeginTime.setInt(2, this.chanTable.getDBId(channelFromDatabase.get_id()));
            this.updateChannelBeginTime.executeUpdate();
            channelFromDatabase.get_id().begin_time = newChannel.get_id().begin_time;
        }
    }

    private void queryDatabaseForSeismogram(List resultCollector, RequestFilter request, boolean returnSeismograms, boolean ignoreNetworkTimes) throws SQLException {
        int[] chanId;
        EncodedCut cutter = new EncodedCut(request);
        try {
            chanId = ignoreNetworkTimes ? this.chanTable.getDBIdIgnoringNetworkId(request.channel_id.network_id.network_code, request.channel_id.station_code, request.channel_id.site_code, request.channel_id.channel_code) : new int[]{this.chanTable.getDBId(request.channel_id)};
        }
        catch (NotFound e) {
            logger.debug((Object)"Can not find channel ID in database.");
            return;
        }
        MicroSecondDate adjustedBeginTime = new MicroSecondDate(request.start_time).subtract(ONE_SECOND);
        MicroSecondDate adjustedEndTime = new MicroSecondDate(request.end_time).add(ONE_SECOND);
        for (int i = 0; i < chanId.length; ++i) {
            this.select.setInt(1, chanId[i]);
            this.select.setTimestamp(2, adjustedEndTime.getTimestamp());
            this.select.setTimestamp(3, adjustedBeginTime.getTimestamp());
            logger.debug((Object)("Making query " + this.select));
            this.databaseResults = this.select.executeQuery();
            if (returnSeismograms) {
                try {
                    while (this.databaseResults.next()) {
                        LocalSeismogramImpl[] curSeis;
                        File seismogramFile = new File(this.databaseResults.getString(4));
                        SeismogramFileTypes filetype = SeismogramFileTypes.fromInt(this.databaseResults.getInt("filetype"));
                        if (filetype.equals(SeismogramFileTypes.RT_130)) {
                            List refTekSeis = this.getMatchingSeismogramsFromRefTek(seismogramFile.getCanonicalPath(), request.channel_id, adjustedBeginTime, adjustedEndTime);
                            curSeis = refTekSeis.toArray(new LocalSeismogramImpl[refTekSeis.size()]);
                        } else {
                            URLDataSetSeismogram urlSeis = new URLDataSetSeismogram(seismogramFile.toURL(), filetype);
                            curSeis = urlSeis.getSeismograms();
                        }
                        for (int j = 0; j < curSeis.length; ++j) {
                            LocalSeismogramImpl seis = cutter.apply(curSeis[j]);
                            if (seis == null) continue;
                            resultCollector.add(seis);
                        }
                        logger.debug((Object)("After adding " + seismogramFile + " there are " + resultCollector.size() + " items"));
                    }
                    continue;
                }
                catch (Exception e) {
                    GlobalExceptionHandler.handle("Problem occured while returning seismograms from the database.\nThe problem file is located at " + this.databaseResults.getString(4), e);
                    continue;
                }
            }
            try {
                while (this.databaseResults.next()) {
                    RequestFilter req = new RequestFilter(this.chanTable.getId(this.databaseResults.getInt(1)), this.timeTable.get(this.databaseResults.getInt(2)), this.timeTable.get(this.databaseResults.getInt(3)));
                    if ((req = cutter.apply(req)) == null) continue;
                    resultCollector.add(req);
                }
                continue;
            }
            catch (Exception e) {
                GlobalExceptionHandler.handle("Problem occured while querying the database for seismograms.", e);
            }
        }
    }

    private List getMatchingSeismogramsFromRefTek(String seismogramFile, ChannelId chanId, MicroSecondDate beginTime, MicroSecondDate endTime) throws IOException, RT130FormatException {
        RT130FileReader toSeismogramDataPacket = new RT130FileReader(seismogramFile, true);
        PacketType[] seismogramDataPacketArray = toSeismogramDataPacket.processRT130Data();
        RT130ToLocalSeismogram toSeismogram = new RT130ToLocalSeismogram();
        LocalSeismogramImpl[] seis = toSeismogram.ConvertRT130ToLocalSeismogram(seismogramDataPacketArray);
        logger.debug((Object)("Got " + seis.length + " seismograms out of " + seismogramFile));
        ArrayList<LocalSeismogramImpl> matchingSeis = new ArrayList<LocalSeismogramImpl>();
        for (int i = 0; i < seis.length; ++i) {
            if (!seis[i].channel_id.channel_code.equals(chanId.channel_code) || !seis[i].getBeginTime().before((Date)endTime) || !seis[i].getEndTime().after((Date)beginTime)) continue;
            seis[i].channel_id = chanId;
            matchingSeis.add(seis[i]);
        }
        logger.debug((Object)(matchingSeis.size() + " were of the right channel code"));
        return matchingSeis;
    }

    public void updateStationCode(String oldName, String newName) throws SQLException {
        this.updateUnitName.setString(1, newName);
        this.updateUnitName.setString(2, oldName);
        this.updateUnitName.executeUpdate();
    }

    public void populateStationName() throws SQLException {
        this.populateStationName.executeUpdate();
    }
}

