/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.chooser;

import com.isti.util.updatechecker.LocationUpdate;
import com.isti.util.updatechecker.UpdateAction;
import com.isti.util.updatechecker.UpdateInformation;
import com.isti.util.updatechecker.XMLUpdateCheckerClient;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.cache.AbstractJob;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.util.Date;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class UpdateCheckerJob
extends AbstractJob {
    protected final TimeInterval SIX_HOUR = new TimeInterval(6.0, UnitImpl.HOUR);
    protected final TimeInterval FORTNIGHT = new TimeInterval(14.0, UnitImpl.DAY);
    protected final TimeInterval MONTH = new TimeInterval(30.0, UnitImpl.DAY);
    protected String prefsName;
    protected String version;
    protected String programName;
    protected boolean forceCheck;
    protected boolean showNoUpdate = false;
    protected boolean isGui;
    static boolean checkedYet = false;
    protected String updateURL;
    protected Preferences prefs;
    static final String NEXT_CHECK_DATE = "nextCheckDate";
    private static final Logger logger = Logger.getLogger((Class)UpdateCheckerJob.class);

    public UpdateCheckerJob(String displayName, String programName, String version, String updateURL, boolean gui) {
        this(displayName, programName, version, updateURL, gui, false);
    }

    public UpdateCheckerJob(String displayName, String programName, String version, String updateURL, boolean gui, boolean forceCheck) {
        super(displayName);
        this.programName = programName;
        this.updateURL = updateURL;
        this.isGui = gui;
        this.forceCheck = forceCheck;
        this.version = version;
        this.prefs = Preferences.userNodeForPackage(this.getClass());
        this.prefsName = programName + "_" + NEXT_CHECK_DATE;
    }

    public void runJob() {
        block8: {
            if (!this.forceCheck && checkedYet) {
                this.setFinished();
                return;
            }
            checkedYet = true;
            boolean checkNeeded = true;
            this.prefs = this.prefs.node("UpdateCheckerTask");
            MicroSecondDate now = ClockUtil.now();
            String nextCheckDate = this.prefs.get(this.prefsName, now.subtract((TimeInterval)this.SIX_HOUR).getFissuresTime().date_time);
            MicroSecondDate date = new MicroSecondDate(new Time(nextCheckDate, -1));
            if (date.after((Date)now) && !this.forceCheck) {
                logger.debug((Object)("no updated wanted until " + date));
                this.setFinished(true);
                return;
            }
            this.setStatus("Connect to server");
            XMLUpdateCheckerClient updateChecker = new XMLUpdateCheckerClient(this.version, this.updateURL);
            this.setStatus("Check for update");
            if (updateChecker.isUpdateAvailable()) {
                UpdateInformation[] updates = updateChecker.getUpdates();
                logger.info((Object)("our version is " + this.version + ", update version is " + updates[updates.length - 1].getVersion()));
                UpdateAction[] actions = updates[updates.length - 1].getUpdateActions();
                LocationUpdate locationUpdate = (LocationUpdate)actions[0];
                try {
                    if (this.isGui) {
                        this.handleUpdateGUI(locationUpdate);
                        break block8;
                    }
                    this.handleUpdateNonGUI(locationUpdate);
                }
                catch (BackingStoreException e) {
                    GlobalExceptionHandler.handle("trouble flushing preferences for updatechecker", e);
                }
            } else if (this.showNoUpdate) {
                JOptionPane.showMessageDialog(null, "No update is available", "Update Check", 1);
                logger.info((Object)"No update is available");
            }
        }
        this.setFinished();
    }

    protected void handleUpdateGUI(LocationUpdate locationUpdate) throws BackingStoreException {
        Object[] options = new String[]{"Go To Update Page", "Remind in a fortnight", "Remind in a month"};
        int n = JOptionPane.showOptionDialog(null, "An updated version of " + this.programName + " is available!\nPlease go to\n" + locationUpdate.getLocation() + "\nto get the latest version.", "An updated version of " + this.programName + " is available!", 0, 3, null, options, options[0]);
        logger.debug((Object)("return val is " + n));
        TimeInterval nextInterval = this.SIX_HOUR;
        if (n == 0) {
            logger.debug((Object)"Opening browser");
            this.setStatus("Opening browser");
            locationUpdate.run();
        } else if (n == 1) {
            nextInterval = this.FORTNIGHT;
        } else if (n == 2) {
            nextInterval = this.MONTH;
        }
        MicroSecondDate nextCheck = ClockUtil.now().add(nextInterval);
        this.prefs.put(this.prefsName, nextCheck.getFissuresTime().date_time);
        logger.debug((Object)("no update check wanted for " + nextInterval + ", next at " + nextCheck));
        this.prefs.flush();
        logger.debug((Object)"done flushing prefs");
    }

    protected void handleUpdateNonGUI(LocationUpdate locationUpdate) throws BackingStoreException {
        System.err.println("*******************************************************");
        System.err.println();
        System.err.println("An updated version of " + this.programName + " is available!");
        System.err.println("Please go to " + locationUpdate.getLocation() + " to get the latest version.");
        System.err.println();
        System.err.println("*******************************************************");
        this.prefs.put(this.prefsName, ClockUtil.now().add((TimeInterval)this.SIX_HOUR).getFissuresTime().date_time);
        this.prefs.flush();
    }
}

