/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.NetworkNotFound;
import edu.sc.seis.fissuresUtil.cache.CacheNetworkAccess;
import edu.sc.seis.fissuresUtil.cache.NSNetworkAccess;
import edu.sc.seis.fissuresUtil.cache.NSNetworkFinder;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkAccess;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkDC;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkFinder;
import edu.sc.seis.fissuresUtil.cache.RetryNetworkAccess;
import edu.sc.seis.fissuresUtil.cache.SynchronizedNetworkAccess;

public class VestingNetworkFinder
extends ProxyNetworkFinder {
    int numRetry;

    public VestingNetworkFinder(ProxyNetworkDC netDC, int numRetry) {
        super(new NSNetworkFinder(netDC));
        this.numRetry = numRetry;
    }

    public NetworkAccess retrieve_by_id(NetworkId id) throws NetworkNotFound {
        return this.vest(this.nf.retrieve_by_id(id));
    }

    public NetworkAccess[] retrieve_by_code(String code) throws NetworkNotFound {
        return this.vest(this.nf.retrieve_by_code(code));
    }

    public NetworkAccess[] retrieve_by_name(String name) throws NetworkNotFound {
        return this.vest(this.nf.retrieve_by_name(name));
    }

    public NetworkAccess[] retrieve_all() {
        return this.vest(this.nf.retrieve_all());
    }

    public NetworkAccess[] vest(NetworkAccess[] accesses) {
        NetworkAccess[] vested = new NetworkAccess[accesses.length];
        for (int i = 0; i < accesses.length; ++i) {
            vested[i] = this.vest(accesses[i]);
        }
        return vested;
    }

    public NetworkAccess vest(NetworkAccess na) {
        return VestingNetworkFinder.vest(na, this, this.numRetry);
    }

    public static ProxyNetworkAccess vest(NetworkAccess na, VestingNetworkFinder vnf, int numRetry) {
        SynchronizedNetworkAccess synch = new SynchronizedNetworkAccess(na);
        RetryNetworkAccess retry = new RetryNetworkAccess(synch, numRetry);
        CacheNetworkAccess cache = new CacheNetworkAccess(retry);
        NetworkId id = cache.get_attributes().get_id();
        NSNetworkAccess nsNetworkAccess = new NSNetworkAccess(synch, id, vnf);
        retry.setNetworkAccess(nsNetworkAccess);
        cache.setNetworkAccess(retry);
        return cache;
    }
}

