/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.sc.seis.fissuresUtil.cache.SeismogramBackgroundLoaderPool;
import edu.sc.seis.fissuresUtil.cache.SeismogramQueueElement;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;

public class SeismogramBackgroundLoader {
    private Thread privateThread;
    private volatile boolean noStopThread = true;
    private SeismogramBackgroundLoaderPool pool;
    private static int threadNum = 0;
    private ThreadGroup seisLoaderThreadGroup = new ThreadGroup("Seismogram Loader");

    public SeismogramBackgroundLoader(SeismogramBackgroundLoaderPool pool) {
        this.pool = pool;
        Runnable r = new Runnable(){

            public void run() {
                try {
                    SeismogramBackgroundLoader.this.runWork();
                }
                catch (Throwable e) {
                    GlobalExceptionHandler.handle(e);
                }
            }
        };
        this.privateThread = new Thread(this.seisLoaderThreadGroup, r, "Seismogram Loader" + SeismogramBackgroundLoader.getThreadNum());
        this.privateThread.start();
    }

    public void runWork() {
        while (this.noStopThread) {
            try {
                SeismogramQueueElement q = this.pool.getFromQueue();
                RequestFilter[] rf = new RequestFilter[]{q.getRequest()};
                try {
                    LocalSeismogram[] seis = q.getDataCenter().retrieve_seismograms(rf);
                    q.getListener().seismogramLoaded(rf[0], seis);
                    this.pool.fireSeismogramLoaded(rf[0], seis);
                }
                catch (FissuresException e) {
                    q.getListener().seismogramError(rf[0], e);
                    this.pool.fireSeismogramError(rf[0], e);
                }
            }
            catch (InterruptedException e) {}
        }
    }

    public void stopThread() {
        this.noStopThread = false;
    }

    private static synchronized int getThreadNum() {
        return threadNum++;
    }
}

