/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfSeismogramDC.DataCenterCallBack;
import edu.iris.Fissures.IfSeismogramDC.DataCenterOperations;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.ProxySeismogramDC;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;

public class DataCenterRouter
implements DataCenterOperations {
    protected HashMap netToDCMap = new HashMap();
    protected List unmatchedDCList = new LinkedList();
    static Category logger = Category.getInstance((String)DataCenterRouter.class.getName());

    public void addDataCenter(ProxySeismogramDC dc) {
        this.unmatchedDCList.add(dc);
    }

    public void addDataCenter(NetworkAccess[] net, ProxySeismogramDC dc) {
        for (int i = 0; i < net.length; ++i) {
            this.addDataCenter(net[i].get_attributes().get_id(), dc);
        }
    }

    public void addDataCenter(NetworkAccess net, ProxySeismogramDC dc) {
        this.addDataCenter(net.get_attributes().get_id(), dc);
    }

    public void addDataCenter(NetworkId networkId, ProxySeismogramDC dc) {
        this.addDataCenter(networkId.network_code, dc);
    }

    public void addDataCenter(String network_code, ProxySeismogramDC dc) {
        logger.debug((Object)("adding " + network_code));
        List dcList = (LinkedList<ProxySeismogramDC>)this.netToDCMap.get(network_code);
        if (dcList == null) {
            dcList = new LinkedList<ProxySeismogramDC>();
            this.netToDCMap.put(network_code, dcList);
        }
        if (!dcList.contains(dc)) {
            dcList.add(dc);
        }
        Iterator it = this.netToDCMap.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            dcList = (List)this.netToDCMap.get(key);
            logger.debug((Object)("netToDCMap: " + key + " size is " + dcList.size()));
        }
    }

    public List getDataCenter(NetworkAccess net) {
        return this.getDataCenter(net.get_attributes().get_code());
    }

    public List getDataCenter(NetworkId networkId) {
        return this.getDataCenter(networkId.network_code);
    }

    public List getDataCenter(String networkCode) {
        return (List)this.netToDCMap.get(networkCode);
    }

    public List getDataCenter(ChannelId chanId) {
        return this.getDataCenter(chanId.network_id);
    }

    public RequestFilter[] available_data(RequestFilter[] filters) {
        HashMap datacenterMap = this.makeMap(filters);
        LinkedList<RequestFilter> out = new LinkedList<RequestFilter>();
        if (datacenterMap.keySet().size() == 0) {
            String s = "No datacenters found for request: ";
            for (int i = 0; i < filters.length; ++i) {
                s = s + " " + ChannelIdUtil.toStringNoDates((ChannelId)filters[i].channel_id) + filters[i].start_time.date_time + " to " + filters[i].end_time.date_time + ", ";
            }
            logger.warn((Object)s);
        }
        Iterator it = datacenterMap.keySet().iterator();
        while (it.hasNext()) {
            List dcList = (List)it.next();
            Iterator dcIt = dcList.iterator();
            List dcFilters = (List)datacenterMap.get(dcList);
            while (dcIt.hasNext()) {
                ProxySeismogramDC dc = (ProxySeismogramDC)dcIt.next();
                RequestFilter[] tempRF = dc.available_data(dcFilters.toArray(new RequestFilter[0]));
                for (int i = 0; i < tempRF.length; ++i) {
                    out.add(tempRF[i]);
                }
            }
        }
        return out.toArray(new RequestFilter[0]);
    }

    public String request_seismograms(RequestFilter[] filters, DataCenterCallBack a_client, boolean long_lived, Time expiration_time) throws FissuresException {
        return null;
    }

    public LocalSeismogram[] retrieve_seismograms(RequestFilter[] filters) throws FissuresException {
        HashMap datacenterMap = this.makeMap(filters);
        LinkedList<LocalSeismogram> out = new LinkedList<LocalSeismogram>();
        Iterator it = datacenterMap.keySet().iterator();
        block0: while (it.hasNext()) {
            List dcList = (List)it.next();
            Iterator dcIt = dcList.iterator();
            List dcFilters = (List)datacenterMap.get(dcList);
            while (dcIt.hasNext()) {
                ProxySeismogramDC dc = (ProxySeismogramDC)dcIt.next();
                LocalSeismogram[] tempSeis = dc.retrieve_seismograms(dcFilters.toArray(new RequestFilter[0]));
                for (int i = 0; i < tempSeis.length; ++i) {
                    out.add(tempSeis[i]);
                }
                if (tempSeis.length == 0) continue;
                continue block0;
            }
        }
        return out.toArray(new LocalSeismogramImpl[0]);
    }

    public String queue_seismograms(RequestFilter[] a_filterseq) throws FissuresException {
        return null;
    }

    public LocalSeismogram[] retrieve_queue(String a_request) throws FissuresException {
        return null;
    }

    public void cancel_request(String a_request) throws FissuresException {
    }

    public String request_status(String a_request) throws FissuresException {
        return null;
    }

    protected HashMap makeMap(RequestFilter[] filters) {
        HashMap<List, LinkedList<RequestFilter>> datacenterMap = new HashMap<List, LinkedList<RequestFilter>>();
        for (int i = 0; i < filters.length; ++i) {
            LinkedList datacenters = this.getDataCenter(filters[i].channel_id);
            if (datacenters == null) {
                logger.debug((Object)("Unknown network, no datacenter configured for " + ChannelIdUtil.toString((ChannelId)filters[i].channel_id)));
                datacenters = new LinkedList();
                datacenters.addAll(this.unmatchedDCList);
                continue;
            }
            LinkedList<RequestFilter> dcFilters = (LinkedList<RequestFilter>)datacenterMap.get(datacenters);
            if (dcFilters == null) {
                dcFilters = new LinkedList<RequestFilter>();
                datacenterMap.put(this.getDataCenter(filters[i].channel_id), dcFilters);
            }
            dcFilters.add(filters[i]);
        }
        return datacenterMap;
    }
}

