/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.freq.Cmplx;
import edu.sc.seis.fissuresUtil.sac.SacPoleZero;

public class Transfer {
    static final Cmplx ZERO = new Cmplx(0.0, 0.0);

    public LocalSeismogramImpl apply(LocalSeismogramImpl seis, SacPoleZero poleZero, float lowCut, float lowPass, float highPass, float highCut) throws FissuresException {
        double sampFreq = seis.getSampling().getFrequency().getValue(UnitImpl.HERTZ);
        float[] values = seis.get_as_floats();
        int i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] / (float)sampFreq;
        }
        Cmplx[] freqValues = Cmplx.fft(values);
        freqValues = Transfer.combine(freqValues, sampFreq, poleZero, lowCut, lowPass, highPass, highCut);
        values = Cmplx.fftInverse(freqValues, values.length);
        int i2 = 0;
        while (i2 < values.length) {
            int n = i2++;
            values[n] = values[n] * (float)freqValues.length;
        }
        LocalSeismogramImpl out = new LocalSeismogramImpl((SeismogramAttr)seis, values);
        out.y_unit = UnitImpl.METER;
        return out;
    }

    static Cmplx[] combine(Cmplx[] freqValues, double sampFreq, SacPoleZero poleZero, float lowCut, float lowPass, float highPass, float highCut) {
        double deltaF = sampFreq / (double)freqValues.length;
        freqValues[0] = ZERO;
        double freq = sampFreq / 2.0;
        Cmplx respAtS = Transfer.evalPoleZeroInverse(poleZero, freq);
        respAtS = Cmplx.mul(respAtS, deltaF * Transfer.freqTaper(freq, lowCut, lowPass, highPass, highCut));
        freqValues[freqValues.length / 2] = Cmplx.mul(freqValues[freqValues.length / 2], respAtS);
        for (int i = 1; i < freqValues.length / 2; ++i) {
            freq = (double)i * deltaF;
            respAtS = Transfer.evalPoleZeroInverse(poleZero, freq);
            respAtS = Cmplx.mul(respAtS, deltaF * Transfer.freqTaper(freq, lowCut, lowPass, highPass, highCut));
            freqValues[i] = Cmplx.mul(freqValues[i], respAtS);
            freqValues[freqValues.length - i] = freqValues[i].conjg();
        }
        return freqValues;
    }

    public static Cmplx evalPoleZeroInverse(SacPoleZero pz, double freq) {
        int i;
        Cmplx s = new Cmplx(0.0, Math.PI * 2 * freq);
        Cmplx zeroOut = new Cmplx(1.0, 0.0);
        Cmplx poleOut = new Cmplx(1.0, 0.0);
        for (i = 0; i < pz.getPoles().length; ++i) {
            poleOut = Cmplx.mul(poleOut, Cmplx.sub(s, pz.getPoles()[i]));
        }
        for (i = 0; i < pz.getZeros().length; ++i) {
            if (s.real() == pz.getZeros()[i].real() && s.imag() == pz.getZeros()[i].imag()) {
                return ZERO;
            }
            zeroOut = Cmplx.mul(zeroOut, Cmplx.sub(s, pz.getZeros()[i]));
        }
        Cmplx out = Cmplx.div(poleOut, zeroOut);
        return Cmplx.div(out, pz.getConstant()).conjg();
    }

    public static double freqTaper(double freq, float lowCut, float lowPass, float highPass, float highCut) {
        if (lowCut > lowPass || lowPass > highPass || highPass > highCut) {
            throw new IllegalArgumentException("must be lowCut > lowPass > highPass > highCut: " + lowCut + " " + lowPass + " " + highPass + " " + highCut);
        }
        if (freq <= (double)lowCut || freq >= (double)highCut) {
            return 0.0;
        }
        if (freq >= (double)lowPass && freq <= (double)highPass) {
            return 1.0;
        }
        if (freq > (double)lowCut && freq < (double)lowPass) {
            return 0.5 * (1.0 + Math.cos(Math.PI * (freq - (double)lowPass) / (double)(lowCut - lowPass)));
        }
        return 0.5 * (1.0 - Math.cos(Math.PI * (freq - (double)highCut) / (double)(highPass - highCut)));
    }
}

