/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.director;

import edu.iris.Fissures.seed.exception.BuilderException;
import java.util.Vector;

public abstract class FieldMapper
implements Cloneable {
    protected String mapperType = "UNKNOWN";
    protected int[] sourceMap = null;
    protected String[] destMap = null;
    protected int sourceSize = 0;
    protected int destSize = 0;
    protected int typeNum = 0;
    protected boolean mapped = false;

    public FieldMapper() {
        this.reset();
    }

    public abstract void insert(Object var1) throws Exception;

    public abstract String toString();

    public String getType() {
        return this.mapperType;
    }

    public void reset() {
        this.sourceMap = null;
        this.destMap = null;
        this.sourceSize = 0;
        this.destSize = 0;
        this.typeNum = 0;
        this.mapped = false;
    }

    public Object clone() {
        try {
            FieldMapper cloneMapper = (FieldMapper)super.clone();
            return cloneMapper;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean addField(int index, String value) throws Exception {
        if (!this.mapped) {
            throw new BuilderException("cannot add field value without establishing mapping first");
        }
        if (index < 0) {
            throw new BuilderException("addField index number is less than zero");
        }
        if (index >= this.sourceMap.length) {
            throw new BuilderException("addField index is out of bounds");
        }
        int destIndex = this.sourceMap[index];
        if (destIndex < 1) {
            return false;
        }
        if (destIndex >= this.destMap.length) {
            throw new BuilderException("destination map index returned from source map is out of bounds");
        }
        this.destMap[destIndex] = value;
        return true;
    }

    public String getField(int index) throws Exception {
        if (!this.mapped) {
            throw new BuilderException("cannot get field value without establishing mapping first");
        }
        if (index < 0) {
            throw new BuilderException("getField index number is less than zero");
        }
        if (index >= this.sourceMap.length) {
            throw new BuilderException("getField index is out of bounds");
        }
        int destIndex = this.sourceMap[index];
        if (destIndex < 1) {
            return new String("");
        }
        if (destIndex >= this.destMap.length) {
            throw new BuilderException("destination map index returned from source map is out of bounds");
        }
        if (this.destMap[destIndex] == null) {
            return new String("");
        }
        return this.destMap[destIndex];
    }

    public void generateMap(Vector fieldMap) throws Exception {
        if (this.sourceMap == null || this.destMap == null) {
            throw new BuilderException("sourceMap and/or destMap need to have space allocated");
        }
        int i = 0;
        while (i < fieldMap.size()) {
            int sourceIndex = (Integer)fieldMap.get(i);
            int destIndex = (Integer)fieldMap.get(i + 1);
            if (sourceIndex < 0 || destIndex < 0) {
                throw new BuilderException("attempting to map an index value less than zero: (" + sourceIndex + " --> " + destIndex + ")");
            }
            if (sourceIndex >= this.sourceMap.length) {
                throw new BuilderException("source mapping index value is out of bounds: (typeNum=" + this.typeNum + ", sourceIndex=" + sourceIndex + ", destIndex=" + destIndex + ")");
            }
            if (destIndex >= this.destMap.length) {
                throw new BuilderException("destination mapping index value is out of bounds: (typeNum=" + this.typeNum + ", sourceIndex=" + sourceIndex + ", destIndex=" + destIndex + ")");
            }
            this.sourceMap[sourceIndex] = destIndex;
            i += 2;
        }
        this.mapped = true;
    }

    public void allocateMapSpace(int sourceSize, int destSize) throws Exception {
        if (sourceSize <= 0 || destSize <= 0) {
            throw new BuilderException("allocated source or destination size is less than or equal to zero");
        }
        this.sourceMap = new int[sourceSize];
        this.destMap = new String[destSize];
        this.sourceSize = sourceSize;
        this.destSize = destSize;
    }

    public int getDestObjType() {
        return this.typeNum;
    }

    public void setDestObjType(int typeNum) {
        this.typeNum = typeNum;
    }
}

