/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.container;

import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.container.BlocketteFactory;
import edu.iris.Fissures.seed.container.BlockettePlaceholder;
import edu.iris.Fissures.seed.container.BlocketteVector;
import edu.iris.Fissures.seed.container.Btime;
import edu.iris.Fissures.seed.container.ObjectContainer;
import edu.iris.Fissures.seed.container.SeedBlocketteRankMap;
import edu.iris.Fissures.seed.container.SeedEncodingResolver;
import edu.iris.Fissures.seed.container.SeedObject;
import edu.iris.Fissures.seed.container.Waveform;
import edu.iris.Fissures.seed.exception.ContainerException;
import edu.iris.Fissures.seed.exception.SeedException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class SeedObjectContainer
implements ObjectContainer {
    private HashMap volume = null;
    private HashMap dictionary = null;
    private HashMap station = null;
    private HashMap timespan = null;
    private HashMap data = null;
    private Blockette locateRegister = null;
    private Blockette addRegister = null;
    private BlocketteVector rankLattice = null;
    private Iterator currentIterator = null;
    private RandomAccessFile diskStore = null;
    private LinkedList blocketteQueue = null;
    private int filterRank = 0;
    private int queueSize = 6;
    private HashMap encodingMap = null;
    private HashMap staChanMap = null;
    private HashMap parentChildMap = null;
    private HashMap dictionaryMatchMap = null;
    private int[] lastIdMap = new int[30];
    private boolean haveSetParent = false;

    public SeedObjectContainer() {
        this.volume = new HashMap();
        this.dictionary = new HashMap();
        this.station = new HashMap();
        this.timespan = new HashMap();
        this.data = new HashMap();
        this.encodingMap = new HashMap();
        this.rankLattice = new BlocketteVector(8, 8);
        this.blocketteQueue = new LinkedList();
        this.staChanMap = new HashMap();
        this.parentChildMap = new HashMap();
        this.dictionaryMatchMap = new HashMap();
    }

    public SeedObjectContainer(String storeFile) throws Exception {
        this();
        FileOutputStream fs = new FileOutputStream(storeFile);
        fs.close();
        this.diskStore = new RandomAccessFile(storeFile, "rw");
    }

    public void add(Object addThis) throws Exception {
        int addCategory;
        try {
            this.addRegister = (Blockette)addThis;
        }
        catch (Exception e) {
            String errStr = new String("Failure to cast added object as a Blockette");
            throw new ContainerException(errStr);
        }
        if (this.addRegister == null) {
            throw new ContainerException("add method was passed a null value");
        }
        int addRank = SeedBlocketteRankMap.getRank(this.addRegister);
        if (this.filterRank > 0) {
            if (addRank >= this.filterRank) {
                this.addRegister = null;
                return;
            }
            this.filterRank = 0;
        }
        this.rankLattice.setSize(addRank + 1);
        this.rankLattice.set(addRank, this.addRegister);
        if (addRank > 0) {
            Blockette parent = this.rankLattice.getBlockette(addRank - 1);
            if (parent == null) {
                throw new ContainerException("added child blockette does not have a parent blockette");
            }
            parent.addChildBlockette(this.addRegister);
            this.parentChildMap.put(new Integer(this.addRegister.getLookupId()), new Integer(parent.getLookupId()));
            int blkType = this.addRegister.getType();
            if (blkType == 52) {
                EncodeKey currentEncodeKey = new EncodeKey();
                currentEncodeKey.location = this.addRegister.toString(3);
                currentEncodeKey.channel = this.addRegister.toString(4);
                Btime encodeStartTime = new Btime(this.addRegister.toString(22));
                if (parent.getType() != 50) {
                    throw new ContainerException("Blockette 52 detected without Blockette 50 as parent. It was type: " + parent.getType());
                }
                currentEncodeKey.station = parent.toString(3);
                currentEncodeKey.network = parent.toString(16);
                this.addStaChanLookup(null, currentEncodeKey.channel, parent.getLookupId(), 3);
                this.addStaChanLookup(currentEncodeKey.station, currentEncodeKey.channel, parent.getLookupId(), 3);
                Blockette blk30 = this.getDictionaryBlockette(this.addRegister, 16);
                if (blk30 != null) {
                    String encodingStr = SeedEncodingResolver.resolve(blk30);
                    Vector encodingVec = null;
                    encodingVec = this.encodingMap.containsKey(currentEncodeKey.toString()) ? (Vector)this.encodingMap.get(currentEncodeKey.toString()) : new Vector(2, 2);
                    encodingVec.add(encodeStartTime);
                    encodingVec.add(encodingStr);
                    this.encodingMap.put(currentEncodeKey.toString(), encodingVec);
                }
            }
            if (blkType == 1000) {
                if (parent.getType() != 999) {
                    throw new ContainerException("Blockette 1000 detected without Blockette 999 as parent");
                }
                Waveform parentWaveform = parent.getWaveform();
                if (parentWaveform != null) {
                    parentWaveform.setEncoding(SeedEncodingResolver.translate(this.addRegister.toString(3)));
                }
            }
            if (this.diskStore != null && this.haveSetParent) {
                Blockette parentBlk = (Blockette)this.rankLattice.get(0);
                int parentBlkId = parentBlk.getLookupId();
                this.cacheFind(parentBlkId, true);
                this.enqueue(parentBlk);
                BlockettePlaceholder blkProxy = (BlockettePlaceholder)this.lookup(parentBlkId);
                if (blkProxy == null) {
                    throw new ContainerException("add: null lookup return for lookupId " + parentBlkId);
                }
                blkProxy.onDisk = false;
                blkProxy.isCached = true;
                this.haveSetParent = false;
            }
        } else {
            Waveform tempWaveform;
            int addCategory2 = SeedBlocketteRankMap.getHeaderCode(this.addRegister);
            Integer blocketteId = new Integer(this.addRegister.getLookupId());
            this.parentChildMap.put(blocketteId, new Integer(0));
            if (this.addRegister.getType() == 50) {
                this.addStaChanLookup(this.addRegister.toString(3), null, blocketteId, 3);
            }
            if (this.addRegister.getType() == 72) {
                this.addStaChanLookup(this.addRegister.toString(3), null, blocketteId, 4);
                this.addStaChanLookup(null, this.addRegister.toString(5), blocketteId, 4);
                this.addStaChanLookup(this.addRegister.toString(3), this.addRegister.toString(5), blocketteId, 4);
            }
            if (this.addRegister.getType() == 999) {
                this.addStaChanLookup(this.addRegister.toString(4), null, blocketteId, 5);
                this.addStaChanLookup(null, this.addRegister.toString(6), blocketteId, 5);
                this.addStaChanLookup(this.addRegister.toString(4), this.addRegister.toString(6), blocketteId, 5);
            }
            SeedObject addObj = this.addRegister;
            if (this.diskStore != null) {
                BlockettePlaceholder blkProxy = new BlockettePlaceholder();
                blkProxy.blkType = this.addRegister.getType();
                blkProxy.lookupId = blocketteId;
                blkProxy.isCached = true;
                addObj = blkProxy;
                Object blkCheck = this.lookup(blocketteId);
                if (blkCheck != null && blkCheck instanceof BlockettePlaceholder && ((BlockettePlaceholder)blkCheck).isCached) {
                    this.cacheFind(blocketteId, true);
                }
                this.enqueue(this.addRegister);
            }
            switch (addCategory2) {
                case 1: {
                    this.volume.put(blocketteId, addObj);
                    break;
                }
                case 2: {
                    this.dictionary.put(blocketteId, addObj);
                    break;
                }
                case 3: {
                    this.station.put(blocketteId, addObj);
                    break;
                }
                case 4: {
                    this.timespan.put(blocketteId, addObj);
                    break;
                }
                case 5: {
                    this.data.put(blocketteId, addObj);
                    break;
                }
                default: {
                    throw new ContainerException("attempted to add unknown category number: " + addCategory2);
                }
            }
            if (this.addRegister.getType() == 999 && (tempWaveform = this.addRegister.getWaveform()) != null && tempWaveform.getEncoding().equals("UNKNOWN")) {
                tempWaveform.setEncoding(this.getMetaEncoding(this.addRegister));
            }
        }
        int idMapIndex = addCategory = SeedBlocketteRankMap.getHeaderCode(this.addRegister);
        if (addCategory == 2) {
            idMapIndex = this.addRegister.getType() - 20;
        }
        if (this.lastIdMap[idMapIndex] < this.addRegister.getLookupId()) {
            this.lastIdMap[idMapIndex] = this.addRegister.getLookupId();
        }
        if (SeedBlocketteRankMap.getHeaderCode(this.addRegister) == 2) {
            this.dictionaryMatchMap.put(this.addRegister.toString(), new Integer(this.addRegister.getLookupId()));
        }
        this.addRegister = null;
        this.locateRegister = null;
    }

    public Blockette getDictionaryBlockette(Blockette blk, int fieldNum) throws Exception {
        return this.getDictionaryBlockette(blk, fieldNum, 0);
    }

    public Blockette getDictionaryBlockette(Blockette blk, int fieldNum, int fieldIndex) throws Exception {
        int refVal;
        int lookupId;
        String refStr = blk.toString(fieldNum, fieldIndex);
        if (refStr.length() == 0) {
            refStr = "0";
        }
        if ((lookupId = blk.getDictionaryLookup(refVal = Integer.parseInt(refStr))) > 0) {
            return (Blockette)this.get(lookupId);
        }
        return null;
    }

    public Blockette getDictionaryBlockette(Blockette blk, int fieldNum, int fieldIndex, int listIndex) throws Exception {
        int refVal;
        int lookupId;
        String refStr = blk.toString(fieldNum, fieldIndex);
        refStr = BlocketteFactory.getListValue(refStr, listIndex);
        if ((refStr = refStr.trim()).length() == 0) {
            refStr = "0";
        }
        if ((lookupId = blk.getDictionaryLookup(refVal = Integer.parseInt(refStr))) > 0) {
            return (Blockette)this.get(lookupId);
        }
        return null;
    }

    public Object get(int lookupId) throws ContainerException {
        if (this.locate(lookupId)) {
            return this.locateRegister;
        }
        return null;
    }

    public Object remove(int lookupId) throws ContainerException {
        Object blockette = this.improvedGet(lookupId);
        if (blockette != null) {
            if (this.isUsingSerialization()) {
                this.cacheFind(lookupId, true);
            }
            Integer lookupIdObj = new Integer(lookupId);
            this.volume.remove(lookupIdObj);
            this.dictionary.remove(lookupIdObj);
            this.station.remove(lookupIdObj);
            this.timespan.remove(lookupIdObj);
            this.data.remove(lookupIdObj);
            this.parentChildMap.remove(lookupIdObj);
            Object dictLookupObj = this.dictionaryMatchMap.get(blockette.toString());
            if (dictLookupObj != null && ((Integer)dictLookupObj).equals(lookupIdObj)) {
                this.dictionaryMatchMap.remove(blockette.toString());
            }
        }
        this.locateRegister = null;
        return blockette;
    }

    public boolean locate(int lookupId) throws ContainerException {
        Object locateObj = this.lookup(lookupId);
        if (locateObj != null && locateObj instanceof BlockettePlaceholder) {
            BlockettePlaceholder proxy = (BlockettePlaceholder)locateObj;
            if (proxy.isCached) {
                Blockette findBlockette = this.cacheFind(lookupId);
                if (findBlockette == null) {
                    throw new ContainerException("unable to locate blockette " + lookupId + " in cache queue");
                }
                this.locateRegister = findBlockette;
            } else {
                if (this.diskStore == null) {
                    throw new ContainerException("unable to access disk store for blockette proxy");
                }
                try {
                    this.diskStore.seek(proxy.offset);
                    byte[] serialBytes = new byte[proxy.length];
                    this.diskStore.readFully(serialBytes);
                    ByteArrayInputStream byteStream = new ByteArrayInputStream(serialBytes);
                    ObjectInputStream objIn = new ObjectInputStream(byteStream);
                    this.locateRegister = (Blockette)objIn.readObject();
                    byteStream.close();
                    objIn.close();
                }
                catch (Exception e) {
                    throw new ContainerException("disk storage exception encountered: " + e);
                }
                proxy.isCached = true;
                if (this.locateRegister.getLookupId() != lookupId) {
                    throw new ContainerException("lookupId mismatch between proxy " + lookupId + " and disk store " + this.locateRegister.getLookupId());
                }
                this.enqueue(this.locateRegister);
            }
        } else {
            this.locateRegister = (Blockette)locateObj;
        }
        return this.locateRegister != null;
    }

    public int iterate(int volNum, int catNum) {
        int target;
        int category;
        HashMap selectedMap = null;
        Vector pickVector = new Vector(8, 8);
        if (catNum == -1) {
            category = 1;
            target = 5;
        } else {
            category = catNum;
            target = catNum;
        }
        int curCat = category;
        while (curCat <= target) {
            switch (curCat) {
                case 1: {
                    selectedMap = this.volume;
                    break;
                }
                case 2: {
                    selectedMap = this.dictionary;
                    break;
                }
                case 3: {
                    selectedMap = this.station;
                    break;
                }
                case 4: {
                    selectedMap = this.timespan;
                    break;
                }
                case 5: {
                    selectedMap = this.data;
                    break;
                }
                default: {
                    this.currentIterator = null;
                    return 0;
                }
            }
            Set entries = selectedMap.entrySet();
            Iterator tempIterator = entries.iterator();
            while (tempIterator.hasNext()) {
                Map.Entry entry = tempIterator.next();
                Integer lookupIdObj = (Integer)entry.getKey();
                boolean meetsCriteria = false;
                if (volNum == -1) {
                    meetsCriteria = curCat == lookupIdObj / 1000000 % 10;
                } else {
                    boolean bl = meetsCriteria = volNum * 10 + category == lookupIdObj / 1000000;
                }
                if (!meetsCriteria) continue;
                Object blocketteRef = entry.getValue();
                pickVector.add(blocketteRef);
            }
            ++curCat;
        }
        Collections.sort(pickVector);
        this.currentIterator = pickVector.iterator();
        return pickVector.size();
    }

    public int iterate(int catNum) {
        return this.iterate(-1, catNum);
    }

    public int iterate() {
        return this.iterate(-1, -1);
    }

    public int iterate(Vector stations, Vector channels, int catNum) throws ContainerException {
        Vector mapVec;
        int i;
        if (stations == null && channels == null) {
            throw new ContainerException("attempted to map null station and channel");
        }
        if (catNum <= 0) {
            throw new ContainerException("category is zero or negative");
        }
        Vector lookupVec = new Vector(4, 4);
        if (stations == null) {
            i = 0;
            while (i < channels.size()) {
                StringBuffer mapStr = new StringBuffer();
                mapStr.append(catNum);
                mapStr.append(".");
                mapStr.append(channels.get(i).toString());
                mapVec = (Vector)this.staChanMap.get(mapStr.toString());
                if (mapVec != null) {
                    lookupVec.addAll(mapVec);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < stations.size()) {
                if (channels != null) {
                    int j = 0;
                    while (j < channels.size()) {
                        StringBuffer mapStr = new StringBuffer();
                        mapStr.append(catNum);
                        mapStr.append(".");
                        mapStr.append(stations.get(i).toString());
                        mapStr.append(".");
                        mapStr.append(channels.get(j).toString());
                        Vector mapVec2 = (Vector)this.staChanMap.get(mapStr.toString());
                        if (mapVec2 != null) {
                            lookupVec.addAll(mapVec2);
                        }
                        ++j;
                    }
                } else {
                    StringBuffer mapStr = new StringBuffer();
                    mapStr.append(catNum);
                    mapStr.append(".");
                    mapStr.append(stations.get(i).toString());
                    mapVec = (Vector)this.staChanMap.get(mapStr.toString());
                    if (mapVec != null) {
                        lookupVec.addAll(mapVec);
                    }
                }
                ++i;
            }
        }
        if (lookupVec == null) {
            return 0;
        }
        HashMap selectedMap = null;
        switch (catNum) {
            case 1: {
                selectedMap = this.volume;
                break;
            }
            case 2: {
                selectedMap = this.dictionary;
                break;
            }
            case 3: {
                selectedMap = this.station;
                break;
            }
            case 4: {
                selectedMap = this.timespan;
                break;
            }
            case 5: {
                selectedMap = this.data;
                break;
            }
            default: {
                this.currentIterator = null;
                return 0;
            }
        }
        Vector returnVec = new Vector(lookupVec.size());
        int i2 = 0;
        while (i2 < lookupVec.size()) {
            returnVec.add(selectedMap.get(lookupVec.get(i2)));
            ++i2;
        }
        Collections.sort(returnVec);
        this.currentIterator = returnVec.iterator();
        return returnVec.size();
    }

    public Object getNext() throws ContainerException {
        if (this.currentIterator == null) {
            return null;
        }
        if (this.currentIterator.hasNext()) {
            Object nextObj = this.currentIterator.next();
            if (nextObj instanceof BlockettePlaceholder) {
                if (!this.locate(((BlockettePlaceholder)nextObj).lookupId)) {
                    throw new ContainerException("Unable to locate() blockette for lookup ID " + ((BlockettePlaceholder)nextObj).lookupId);
                }
                nextObj = this.locateRegister;
            }
            return nextObj;
        }
        return null;
    }

    public void setFiltered(Blockette blk) throws Exception {
        int localRank = SeedBlocketteRankMap.getRank(blk);
        if (++localRank < this.filterRank || this.filterRank == 0) {
            this.filterRank = localRank;
        }
    }

    public void setFiltered(int value) {
        this.filterRank = value;
    }

    public int getFiltered() {
        return this.filterRank;
    }

    public void setQueueSize(int size) {
        this.queueSize = size;
    }

    public void flushQueue() {
    }

    public String getMetaEncoding(Blockette dataBlk) throws Exception {
        if (dataBlk == null) {
            throw new ContainerException("attempted to resolve encoding for null dataBlk");
        }
        if (dataBlk.getType() != 999) {
            throw new ContainerException("can only resolve encoding for an FSDH blockette");
        }
        EncodeKey dataKey = new EncodeKey();
        dataKey.station = dataBlk.toString(4);
        dataKey.location = dataBlk.toString(5);
        dataKey.channel = dataBlk.toString(6);
        dataKey.network = dataBlk.toString(7);
        Vector encodingVec = (Vector)this.encodingMap.get(dataKey.toString());
        String curEncoding = "UNKNOWN";
        if (encodingVec != null) {
            Btime dataTime = (Btime)dataBlk.getFieldVal(8);
            long prevDiff = -1L;
            long curDiff = 0L;
            int i = 0;
            while (i < encodingVec.size()) {
                curDiff = dataTime.diffSeconds((Btime)encodingVec.get(i));
                if (curDiff > 0L && curDiff < prevDiff || prevDiff == -1L) {
                    prevDiff = curDiff;
                    curEncoding = (String)encodingVec.get(i + 1);
                }
                i += 2;
            }
        }
        return curEncoding;
    }

    public void addStaChanLookup(String station, String channel, int lookupId, int category) throws ContainerException {
        Vector<Integer> mapVec;
        if (station == null && channel == null) {
            throw new ContainerException("attempted to map null station and channel");
        }
        if (lookupId <= 0) {
            throw new ContainerException("lookupId is zero or negative: " + lookupId);
        }
        if (category <= 0) {
            throw new ContainerException("category value is zero or negative: " + category);
        }
        StringBuffer mapStr = new StringBuffer();
        mapStr.append(category);
        mapStr.append(".");
        if (station != null) {
            mapStr.append(station);
        }
        if (station != null && channel != null) {
            mapStr.append(".");
        }
        if (channel != null) {
            mapStr.append(channel);
        }
        if ((mapVec = (Vector<Integer>)this.staChanMap.get(mapStr.toString())) == null) {
            mapVec = new Vector<Integer>(4, 4);
            this.staChanMap.put(mapStr.toString(), mapVec);
        }
        mapVec.add(new Integer(lookupId));
    }

    public void setParent(int lookupId) throws Exception {
        this.rankLattice.setSize(0);
        Integer parentLookupId = null;
        Integer curLookupId = new Integer(lookupId);
        Vector<Integer> parentVec = new Vector<Integer>(2, 2);
        while (curLookupId != null && curLookupId > 0) {
            parentLookupId = new Integer(curLookupId);
            parentVec.add(parentLookupId);
            curLookupId = (Integer)this.parentChildMap.get(parentLookupId);
        }
        Blockette parentBlk = (Blockette)this.get(parentLookupId);
        if (parentBlk == null || curLookupId == null) {
            throw new ContainerException("(setParent) unable to locate parent blockette " + lookupId);
        }
        int rankSize = parentVec.size();
        this.rankLattice.setSize(rankSize);
        Blockette childBlk = parentBlk;
        int i = 0;
        while (i < rankSize) {
            if (i > 0) {
                int childId = (Integer)parentVec.get(rankSize - i - 1);
                int numChildren = parentBlk.numberofChildBlockettes();
                boolean found = false;
                int j = 0;
                while (!found && j < numChildren) {
                    childBlk = parentBlk.getChildBlockette(j);
                    if (childBlk.getLookupId() == childId) {
                        found = true;
                    }
                    ++j;
                }
                if (!found && numChildren > 0) {
                    throw new ContainerException("(setParent) unable to locate blockette " + childId);
                }
            }
            this.rankLattice.set(i, childBlk);
            parentBlk = childBlk;
            this.haveSetParent = true;
            ++i;
        }
    }

    public boolean improvedLocate(int lookupId) {
        if (this.locateRegister != null && this.locateRegister.getLookupId() == lookupId) {
            return true;
        }
        try {
            this.setParent(lookupId);
            if (this.rankLattice.size() == 0) {
                return false;
            }
            this.locateRegister = (Blockette)this.rankLattice.get(this.rankLattice.size() - 1);
            if (this.locateRegister == null) {
                throw new Exception("improvedLocate(): pulled back null object");
            }
            if (lookupId != this.locateRegister.getLookupId()) {
                this.locateRegister = null;
                this.setParent(lookupId);
                if (this.rankLattice.size() > 0) {
                    this.locateRegister = (Blockette)this.rankLattice.get(this.rankLattice.size() - 1);
                }
                if (this.locateRegister == null) {
                    throw new Exception("improvedLocate(): pulled back null object");
                }
                if (lookupId != this.locateRegister.getLookupId()) {
                    throw new Exception("improvedLocate(): looked for id=" + lookupId + " and came back with id=" + this.locateRegister.getLookupId());
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.rankLattice.setSize(0);
            this.locateRegister = null;
            return false;
        }
    }

    public Object improvedGet(int lookupId) {
        if (this.improvedLocate(lookupId)) {
            return this.locateRegister;
        }
        return null;
    }

    public int getNewId(Blockette blk) throws Exception {
        int category = SeedBlocketteRankMap.getHeaderCode(blk);
        int lastId = 0;
        lastId = category == 2 ? this.lastIdMap[blk.getType() - 20] : this.lastIdMap[category];
        if (lastId == 0) {
            lastId = category * 1000 * 1000;
            if (category == 2) {
                lastId += blk.getType() * 1000 * 10;
            }
        }
        return lastId + 1;
    }

    public int findMatchingDictionary(String blocketteString) {
        Integer mapReturnInt = (Integer)this.dictionaryMatchMap.get(blocketteString);
        if (mapReturnInt == null) {
            return -1;
        }
        return mapReturnInt;
    }

    public boolean isUsingSerialization() {
        return this.diskStore != null;
    }

    public void commitChange(Blockette updatedBlockette) throws ContainerException {
        BlockettePlaceholder blkProxy;
        if (updatedBlockette == null) {
            throw new ContainerException("(commitChange) handed a null blockette");
        }
        if (!this.isUsingSerialization()) {
            return;
        }
        int updatedId = updatedBlockette.getLookupId();
        try {
            this.setParent(updatedId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ContainerException("(commitChange:setParent) id=" + updatedId + ": ");
        }
        int parentBlkId = ((Blockette)this.rankLattice.get(0)).getLookupId();
        Blockette blkToUpdate = (Blockette)this.rankLattice.get(this.rankLattice.size() - 1);
        if (blkToUpdate.getType() == updatedBlockette.getType() && !blkToUpdate.toString().equals(updatedBlockette.toString())) {
            try {
                blkToUpdate.setValuesFrom(updatedBlockette.toString());
            }
            catch (SeedException e) {
                throw new ContainerException("SeedException thrown by Blockette.setValuesFrom(): " + e);
            }
        }
        if ((blkProxy = (BlockettePlaceholder)this.lookup(parentBlkId)) == null) {
            throw new ContainerException("null lookup return for lookupId " + parentBlkId);
        }
        blkProxy.onDisk = false;
        blkProxy.isCached = true;
        this.locateRegister = null;
    }

    public void commitChange(Object updatedObject) throws ContainerException {
        this.commitChange((Blockette)updatedObject);
    }

    private Blockette cacheFind(int lookupId, boolean destroyFlag) throws ContainerException {
        if (this.blocketteQueue == null) {
            throw new ContainerException("cacheFind method encounters a null blocketteQueue");
        }
        ListIterator queueIterator = this.blocketteQueue.listIterator();
        while (queueIterator.hasNext()) {
            Blockette nextBlockette = (Blockette)queueIterator.next();
            if (nextBlockette == null || nextBlockette.getLookupId() != lookupId) continue;
            queueIterator.remove();
            if (destroyFlag) {
                BlockettePlaceholder proxy = (BlockettePlaceholder)this.lookup(lookupId);
                if (proxy != null) {
                    proxy.isCached = false;
                    proxy.onDisk = false;
                }
            } else {
                this.enqueue(nextBlockette);
            }
            return nextBlockette;
        }
        return null;
    }

    private Blockette cacheFind(int lookupId) throws ContainerException {
        return this.cacheFind(lookupId, false);
    }

    private void enqueue(Blockette blkt) throws ContainerException {
        if (this.blocketteQueue == null) {
            throw new ContainerException("enqueue method encounters a null blocketteQueue");
        }
        this.blocketteQueue.addFirst(blkt);
        while (this.blocketteQueue.size() > this.queueSize) {
            this.dequeue();
        }
    }

    private Blockette dequeue() throws ContainerException {
        int lookupId;
        BlockettePlaceholder blkProxy;
        if (this.blocketteQueue == null) {
            throw new ContainerException("dequeue method encounters a null blocketteQueue");
        }
        Blockette blkt = (Blockette)this.blocketteQueue.removeLast();
        if (blkt == null) {
            return null;
        }
        if (this.rankLattice.size() > 0 && blkt == this.rankLattice.getBlockette(0)) {
            this.blocketteQueue.addFirst(blkt);
            blkt = (Blockette)this.blocketteQueue.removeLast();
        }
        if ((blkProxy = (BlockettePlaceholder)this.lookup(lookupId = blkt.getLookupId())) == null) {
            throw new ContainerException("null lookup return for lookupId " + lookupId);
        }
        if (!blkProxy.onDisk) {
            try {
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                ObjectOutputStream objOut = new ObjectOutputStream(byteStream);
                objOut.writeObject(blkt);
                byte[] serialBytes = byteStream.toByteArray();
                this.diskStore.seek(this.diskStore.length());
                blkProxy.offset = this.diskStore.length();
                blkProxy.length = serialBytes.length;
                this.diskStore.write(serialBytes);
                objOut.flush();
                byteStream.flush();
                objOut.close();
                byteStream.close();
            }
            catch (Exception e) {
                throw new ContainerException("disk store exception encountered: " + e);
            }
            blkProxy.onDisk = true;
        }
        blkProxy.isCached = false;
        return blkt;
    }

    private Object lookup(int lookupId) {
        Integer lookupIdObj = new Integer(lookupId);
        Object hashGet = null;
        hashGet = this.volume.get(lookupIdObj);
        if (hashGet == null) {
            hashGet = this.dictionary.get(lookupIdObj);
        }
        if (hashGet == null) {
            hashGet = this.station.get(lookupIdObj);
        }
        if (hashGet == null) {
            hashGet = this.timespan.get(lookupIdObj);
        }
        if (hashGet == null) {
            hashGet = this.data.get(lookupIdObj);
        }
        return hashGet;
    }

    class EncodeKey {
        String station = null;
        String network = null;
        String channel = null;
        String location = null;

        EncodeKey() {
        }

        public String toString() {
            return "" + this.station + "." + this.network + "." + this.channel + "." + this.location;
        }
    }
}

