/*
 * Decompiled with CFR 0.152.
 */
package pickewanalysis.ewmessages;

import java.text.SimpleDateFormat;
import java.util.Date;
import pickewanalysis.ewmessages.EWMessage;

public class PickSCNL
extends EWMessage {
    public final int msgType = 8;
    public int instID;
    public int modID;
    public int seqNo;
    public String SCNL;
    public char FirstMotion;
    public int Weight;
    public double arrivalTime;
    public int[] peaks;
    public String Station;
    public String Channel;
    public String Network;
    public String Location;

    public PickSCNL(String rawMsg) throws Exception {
        this.parseRawMsg(rawMsg);
    }

    public PickSCNL(int modID, int instID, int seqNo, String SCNL, char FirstMotion, int Weight, double arrivalTime, int[] peaks) {
        this.instID = instID;
        this.modID = modID;
        this.seqNo = seqNo;
        this.SCNL = SCNL;
        String[] parts = SCNL.split("[\\s]+");
        this.Station = parts[0];
        this.Channel = parts[1];
        this.Network = parts[2];
        this.Location = parts[3];
        this.FirstMotion = FirstMotion;
        this.Weight = Weight;
        this.arrivalTime = arrivalTime;
        this.peaks = peaks;
    }

    public boolean parseRawMsg(String rawMsg) throws Exception {
        String[] parts = rawMsg.split("[\\s]+");
        int candidateType = Integer.valueOf(parts[0]);
        if (candidateType != this.msgType) {
            throw new Exception("Wrong message type.");
        }
        this.instID = Integer.valueOf(parts[2]);
        this.modID = Integer.valueOf(parts[1]);
        this.seqNo = Integer.valueOf(parts[3]);
        this.SCNL = parts[4].replace('.', ' ');
        String[] partsSCNL = this.SCNL.split("[\\s]+");
        this.Station = partsSCNL[0];
        this.Channel = partsSCNL[1];
        this.Network = partsSCNL[2];
        this.Location = partsSCNL[3];
        this.FirstMotion = parts[5].charAt(0);
        this.Weight = parts[5].charAt(1);
        this.arrivalTime = (double)new SimpleDateFormat("yyyyMMddHHmmss.SSS").parse(parts[6]).getTime() / 1000.0;
        this.peaks = new int[]{Integer.valueOf(parts[7]), Integer.valueOf(parts[8]), Integer.valueOf(parts[9])};
        return true;
    }

    public String getRawMsg() {
        return this.getRawMsg(this.seqNo);
    }

    public String toString() {
        return this.getRawMsg(this.seqNo);
    }

    public String getRawMsg(int customSeqNo) {
        return String.valueOf(8) + " " + String.valueOf(this.modID) + " " + String.valueOf(this.instID) + " " + String.valueOf(customSeqNo) + " " + this.SCNL.replace(' ', '.') + " " + (this.FirstMotion == ' ' ? (char)'?' : (char)this.FirstMotion) + this.Weight + " " + new SimpleDateFormat("yyyyMMddHHmmss.SSS").format(new Date((long)(this.arrivalTime * 1000.0))) + " " + String.valueOf(this.peaks[0]) + " " + String.valueOf(this.peaks[1]) + " " + String.valueOf(this.peaks[2]) + " ";
    }

    @Override
    public int getType() {
        return 8;
    }

    public byte[] getBytes() {
        return this.getRawMsg().getBytes();
    }
}

