/*
 * Decompiled with CFR 0.152.
 */
package pickewanalysis;

import java.text.SimpleDateFormat;
import javax.swing.table.AbstractTableModel;
import pickewanalysis.wavesources.WaveSource;
import pickewanalysis.wavesources.WaveSourceStation;

public class ConfigStationsListTableModel
extends AbstractTableModel {
    private WaveSource source;
    private String[] columnNames = new String[]{"Station", "Start", "End"};
    private final SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");

    public ConfigStationsListTableModel(WaveSource source) {
        this.source = source;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.source == null) {
            return 0;
        }
        return this.source.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.source.isEmpty()) {
            return null;
        }
        switch (col) {
            case 0: {
                return ((WaveSourceStation)this.source.get(row)).getStation() + "." + ((WaveSourceStation)this.source.get(row)).getChannel() + "." + ((WaveSourceStation)this.source.get(row)).getNetwork() + "." + ((WaveSourceStation)this.source.get(row)).getLocation();
            }
            case 1: {
                return this.df.format(((WaveSourceStation)this.source.get(row)).getStartTime());
            }
            case 2: {
                return this.df.format(((WaveSourceStation)this.source.get(row)).getEndTime());
            }
        }
        return null;
    }

    public Class getColumnClass(int c) {
        return WaveSourceStation.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }
}

