/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.BlocketteUnknown;
import java.io.IOException;
import java.io.PrintWriter;

public class PartialBlockette
extends BlocketteUnknown {
    int totalBytes;
    int priorBytes;
    int bytesRead;

    public PartialBlockette(int type, byte[] info, boolean swapBytes, int priorBytes, int totalBytes) {
        super(info, type, swapBytes);
        this.bytesRead = info.length;
        this.priorBytes = priorBytes;
        this.totalBytes = totalBytes;
    }

    public void writeASCII(PrintWriter out) throws IOException {
        String infoStr = new String(this.info);
        out.print("Partial Blockette " + this.getType() + ", " + this.bytesRead + " of " + this.bytesRead + "+" + this.priorBytes + " of " + this.totalBytes + " bytes: " + infoStr);
    }

    public boolean isBegin() {
        return this.priorBytes == 0;
    }

    public boolean isEnd() {
        return this.priorBytes + this.bytesRead == this.totalBytes;
    }

    public int getTotalSize() {
        return this.totalBytes;
    }

    public int getPriorSize() {
        return this.priorBytes;
    }

    public int getSoFarSize() {
        return this.priorBytes + this.bytesRead;
    }

    public int getBytesRead() {
        return this.bytesRead;
    }
}

