/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.dmc.seedcodec;

import edu.iris.dmc.seedcodec.CodecException;
import edu.iris.dmc.seedcodec.Utility;

public class Cdsn {
    public static final int MANTISSA_MASK = 16383;
    public static final int GAINRANGE_MASK = 3;
    public static final int SHIFT = 14;
    public static final int MAX14 = 8191;

    public static int[] decode(byte[] b, int numSamples, boolean swapBytes) throws CodecException {
        if (b.length < numSamples * 2) {
            throw new CodecException("Not enough bytes for " + numSamples + " samples, need " + 2 * numSamples + " but only have " + b.length);
        }
        int[] out = new int[numSamples];
        for (int j = 0; j < out.length; ++j) {
            int mult = 0;
            short temp = Utility.bytesToShort(b[2 * j], b[2 * j + 1], swapBytes);
            int mantissa = temp & 0x3FFF;
            int gainrange = temp >> 14 & 3;
            if (gainrange == 0) {
                mult = 0;
            } else if (gainrange == 1) {
                mult = 2;
            } else if (gainrange == 2) {
                mult = 4;
            } else if (gainrange == 3) {
                mult = 7;
            }
            out[j] = (mantissa -= 8191) << mult;
        }
        return out;
    }
}

