/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.builder;

import edu.iris.Fissures.seed.builder.BuilderFilter;
import edu.iris.Fissures.seed.builder.ObjectBuilder;
import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.container.BlocketteFactory;
import edu.iris.Fissures.seed.container.Btime;
import edu.iris.Fissures.seed.container.SeedBlocketteRankMap;
import edu.iris.Fissures.seed.container.SeedDictionaryReferenceMap;
import edu.iris.Fissures.seed.container.SeedObjectContainer;
import edu.iris.Fissures.seed.container.Waveform;
import edu.iris.Fissures.seed.exception.BuilderException;
import java.io.Serializable;
import java.util.Vector;

public class SeedObjectBuilder
extends ObjectBuilder {
    private byte[] prevRecord;
    private static final float defaultSeedVersion = BlocketteFactory.getDefaultVersion();
    private float seedVersion = defaultSeedVersion;
    private boolean swapFlag = false;
    private int[] sequenceTracker = new int[]{0, 0, 0, 0, 0, 0, 0};
    private int dataBlocketteOffset = 0;
    protected Blockette recycleBlockette = null;

    public SeedObjectBuilder() {
        this.buildContainer = new SeedObjectContainer();
        this.builderType = "SEED";
    }

    public SeedObjectBuilder(String diskFile) throws BuilderException {
        try {
            this.buildContainer = new SeedObjectContainer(diskFile);
            this.builderType = "SEED";
        }
        catch (Exception e) {
            throw new BuilderException("Exception encountered: " + e);
        }
    }

    public int build(byte[] nextRecord) throws Exception {
        if (nextRecord.length == 0) {
            throw new BuilderException("zero length record data in build() call");
        }
        byte[] currentRecord = nextRecord;
        int numBytesRead = 0;
        Blockette newBlockette = null;
        switch (this.recordType) {
            case 'A': 
            case 'S': 
            case 'T': 
            case 'V': {
                if (this.prevRecord != null && this.continuationFlag) {
                    currentRecord = new byte[this.prevRecord.length + nextRecord.length];
                    System.arraycopy(this.prevRecord, 0, currentRecord, 0, this.prevRecord.length);
                    System.arraycopy(nextRecord, 0, currentRecord, this.prevRecord.length, nextRecord.length);
                }
                if (this.recycleBlockette != null) {
                    this.recycleBlockette.initialize(currentRecord, false, false, this.seedVersion);
                    newBlockette = this.recycleBlockette;
                } else {
                    newBlockette = BlocketteFactory.createBlockette(currentRecord, false, false, this.seedVersion);
                }
                if (newBlockette == null) {
                    throw new BuilderException("Blockette Factory returned a null value");
                }
                int blocketteNumber = newBlockette.getType();
                if (blocketteNumber == 5 || blocketteNumber == 8 || blocketteNumber == 10) {
                    this.seedVersion = Float.parseFloat(newBlockette.toString(3));
                    newBlockette.initialize(currentRecord, false, false, this.seedVersion);
                }
                if (newBlockette.isIncomplete()) {
                    this.prevRecord = new byte[currentRecord.length];
                    System.arraycopy(currentRecord, 0, this.prevRecord, 0, currentRecord.length);
                    numBytesRead = currentRecord.length;
                    this.currentObject = null;
                    this.recycleBlockette = newBlockette;
                    break;
                }
                numBytesRead = this.prevRecord == null ? newBlockette.getNumBytes() : newBlockette.getNumBytes() - this.prevRecord.length;
                this.prevRecord = null;
                this.currentObject = newBlockette;
                break;
            }
            case 'D': 
            case 'Q': 
            case 'R': {
                this.prevRecord = null;
                if (this.recordBeginFlag) {
                    this.dataBlocketteOffset = 0;
                    if (currentRecord.length < 40) {
                        throw new BuilderException("data record is too short (" + currentRecord.length + ")");
                    }
                    byte[] timeArr = new byte[10];
                    System.arraycopy(currentRecord, 12, timeArr, 0, 10);
                    Btime bTime = new Btime(timeArr);
                    this.swapFlag = bTime.getSwapFlag();
                    byte[] blocketteNumByte = new byte[2];
                    if (this.swapFlag) {
                        blocketteNumByte[0] = -25;
                        blocketteNumByte[1] = 3;
                    } else {
                        blocketteNumByte[0] = 3;
                        blocketteNumByte[1] = -25;
                    }
                    byte[] dQFlags = new byte[8];
                    dQFlags[0] = (byte)this.recordType;
                    this.continuationFlag = dQFlags[1] == 42;
                    int i = 2;
                    while (i < 8) {
                        dQFlags[i] = 32;
                        ++i;
                    }
                    Btime createTime = new Btime();
                    currentRecord = new byte[nextRecord.length + 20];
                    System.arraycopy(blocketteNumByte, 0, currentRecord, 0, 2);
                    System.arraycopy(dQFlags, 0, currentRecord, 2, 8);
                    System.arraycopy(createTime.getByteTime(), 0, currentRecord, 10, 10);
                    System.arraycopy(nextRecord, 0, currentRecord, 20, nextRecord.length);
                    this.recordBeginFlag = false;
                }
                if (this.recycleBlockette != null) {
                    this.recycleBlockette.initialize(currentRecord, this.swapFlag, true, this.seedVersion);
                    newBlockette = this.recycleBlockette;
                } else {
                    newBlockette = BlocketteFactory.createBlockette(currentRecord, this.swapFlag, true, this.seedVersion);
                }
                if (newBlockette == null) {
                    throw new BuilderException("Blockette Factory returned a null value");
                }
                if (newBlockette.getType() == 999) {
                    int waveformOffset;
                    this.dataBlocketteOffset = Integer.parseInt(newBlockette.toString(18));
                    numBytesRead = this.dataBlocketteOffset - 8;
                    if (this.dataBlocketteOffset == 0) {
                        numBytesRead = currentRecord.length;
                    }
                    if ((waveformOffset = Integer.parseInt(newBlockette.toString(17))) > 48) {
                        int numSamples = Integer.parseInt(newBlockette.toString(9));
                        Waveform newWaveform = new Waveform(currentRecord, waveformOffset + 12, numSamples, "UNKNOWN", this.swapFlag);
                        newBlockette.attachWaveform(newWaveform);
                    }
                } else {
                    int nextBlockette = Integer.parseInt(newBlockette.toString(2));
                    if (nextBlockette > 0) {
                        numBytesRead = nextBlockette - this.dataBlocketteOffset;
                        if (numBytesRead <= 0) {
                            throw new BuilderException("regressive data blockette offset " + nextBlockette + " at byte offset " + this.dataBlocketteOffset);
                        }
                        this.dataBlocketteOffset = nextBlockette;
                    } else {
                        numBytesRead = currentRecord.length;
                    }
                }
                this.currentObject = newBlockette;
                break;
            }
            default: {
                throw new BuilderException("Unable to identify recordType" + this.recordType);
            }
        }
        this.filterBlockette();
        return numBytesRead;
    }

    public int build(String blocketteSpec) throws Exception {
        if (blocketteSpec == null) {
            throw new BuilderException("blockette specification string in build() call is null");
        }
        int numBytesRead = blocketteSpec.length();
        if (numBytesRead == 0) {
            throw new BuilderException("zero length blockette specification string in build() call");
        }
        this.currentObject = BlocketteFactory.createBlockette(blocketteSpec);
        if (this.currentObject == null) {
            throw new BuilderException("Blockette Factory returned a null value");
        }
        this.filterBlockette();
        return numBytesRead;
    }

    public int store() throws Exception {
        if (this.currentObject == null) {
            return -1;
        }
        if (this.volumeNumber > 214) {
            throw new BuilderException("volumeNumber is too high.  must be value 000-214");
        }
        int volumeVal = this.volumeNumber * 1000 * 1000 * 10;
        int headerCategory = SeedBlocketteRankMap.getHeaderCode((Blockette)this.currentObject);
        int headerVal = headerCategory * 1000 * 1000;
        if (headerCategory > 6) {
            throw new BuilderException("header category code for lookup ID exceeds 6");
        }
        int blocketteNumber = ((Blockette)this.currentObject).getType();
        int lookupId = -1;
        if (headerCategory == 2) {
            int refField = SeedDictionaryReferenceMap.lookupDestFld(blocketteNumber);
            int refIndexNum = Integer.parseInt(((Blockette)this.currentObject).toString(refField));
            int bTypeNumber = blocketteNumber;
            if (blocketteNumber > 39 && blocketteNumber < 50) {
                bTypeNumber = 40;
            }
            lookupId = volumeVal + headerVal + bTypeNumber * 1000 * 10 + refIndexNum;
        } else {
            int sequenceNum = this.getSequenceNum(headerCategory);
            if (sequenceNum > 999999) {
                throw new BuilderException("sequence number for lookup ID exceeds 999999");
            }
            lookupId = volumeVal + headerVal + sequenceNum;
        }
        ((Blockette)this.currentObject).setLookupId(lookupId);
        int[] lookupFields = SeedDictionaryReferenceMap.lookupSourceFld(blocketteNumber);
        int i = 0;
        while (lookupFields != null && i < lookupFields.length) {
            int[] lookupDictBlk = SeedDictionaryReferenceMap.lookupDestBlk(blocketteNumber, lookupFields[i]);
            int repeatFld = ((Blockette)this.currentObject).getFieldRepeat(lookupFields[i]);
            int numRepeat = 0;
            if (((Blockette)this.currentObject).getFieldType(lookupFields[i]).equals("L")) {
                repeatFld = ((Blockette)this.currentObject).getFieldRepeat(repeatFld);
            }
            numRepeat = repeatFld == 0 ? 1 : Integer.parseInt(((Blockette)this.currentObject).toString(repeatFld));
            Vector dictLookupVect = null;
            int[] dictLookupArr = null;
            Serializable saveLookupIndex = null;
            int k = 0;
            while (k < numRepeat) {
                int m;
                if (((Blockette)this.currentObject).getFieldType(lookupFields[i]).equals("L")) {
                    dictLookupVect = (Vector)((Blockette)this.currentObject).getFieldVal(lookupFields[i], k);
                    dictLookupArr = new int[dictLookupVect.size()];
                    m = 0;
                    while (m < dictLookupVect.size()) {
                        dictLookupArr[m] = Integer.parseInt(dictLookupVect.get(m).toString());
                        ++m;
                    }
                } else {
                    dictLookupArr = new int[1];
                    String dictLookupStr = ((Blockette)this.currentObject).toString(lookupFields[i], k);
                    if (dictLookupStr.length() == 0) {
                        dictLookupStr = "0";
                    }
                    dictLookupArr[0] = Integer.parseInt(dictLookupStr);
                }
                m = 0;
                while (m < dictLookupArr.length) {
                    int dictLookupVal = dictLookupArr[m];
                    int lookupIndex = 0;
                    if (dictLookupVal > 0) {
                        int bTypeNumber = lookupDictBlk[0];
                        if (bTypeNumber > 39 && bTypeNumber < 50) {
                            bTypeNumber = 40;
                        }
                        int dictLookupId = volumeVal + 2000000 + bTypeNumber * 1000 * 10 + dictLookupVal;
                        lookupIndex = ((Blockette)this.currentObject).addDictionaryLookup(dictLookupId);
                    }
                    if (dictLookupArr.length > 1) {
                        dictLookupVect.set(m, new Integer(lookupIndex));
                        saveLookupIndex = dictLookupVect;
                    } else {
                        saveLookupIndex = new Integer(lookupIndex);
                    }
                    ++m;
                }
                ((Blockette)this.currentObject).setFieldVal(lookupFields[i], k, saveLookupIndex);
                ++k;
            }
            ++i;
        }
        this.buildContainer.add(this.currentObject);
        this.recycleBlockette = null;
        this.currentObject = null;
        return lookupId;
    }

    public void reset() {
        this.currentObject = null;
        this.prevRecord = null;
        this.seedVersion = defaultSeedVersion;
        this.swapFlag = false;
        int i = 0;
        while (i < this.sequenceTracker.length) {
            this.sequenceTracker[i] = 0;
            ++i;
        }
    }

    private boolean filterBlockette() throws Exception {
        int vecSize = this.buildFilterVector.size();
        boolean match = false;
        if (this.currentObject != null && vecSize != 0) {
            int i = 0;
            while (i < vecSize) {
                BuilderFilter buildFilter = (BuilderFilter)this.buildFilterVector.get(i);
                match = buildFilter.qualify(this.currentObject);
                if (match) break;
                ++i;
            }
            int filterRank = ((SeedObjectContainer)this.buildContainer).getFiltered();
            int blkRank = SeedBlocketteRankMap.getRank((Blockette)this.currentObject);
            if (filterRank > 0 && blkRank >= filterRank) {
                match = false;
            }
            if (!match) {
                ((SeedObjectContainer)this.buildContainer).setFiltered((Blockette)this.currentObject);
                this.recycleBlockette = (Blockette)this.currentObject;
                this.currentObject = null;
            } else if (filterRank > 0) {
                ((SeedObjectContainer)this.buildContainer).setFiltered(0);
            }
        }
        return match;
    }

    protected int getSequenceNum(int headerCode) throws BuilderException {
        if (headerCode > 6) {
            throw new BuilderException("header code greater than 6");
        }
        int sequenceNum = this.sequenceTracker[headerCode];
        int n = headerCode;
        this.sequenceTracker[n] = this.sequenceTracker[n] + 1;
        return sequenceNum;
    }
}

